/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct VREvent_Process_t")
public class VREventProcess
extends Struct<VREventProcess> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PID;
    public static final int OLDPID;
    public static final int BFORCED;
    public static final int BCONNECTIONLOST;

    protected VREventProcess(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VREventProcess create(long address, @Nullable ByteBuffer container) {
        return new VREventProcess(address, container);
    }

    public VREventProcess(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VREventProcess.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int pid() {
        return VREventProcess.npid(this.address());
    }

    @NativeType(value="uint32_t")
    public int oldPid() {
        return VREventProcess.noldPid(this.address());
    }

    @NativeType(value="bool")
    public boolean bForced() {
        return VREventProcess.nbForced(this.address());
    }

    @NativeType(value="bool")
    public boolean bConnectionLost() {
        return VREventProcess.nbConnectionLost(this.address());
    }

    public static VREventProcess create(long address) {
        return new VREventProcess(address, null);
    }

    public static @Nullable VREventProcess createSafe(long address) {
        return address == 0L ? null : new VREventProcess(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static int npid(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)PID));
    }

    public static int noldPid(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)OLDPID));
    }

    public static boolean nbForced(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)BFORCED)) != 0;
    }

    public static boolean nbConnectionLost(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)BCONNECTIONLOST)) != 0;
    }

    static {
        Struct.Layout layout = VREventProcess.__struct((Struct.Member[])new Struct.Member[]{VREventProcess.__member((int)4), VREventProcess.__member((int)4), VREventProcess.__member((int)1), VREventProcess.__member((int)1)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PID = layout.offsetof(0);
        OLDPID = layout.offsetof(1);
        BFORCED = layout.offsetof(2);
        BCONNECTIONLOST = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VREventProcess, Buffer> {
        private static final VREventProcess ELEMENT_FACTORY = VREventProcess.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VREventProcess getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int pid() {
            return VREventProcess.npid(this.address());
        }

        @NativeType(value="uint32_t")
        public int oldPid() {
            return VREventProcess.noldPid(this.address());
        }

        @NativeType(value="bool")
        public boolean bForced() {
            return VREventProcess.nbForced(this.address());
        }

        @NativeType(value="bool")
        public boolean bConnectionLost() {
            return VREventProcess.nbConnectionLost(this.address());
        }
    }
}

