/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openvr.OpenVR;
import org.lwjgl.openvr.RenderModel;
import org.lwjgl.openvr.RenderModelComponentState;
import org.lwjgl.openvr.RenderModelControllerModeState;
import org.lwjgl.openvr.RenderModelTextureMap;
import org.lwjgl.openvr.VRControllerState;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;

public class VRRenderModels {
    protected VRRenderModels() {
        throw new UnsupportedOperationException();
    }

    public static int nVRRenderModels_LoadRenderModel_Async(long pchRenderModelName, long ppRenderModel) {
        long __functionAddress = OpenVR.VRRenderModels.LoadRenderModel_Async;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((long)pchRenderModelName, (long)ppRenderModel, (long)__functionAddress);
    }

    @NativeType(value="EVRRenderModelError")
    public static int VRRenderModels_LoadRenderModel_Async(@NativeType(value="char const *") ByteBuffer pchRenderModelName, @NativeType(value="RenderModel_t **") PointerBuffer ppRenderModel) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)pchRenderModelName);
            Checks.check((CustomBuffer)ppRenderModel, (int)1);
        }
        return VRRenderModels.nVRRenderModels_LoadRenderModel_Async(MemoryUtil.memAddress((ByteBuffer)pchRenderModelName), MemoryUtil.memAddress((CustomBuffer)ppRenderModel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="EVRRenderModelError")
    public static int VRRenderModels_LoadRenderModel_Async(@NativeType(value="char const *") CharSequence pchRenderModelName, @NativeType(value="RenderModel_t **") PointerBuffer ppRenderModel) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)ppRenderModel, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchRenderModelName, true);
            long pchRenderModelNameEncoded = stack.getPointerAddress();
            int n = VRRenderModels.nVRRenderModels_LoadRenderModel_Async(pchRenderModelNameEncoded, MemoryUtil.memAddress((CustomBuffer)ppRenderModel));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nVRRenderModels_FreeRenderModel(long pRenderModel) {
        long __functionAddress = OpenVR.VRRenderModels.FreeRenderModel;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)pRenderModel, (long)__functionAddress);
    }

    public static void VRRenderModels_FreeRenderModel(@NativeType(value="RenderModel_t *") @Nullable RenderModel pRenderModel) {
        VRRenderModels.nVRRenderModels_FreeRenderModel(MemoryUtil.memAddressSafe((Pointer)pRenderModel));
    }

    public static int nVRRenderModels_LoadTexture_Async(int textureId, long ppTexture) {
        long __functionAddress = OpenVR.VRRenderModels.LoadTexture_Async;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPI((int)textureId, (long)ppTexture, (long)__functionAddress);
    }

    @NativeType(value="EVRRenderModelError")
    public static int VRRenderModels_LoadTexture_Async(@NativeType(value="TextureID_t") int textureId, @NativeType(value="RenderModel_TextureMap_t **") PointerBuffer ppTexture) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)ppTexture, (int)1);
        }
        return VRRenderModels.nVRRenderModels_LoadTexture_Async(textureId, MemoryUtil.memAddress((CustomBuffer)ppTexture));
    }

    public static void nVRRenderModels_FreeTexture(long pTexture) {
        long __functionAddress = OpenVR.VRRenderModels.FreeTexture;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.callPV((long)pTexture, (long)__functionAddress);
    }

    public static void VRRenderModels_FreeTexture(@NativeType(value="RenderModel_TextureMap_t *") @Nullable RenderModelTextureMap pTexture) {
        VRRenderModels.nVRRenderModels_FreeTexture(MemoryUtil.memAddressSafe((Pointer)pTexture));
    }

    public static int nVRRenderModels_LoadTextureD3D11_Async(int textureId, long pD3D11Device, long ppD3D11Texture2D) {
        long __functionAddress = OpenVR.VRRenderModels.LoadTextureD3D11_Async;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)pD3D11Device);
        }
        return JNI.callPPI((int)textureId, (long)pD3D11Device, (long)ppD3D11Texture2D, (long)__functionAddress);
    }

    @NativeType(value="EVRRenderModelError")
    public static int VRRenderModels_LoadTextureD3D11_Async(@NativeType(value="TextureID_t") int textureId, @NativeType(value="void *") long pD3D11Device, @NativeType(value="void **") PointerBuffer ppD3D11Texture2D) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)ppD3D11Texture2D, (int)1);
        }
        return VRRenderModels.nVRRenderModels_LoadTextureD3D11_Async(textureId, pD3D11Device, MemoryUtil.memAddress((CustomBuffer)ppD3D11Texture2D));
    }

    @NativeType(value="EVRRenderModelError")
    public static int VRRenderModels_LoadIntoTextureD3D11_Async(@NativeType(value="TextureID_t") int textureId, @NativeType(value="void *") long pDstTexture) {
        long __functionAddress = OpenVR.VRRenderModels.LoadIntoTextureD3D11_Async;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)pDstTexture);
        }
        return JNI.callPI((int)textureId, (long)pDstTexture, (long)__functionAddress);
    }

    public static void VRRenderModels_FreeTextureD3D11(@NativeType(value="void *") long pD3D11Texture2D) {
        long __functionAddress = OpenVR.VRRenderModels.FreeTextureD3D11;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)pD3D11Texture2D);
        }
        JNI.callPV((long)pD3D11Texture2D, (long)__functionAddress);
    }

    public static int nVRRenderModels_GetRenderModelName(int unRenderModelIndex, long pchRenderModelName, int unRenderModelNameLen) {
        long __functionAddress = OpenVR.VRRenderModels.GetRenderModelName;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPI((int)unRenderModelIndex, (long)pchRenderModelName, (int)unRenderModelNameLen, (long)__functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int VRRenderModels_GetRenderModelName(@NativeType(value="uint32_t") int unRenderModelIndex, @NativeType(value="char *") @Nullable ByteBuffer pchRenderModelName) {
        return VRRenderModels.nVRRenderModels_GetRenderModelName(unRenderModelIndex, MemoryUtil.memAddressSafe((ByteBuffer)pchRenderModelName), Checks.remainingSafe((Buffer)pchRenderModelName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="uint32_t")
    public static String VRRenderModels_GetRenderModelName(@NativeType(value="uint32_t") int unRenderModelIndex, @NativeType(value="uint32_t") int unRenderModelNameLen) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchRenderModelName = stack.malloc(unRenderModelNameLen);
            int __result = VRRenderModels.nVRRenderModels_GetRenderModelName(unRenderModelIndex, MemoryUtil.memAddress((ByteBuffer)pchRenderModelName), unRenderModelNameLen);
            String string = MemoryUtil.memASCII((ByteBuffer)pchRenderModelName, (int)(__result - 1));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="uint32_t")
    public static int VRRenderModels_GetRenderModelCount() {
        long __functionAddress = OpenVR.VRRenderModels.GetRenderModelCount;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callI((long)__functionAddress);
    }

    public static int nVRRenderModels_GetComponentCount(long pchRenderModelName) {
        long __functionAddress = OpenVR.VRRenderModels.GetComponentCount;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPI((long)pchRenderModelName, (long)__functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int VRRenderModels_GetComponentCount(@NativeType(value="char const *") ByteBuffer pchRenderModelName) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)pchRenderModelName);
        }
        return VRRenderModels.nVRRenderModels_GetComponentCount(MemoryUtil.memAddress((ByteBuffer)pchRenderModelName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="uint32_t")
    public static int VRRenderModels_GetComponentCount(@NativeType(value="char const *") CharSequence pchRenderModelName) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchRenderModelName, true);
            long pchRenderModelNameEncoded = stack.getPointerAddress();
            int n = VRRenderModels.nVRRenderModels_GetComponentCount(pchRenderModelNameEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRRenderModels_GetComponentName(long pchRenderModelName, int unComponentIndex, long pchComponentName, int unComponentNameLen) {
        long __functionAddress = OpenVR.VRRenderModels.GetComponentName;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((long)pchRenderModelName, (int)unComponentIndex, (long)pchComponentName, (int)unComponentNameLen, (long)__functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int VRRenderModels_GetComponentName(@NativeType(value="char const *") ByteBuffer pchRenderModelName, @NativeType(value="uint32_t") int unComponentIndex, @NativeType(value="char *") @Nullable ByteBuffer pchComponentName) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)pchRenderModelName);
        }
        return VRRenderModels.nVRRenderModels_GetComponentName(MemoryUtil.memAddress((ByteBuffer)pchRenderModelName), unComponentIndex, MemoryUtil.memAddressSafe((ByteBuffer)pchComponentName), Checks.remainingSafe((Buffer)pchComponentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="uint32_t")
    public static int VRRenderModels_GetComponentName(@NativeType(value="char const *") CharSequence pchRenderModelName, @NativeType(value="uint32_t") int unComponentIndex, @NativeType(value="char *") @Nullable ByteBuffer pchComponentName) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchRenderModelName, true);
            long pchRenderModelNameEncoded = stack.getPointerAddress();
            int n = VRRenderModels.nVRRenderModels_GetComponentName(pchRenderModelNameEncoded, unComponentIndex, MemoryUtil.memAddressSafe((ByteBuffer)pchComponentName), Checks.remainingSafe((Buffer)pchComponentName));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="uint32_t")
    public static String VRRenderModels_GetComponentName(@NativeType(value="char const *") CharSequence pchRenderModelName, @NativeType(value="uint32_t") int unComponentIndex, @NativeType(value="uint32_t") int unComponentNameLen) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchRenderModelName, true);
            long pchRenderModelNameEncoded = stack.getPointerAddress();
            ByteBuffer pchComponentName = stack.malloc(unComponentNameLen);
            int __result = VRRenderModels.nVRRenderModels_GetComponentName(pchRenderModelNameEncoded, unComponentIndex, MemoryUtil.memAddress((ByteBuffer)pchComponentName), unComponentNameLen);
            String string = MemoryUtil.memASCII((ByteBuffer)pchComponentName, (int)(__result - 1));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nVRRenderModels_GetComponentButtonMask(long pchRenderModelName, long pchComponentName) {
        long __functionAddress = OpenVR.VRRenderModels.GetComponentButtonMask;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPJ((long)pchRenderModelName, (long)pchComponentName, (long)__functionAddress);
    }

    @NativeType(value="uint64_t")
    public static long VRRenderModels_GetComponentButtonMask(@NativeType(value="char const *") ByteBuffer pchRenderModelName, @NativeType(value="char const *") ByteBuffer pchComponentName) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)pchRenderModelName);
            Checks.checkNT1((ByteBuffer)pchComponentName);
        }
        return VRRenderModels.nVRRenderModels_GetComponentButtonMask(MemoryUtil.memAddress((ByteBuffer)pchRenderModelName), MemoryUtil.memAddress((ByteBuffer)pchComponentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="uint64_t")
    public static long VRRenderModels_GetComponentButtonMask(@NativeType(value="char const *") CharSequence pchRenderModelName, @NativeType(value="char const *") CharSequence pchComponentName) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchRenderModelName, true);
            long pchRenderModelNameEncoded = stack.getPointerAddress();
            stack.nASCII(pchComponentName, true);
            long pchComponentNameEncoded = stack.getPointerAddress();
            long l = VRRenderModels.nVRRenderModels_GetComponentButtonMask(pchRenderModelNameEncoded, pchComponentNameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRRenderModels_GetComponentRenderModelName(long pchRenderModelName, long pchComponentName, long pchComponentRenderModelName, int unComponentRenderModelNameLen) {
        long __functionAddress = OpenVR.VRRenderModels.GetComponentRenderModelName;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPI((long)pchRenderModelName, (long)pchComponentName, (long)pchComponentRenderModelName, (int)unComponentRenderModelNameLen, (long)__functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int VRRenderModels_GetComponentRenderModelName(@NativeType(value="char const *") ByteBuffer pchRenderModelName, @NativeType(value="char const *") ByteBuffer pchComponentName, @NativeType(value="char *") @Nullable ByteBuffer pchComponentRenderModelName) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)pchRenderModelName);
            Checks.checkNT1((ByteBuffer)pchComponentName);
        }
        return VRRenderModels.nVRRenderModels_GetComponentRenderModelName(MemoryUtil.memAddress((ByteBuffer)pchRenderModelName), MemoryUtil.memAddress((ByteBuffer)pchComponentName), MemoryUtil.memAddressSafe((ByteBuffer)pchComponentRenderModelName), Checks.remainingSafe((Buffer)pchComponentRenderModelName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="uint32_t")
    public static int VRRenderModels_GetComponentRenderModelName(@NativeType(value="char const *") CharSequence pchRenderModelName, @NativeType(value="char const *") CharSequence pchComponentName, @NativeType(value="char *") @Nullable ByteBuffer pchComponentRenderModelName) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchRenderModelName, true);
            long pchRenderModelNameEncoded = stack.getPointerAddress();
            stack.nASCII(pchComponentName, true);
            long pchComponentNameEncoded = stack.getPointerAddress();
            int n = VRRenderModels.nVRRenderModels_GetComponentRenderModelName(pchRenderModelNameEncoded, pchComponentNameEncoded, MemoryUtil.memAddressSafe((ByteBuffer)pchComponentRenderModelName), Checks.remainingSafe((Buffer)pchComponentRenderModelName));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="uint32_t")
    public static String VRRenderModels_GetComponentRenderModelName(@NativeType(value="char const *") CharSequence pchRenderModelName, @NativeType(value="char const *") CharSequence pchComponentName, @NativeType(value="uint32_t") int unComponentRenderModelNameLen) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchRenderModelName, true);
            long pchRenderModelNameEncoded = stack.getPointerAddress();
            stack.nASCII(pchComponentName, true);
            long pchComponentNameEncoded = stack.getPointerAddress();
            ByteBuffer pchComponentRenderModelName = stack.malloc(unComponentRenderModelNameLen);
            int __result = VRRenderModels.nVRRenderModels_GetComponentRenderModelName(pchRenderModelNameEncoded, pchComponentNameEncoded, MemoryUtil.memAddress((ByteBuffer)pchComponentRenderModelName), unComponentRenderModelNameLen);
            String string = MemoryUtil.memASCII((ByteBuffer)pchComponentRenderModelName, (int)(__result - 1));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nVRRenderModels_GetComponentStateForDevicePath(long pchRenderModelName, long pchComponentName, long devicePath, long pState, long pComponentState) {
        long __functionAddress = OpenVR.VRRenderModels.GetComponentStateForDevicePath;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPJPPZ((long)pchRenderModelName, (long)pchComponentName, (long)devicePath, (long)pState, (long)pComponentState, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean VRRenderModels_GetComponentStateForDevicePath(@NativeType(value="char const *") ByteBuffer pchRenderModelName, @NativeType(value="char const *") ByteBuffer pchComponentName, @NativeType(value="VRInputValueHandle_t") long devicePath, @NativeType(value="RenderModel_ControllerMode_State_t const *") RenderModelControllerModeState pState, @NativeType(value="RenderModel_ComponentState_t *") RenderModelComponentState pComponentState) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)pchRenderModelName);
            Checks.checkNT1((ByteBuffer)pchComponentName);
        }
        return VRRenderModels.nVRRenderModels_GetComponentStateForDevicePath(MemoryUtil.memAddress((ByteBuffer)pchRenderModelName), MemoryUtil.memAddress((ByteBuffer)pchComponentName), devicePath, pState.address(), pComponentState.address());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean VRRenderModels_GetComponentStateForDevicePath(@NativeType(value="char const *") CharSequence pchRenderModelName, @NativeType(value="char const *") CharSequence pchComponentName, @NativeType(value="VRInputValueHandle_t") long devicePath, @NativeType(value="RenderModel_ControllerMode_State_t const *") RenderModelControllerModeState pState, @NativeType(value="RenderModel_ComponentState_t *") RenderModelComponentState pComponentState) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchRenderModelName, true);
            long pchRenderModelNameEncoded = stack.getPointerAddress();
            stack.nASCII(pchComponentName, true);
            long pchComponentNameEncoded = stack.getPointerAddress();
            boolean bl = VRRenderModels.nVRRenderModels_GetComponentStateForDevicePath(pchRenderModelNameEncoded, pchComponentNameEncoded, devicePath, pState.address(), pComponentState.address());
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nVRRenderModels_GetComponentState(long pchRenderModelName, long pchComponentName, long pControllerState, long pState, long pComponentState) {
        long __functionAddress = OpenVR.VRRenderModels.GetComponentState;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPPPZ((long)pchRenderModelName, (long)pchComponentName, (long)pControllerState, (long)pState, (long)pComponentState, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean VRRenderModels_GetComponentState(@NativeType(value="char const *") ByteBuffer pchRenderModelName, @NativeType(value="char const *") ByteBuffer pchComponentName, @NativeType(value="VRControllerState_t const *") VRControllerState pControllerState, @NativeType(value="RenderModel_ControllerMode_State_t const *") RenderModelControllerModeState pState, @NativeType(value="RenderModel_ComponentState_t *") RenderModelComponentState pComponentState) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)pchRenderModelName);
            Checks.checkNT1((ByteBuffer)pchComponentName);
        }
        return VRRenderModels.nVRRenderModels_GetComponentState(MemoryUtil.memAddress((ByteBuffer)pchRenderModelName), MemoryUtil.memAddress((ByteBuffer)pchComponentName), pControllerState.address(), pState.address(), pComponentState.address());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean VRRenderModels_GetComponentState(@NativeType(value="char const *") CharSequence pchRenderModelName, @NativeType(value="char const *") CharSequence pchComponentName, @NativeType(value="VRControllerState_t const *") VRControllerState pControllerState, @NativeType(value="RenderModel_ControllerMode_State_t const *") RenderModelControllerModeState pState, @NativeType(value="RenderModel_ComponentState_t *") RenderModelComponentState pComponentState) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchRenderModelName, true);
            long pchRenderModelNameEncoded = stack.getPointerAddress();
            stack.nASCII(pchComponentName, true);
            long pchComponentNameEncoded = stack.getPointerAddress();
            boolean bl = VRRenderModels.nVRRenderModels_GetComponentState(pchRenderModelNameEncoded, pchComponentNameEncoded, pControllerState.address(), pState.address(), pComponentState.address());
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nVRRenderModels_RenderModelHasComponent(long pchRenderModelName, long pchComponentName) {
        long __functionAddress = OpenVR.VRRenderModels.RenderModelHasComponent;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPZ((long)pchRenderModelName, (long)pchComponentName, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean VRRenderModels_RenderModelHasComponent(@NativeType(value="char const *") ByteBuffer pchRenderModelName, @NativeType(value="char const *") ByteBuffer pchComponentName) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)pchRenderModelName);
            Checks.checkNT1((ByteBuffer)pchComponentName);
        }
        return VRRenderModels.nVRRenderModels_RenderModelHasComponent(MemoryUtil.memAddress((ByteBuffer)pchRenderModelName), MemoryUtil.memAddress((ByteBuffer)pchComponentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean VRRenderModels_RenderModelHasComponent(@NativeType(value="char const *") CharSequence pchRenderModelName, @NativeType(value="char const *") CharSequence pchComponentName) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchRenderModelName, true);
            long pchRenderModelNameEncoded = stack.getPointerAddress();
            stack.nASCII(pchComponentName, true);
            long pchComponentNameEncoded = stack.getPointerAddress();
            boolean bl = VRRenderModels.nVRRenderModels_RenderModelHasComponent(pchRenderModelNameEncoded, pchComponentNameEncoded);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRRenderModels_GetRenderModelThumbnailURL(long pchRenderModelName, long pchThumbnailURL, int unThumbnailURLLen, long peError) {
        long __functionAddress = OpenVR.VRRenderModels.GetRenderModelThumbnailURL;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPI((long)pchRenderModelName, (long)pchThumbnailURL, (int)unThumbnailURLLen, (long)peError, (long)__functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int VRRenderModels_GetRenderModelThumbnailURL(@NativeType(value="char const *") ByteBuffer pchRenderModelName, @NativeType(value="char *") @Nullable ByteBuffer pchThumbnailURL, @NativeType(value="EVRRenderModelError *") IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)pchRenderModelName);
            Checks.check((Buffer)peError, (int)1);
        }
        return VRRenderModels.nVRRenderModels_GetRenderModelThumbnailURL(MemoryUtil.memAddress((ByteBuffer)pchRenderModelName), MemoryUtil.memAddressSafe((ByteBuffer)pchThumbnailURL), Checks.remainingSafe((Buffer)pchThumbnailURL), MemoryUtil.memAddress((IntBuffer)peError));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="uint32_t")
    public static int VRRenderModels_GetRenderModelThumbnailURL(@NativeType(value="char const *") CharSequence pchRenderModelName, @NativeType(value="char *") @Nullable ByteBuffer pchThumbnailURL, @NativeType(value="EVRRenderModelError *") IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)peError, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchRenderModelName, true);
            long pchRenderModelNameEncoded = stack.getPointerAddress();
            int n = VRRenderModels.nVRRenderModels_GetRenderModelThumbnailURL(pchRenderModelNameEncoded, MemoryUtil.memAddressSafe((ByteBuffer)pchThumbnailURL), Checks.remainingSafe((Buffer)pchThumbnailURL), MemoryUtil.memAddress((IntBuffer)peError));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="uint32_t")
    public static String VRRenderModels_GetRenderModelThumbnailURL(@NativeType(value="char const *") CharSequence pchRenderModelName, @NativeType(value="uint32_t") int unThumbnailURLLen, @NativeType(value="EVRRenderModelError *") IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)peError, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchRenderModelName, true);
            long pchRenderModelNameEncoded = stack.getPointerAddress();
            ByteBuffer pchThumbnailURL = stack.malloc(unThumbnailURLLen);
            int __result = VRRenderModels.nVRRenderModels_GetRenderModelThumbnailURL(pchRenderModelNameEncoded, MemoryUtil.memAddress((ByteBuffer)pchThumbnailURL), unThumbnailURLLen, MemoryUtil.memAddress((IntBuffer)peError));
            String string = MemoryUtil.memASCII((ByteBuffer)pchThumbnailURL, (int)(__result - 1));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRRenderModels_GetRenderModelOriginalPath(long pchRenderModelName, long pchOriginalPath, int unOriginalPathLen, long peError) {
        long __functionAddress = OpenVR.VRRenderModels.GetRenderModelOriginalPath;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPI((long)pchRenderModelName, (long)pchOriginalPath, (int)unOriginalPathLen, (long)peError, (long)__functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int VRRenderModels_GetRenderModelOriginalPath(@NativeType(value="char const *") ByteBuffer pchRenderModelName, @NativeType(value="char *") @Nullable ByteBuffer pchOriginalPath, @NativeType(value="EVRRenderModelError *") IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)pchRenderModelName);
            Checks.check((Buffer)peError, (int)1);
        }
        return VRRenderModels.nVRRenderModels_GetRenderModelOriginalPath(MemoryUtil.memAddress((ByteBuffer)pchRenderModelName), MemoryUtil.memAddressSafe((ByteBuffer)pchOriginalPath), Checks.remainingSafe((Buffer)pchOriginalPath), MemoryUtil.memAddress((IntBuffer)peError));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="uint32_t")
    public static int VRRenderModels_GetRenderModelOriginalPath(@NativeType(value="char const *") CharSequence pchRenderModelName, @NativeType(value="char *") @Nullable ByteBuffer pchOriginalPath, @NativeType(value="EVRRenderModelError *") IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)peError, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchRenderModelName, true);
            long pchRenderModelNameEncoded = stack.getPointerAddress();
            int n = VRRenderModels.nVRRenderModels_GetRenderModelOriginalPath(pchRenderModelNameEncoded, MemoryUtil.memAddressSafe((ByteBuffer)pchOriginalPath), Checks.remainingSafe((Buffer)pchOriginalPath), MemoryUtil.memAddress((IntBuffer)peError));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="uint32_t")
    public static String VRRenderModels_GetRenderModelOriginalPath(@NativeType(value="char const *") CharSequence pchRenderModelName, @NativeType(value="uint32_t") int unOriginalPathLen, @NativeType(value="EVRRenderModelError *") IntBuffer peError) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)peError, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchRenderModelName, true);
            long pchRenderModelNameEncoded = stack.getPointerAddress();
            ByteBuffer pchOriginalPath = stack.malloc(unOriginalPathLen);
            int __result = VRRenderModels.nVRRenderModels_GetRenderModelOriginalPath(pchRenderModelNameEncoded, MemoryUtil.memAddress((ByteBuffer)pchOriginalPath), unOriginalPathLen, MemoryUtil.memAddress((IntBuffer)peError));
            String string = MemoryUtil.memASCII((ByteBuffer)pchOriginalPath, (int)(__result - 1));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nVRRenderModels_GetRenderModelErrorNameFromEnum(int error) {
        long __functionAddress = OpenVR.VRRenderModels.GetRenderModelErrorNameFromEnum;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callP((int)error, (long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String VRRenderModels_GetRenderModelErrorNameFromEnum(@NativeType(value="EVRRenderModelError") int error) {
        long __result = VRRenderModels.nVRRenderModels_GetRenderModelErrorNameFromEnum(error);
        return MemoryUtil.memASCIISafe((long)__result);
    }
}

