/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.openvr.OpenVR;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class VRScreenshots {
    protected VRScreenshots() {
        throw new UnsupportedOperationException();
    }

    public static int nVRScreenshots_RequestScreenshot(long pOutScreenshotHandle, int type, long pchPreviewFilename, long pchVRFilename) {
        long __functionAddress = OpenVR.VRScreenshots.RequestScreenshot;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPI((long)pOutScreenshotHandle, (int)type, (long)pchPreviewFilename, (long)pchVRFilename, (long)__functionAddress);
    }

    @NativeType(value="EVRScreenshotError")
    public static int VRScreenshots_RequestScreenshot(@NativeType(value="ScreenshotHandle_t *") IntBuffer pOutScreenshotHandle, @NativeType(value="EVRScreenshotType") int type, @NativeType(value="char const *") ByteBuffer pchPreviewFilename, @NativeType(value="char const *") ByteBuffer pchVRFilename) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pOutScreenshotHandle, (int)1);
            Checks.checkNT1((ByteBuffer)pchPreviewFilename);
            Checks.checkNT1((ByteBuffer)pchVRFilename);
        }
        return VRScreenshots.nVRScreenshots_RequestScreenshot(MemoryUtil.memAddress((IntBuffer)pOutScreenshotHandle), type, MemoryUtil.memAddress((ByteBuffer)pchPreviewFilename), MemoryUtil.memAddress((ByteBuffer)pchVRFilename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="EVRScreenshotError")
    public static int VRScreenshots_RequestScreenshot(@NativeType(value="ScreenshotHandle_t *") IntBuffer pOutScreenshotHandle, @NativeType(value="EVRScreenshotType") int type, @NativeType(value="char const *") CharSequence pchPreviewFilename, @NativeType(value="char const *") CharSequence pchVRFilename) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pOutScreenshotHandle, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchPreviewFilename, true);
            long pchPreviewFilenameEncoded = stack.getPointerAddress();
            stack.nASCII(pchVRFilename, true);
            long pchVRFilenameEncoded = stack.getPointerAddress();
            int n = VRScreenshots.nVRScreenshots_RequestScreenshot(MemoryUtil.memAddress((IntBuffer)pOutScreenshotHandle), type, pchPreviewFilenameEncoded, pchVRFilenameEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRScreenshots_HookScreenshot(long pSupportedTypes, int numTypes) {
        long __functionAddress = OpenVR.VRScreenshots.HookScreenshot;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPI((long)pSupportedTypes, (int)numTypes, (long)__functionAddress);
    }

    @NativeType(value="EVRScreenshotError")
    public static int VRScreenshots_HookScreenshot(@NativeType(value="EVRScreenshotType const *") IntBuffer pSupportedTypes) {
        return VRScreenshots.nVRScreenshots_HookScreenshot(MemoryUtil.memAddress((IntBuffer)pSupportedTypes), pSupportedTypes.remaining());
    }

    public static int nVRScreenshots_GetScreenshotPropertyType(int screenshotHandle, long pError) {
        long __functionAddress = OpenVR.VRScreenshots.GetScreenshotPropertyType;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPI((int)screenshotHandle, (long)pError, (long)__functionAddress);
    }

    @NativeType(value="EVRScreenshotType")
    public static int VRScreenshots_GetScreenshotPropertyType(@NativeType(value="ScreenshotHandle_t") int screenshotHandle, @NativeType(value="EVRScreenshotError *") IntBuffer pError) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pError, (int)1);
        }
        return VRScreenshots.nVRScreenshots_GetScreenshotPropertyType(screenshotHandle, MemoryUtil.memAddress((IntBuffer)pError));
    }

    public static int nVRScreenshots_GetScreenshotPropertyFilename(int screenshotHandle, int filenameType, long pchFilename, int cchFilename, long pError) {
        long __functionAddress = OpenVR.VRScreenshots.GetScreenshotPropertyFilename;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((int)screenshotHandle, (int)filenameType, (long)pchFilename, (int)cchFilename, (long)pError, (long)__functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int VRScreenshots_GetScreenshotPropertyFilename(@NativeType(value="ScreenshotHandle_t") int screenshotHandle, @NativeType(value="EVRScreenshotPropertyFilenames") int filenameType, @NativeType(value="char *") @Nullable ByteBuffer pchFilename, @NativeType(value="EVRScreenshotError *") IntBuffer pError) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pError, (int)1);
        }
        return VRScreenshots.nVRScreenshots_GetScreenshotPropertyFilename(screenshotHandle, filenameType, MemoryUtil.memAddressSafe((ByteBuffer)pchFilename), Checks.remainingSafe((Buffer)pchFilename), MemoryUtil.memAddress((IntBuffer)pError));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="uint32_t")
    public static String VRScreenshots_GetScreenshotPropertyFilename(@NativeType(value="ScreenshotHandle_t") int screenshotHandle, @NativeType(value="EVRScreenshotPropertyFilenames") int filenameType, @NativeType(value="uint32_t") int cchFilename, @NativeType(value="EVRScreenshotError *") IntBuffer pError) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pError, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer pchFilename = stack.malloc(cchFilename);
            int __result = VRScreenshots.nVRScreenshots_GetScreenshotPropertyFilename(screenshotHandle, filenameType, MemoryUtil.memAddress((ByteBuffer)pchFilename), cchFilename, MemoryUtil.memAddress((IntBuffer)pError));
            String string = MemoryUtil.memASCII((ByteBuffer)pchFilename, (int)(__result - 1));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="EVRScreenshotError")
    public static int VRScreenshots_UpdateScreenshotProgress(@NativeType(value="ScreenshotHandle_t") int screenshotHandle, float flProgress) {
        long __functionAddress = OpenVR.VRScreenshots.UpdateScreenshotProgress;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callI((int)screenshotHandle, (float)flProgress, (long)__functionAddress);
    }

    public static int nVRScreenshots_TakeStereoScreenshot(long pOutScreenshotHandle, long pchPreviewFilename, long pchVRFilename) {
        long __functionAddress = OpenVR.VRScreenshots.TakeStereoScreenshot;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPI((long)pOutScreenshotHandle, (long)pchPreviewFilename, (long)pchVRFilename, (long)__functionAddress);
    }

    @NativeType(value="EVRScreenshotError")
    public static int VRScreenshots_TakeStereoScreenshot(@NativeType(value="ScreenshotHandle_t *") IntBuffer pOutScreenshotHandle, @NativeType(value="char const *") ByteBuffer pchPreviewFilename, @NativeType(value="char const *") ByteBuffer pchVRFilename) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pOutScreenshotHandle, (int)1);
            Checks.checkNT1((ByteBuffer)pchPreviewFilename);
            Checks.checkNT1((ByteBuffer)pchVRFilename);
        }
        return VRScreenshots.nVRScreenshots_TakeStereoScreenshot(MemoryUtil.memAddress((IntBuffer)pOutScreenshotHandle), MemoryUtil.memAddress((ByteBuffer)pchPreviewFilename), MemoryUtil.memAddress((ByteBuffer)pchVRFilename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="EVRScreenshotError")
    public static int VRScreenshots_TakeStereoScreenshot(@NativeType(value="ScreenshotHandle_t *") IntBuffer pOutScreenshotHandle, @NativeType(value="char const *") CharSequence pchPreviewFilename, @NativeType(value="char const *") CharSequence pchVRFilename) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pOutScreenshotHandle, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchPreviewFilename, true);
            long pchPreviewFilenameEncoded = stack.getPointerAddress();
            stack.nASCII(pchVRFilename, true);
            long pchVRFilenameEncoded = stack.getPointerAddress();
            int n = VRScreenshots.nVRScreenshots_TakeStereoScreenshot(MemoryUtil.memAddress((IntBuffer)pOutScreenshotHandle), pchPreviewFilenameEncoded, pchVRFilenameEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nVRScreenshots_SubmitScreenshot(int screenshotHandle, int type, long pchSourcePreviewFilename, long pchSourceVRFilename) {
        long __functionAddress = OpenVR.VRScreenshots.SubmitScreenshot;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((int)screenshotHandle, (int)type, (long)pchSourcePreviewFilename, (long)pchSourceVRFilename, (long)__functionAddress);
    }

    @NativeType(value="EVRScreenshotError")
    public static int VRScreenshots_SubmitScreenshot(@NativeType(value="ScreenshotHandle_t") int screenshotHandle, @NativeType(value="EVRScreenshotType") int type, @NativeType(value="char const *") ByteBuffer pchSourcePreviewFilename, @NativeType(value="char const *") ByteBuffer pchSourceVRFilename) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)pchSourcePreviewFilename);
            Checks.checkNT1((ByteBuffer)pchSourceVRFilename);
        }
        return VRScreenshots.nVRScreenshots_SubmitScreenshot(screenshotHandle, type, MemoryUtil.memAddress((ByteBuffer)pchSourcePreviewFilename), MemoryUtil.memAddress((ByteBuffer)pchSourceVRFilename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="EVRScreenshotError")
    public static int VRScreenshots_SubmitScreenshot(@NativeType(value="ScreenshotHandle_t") int screenshotHandle, @NativeType(value="EVRScreenshotType") int type, @NativeType(value="char const *") CharSequence pchSourcePreviewFilename, @NativeType(value="char const *") CharSequence pchSourceVRFilename) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(pchSourcePreviewFilename, true);
            long pchSourcePreviewFilenameEncoded = stack.getPointerAddress();
            stack.nASCII(pchSourceVRFilename, true);
            long pchSourceVRFilenameEncoded = stack.getPointerAddress();
            int n = VRScreenshots.nVRScreenshots_SubmitScreenshot(screenshotHandle, type, pchSourcePreviewFilenameEncoded, pchSourceVRFilenameEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }
}

