/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct VRTextureBounds_t")
public class VRTextureBounds
extends Struct<VRTextureBounds>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int UMIN;
    public static final int VMIN;
    public static final int UMAX;
    public static final int VMAX;

    protected VRTextureBounds(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VRTextureBounds create(long address, @Nullable ByteBuffer container) {
        return new VRTextureBounds(address, container);
    }

    public VRTextureBounds(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VRTextureBounds.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float uMin() {
        return VRTextureBounds.nuMin(this.address());
    }

    public float vMin() {
        return VRTextureBounds.nvMin(this.address());
    }

    public float uMax() {
        return VRTextureBounds.nuMax(this.address());
    }

    public float vMax() {
        return VRTextureBounds.nvMax(this.address());
    }

    public VRTextureBounds uMin(float value) {
        VRTextureBounds.nuMin(this.address(), value);
        return this;
    }

    public VRTextureBounds vMin(float value) {
        VRTextureBounds.nvMin(this.address(), value);
        return this;
    }

    public VRTextureBounds uMax(float value) {
        VRTextureBounds.nuMax(this.address(), value);
        return this;
    }

    public VRTextureBounds vMax(float value) {
        VRTextureBounds.nvMax(this.address(), value);
        return this;
    }

    public VRTextureBounds set(float uMin, float vMin, float uMax, float vMax) {
        this.uMin(uMin);
        this.vMin(vMin);
        this.uMax(uMax);
        this.vMax(vMax);
        return this;
    }

    public VRTextureBounds set(VRTextureBounds src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VRTextureBounds malloc() {
        return new VRTextureBounds(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VRTextureBounds calloc() {
        return new VRTextureBounds(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VRTextureBounds create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VRTextureBounds(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VRTextureBounds create(long address) {
        return new VRTextureBounds(address, null);
    }

    public static @Nullable VRTextureBounds createSafe(long address) {
        return address == 0L ? null : new VRTextureBounds(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VRTextureBounds.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VRTextureBounds.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VRTextureBounds mallocStack() {
        return VRTextureBounds.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VRTextureBounds callocStack() {
        return VRTextureBounds.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VRTextureBounds mallocStack(MemoryStack stack) {
        return VRTextureBounds.malloc(stack);
    }

    @Deprecated
    public static VRTextureBounds callocStack(MemoryStack stack) {
        return VRTextureBounds.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VRTextureBounds.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VRTextureBounds.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VRTextureBounds.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VRTextureBounds.calloc(capacity, stack);
    }

    public static VRTextureBounds malloc(MemoryStack stack) {
        return new VRTextureBounds(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VRTextureBounds calloc(MemoryStack stack) {
        return new VRTextureBounds(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nuMin(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)UMIN));
    }

    public static float nvMin(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)VMIN));
    }

    public static float nuMax(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)UMAX));
    }

    public static float nvMax(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)VMAX));
    }

    public static void nuMin(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)UMIN), (float)value);
    }

    public static void nvMin(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)VMIN), (float)value);
    }

    public static void nuMax(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)UMAX), (float)value);
    }

    public static void nvMax(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)VMAX), (float)value);
    }

    static {
        Struct.Layout layout = VRTextureBounds.__struct((Struct.Member[])new Struct.Member[]{VRTextureBounds.__member((int)4), VRTextureBounds.__member((int)4), VRTextureBounds.__member((int)4), VRTextureBounds.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        UMIN = layout.offsetof(0);
        VMIN = layout.offsetof(1);
        UMAX = layout.offsetof(2);
        VMAX = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VRTextureBounds, Buffer>
    implements NativeResource {
        private static final VRTextureBounds ELEMENT_FACTORY = VRTextureBounds.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VRTextureBounds getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float uMin() {
            return VRTextureBounds.nuMin(this.address());
        }

        public float vMin() {
            return VRTextureBounds.nvMin(this.address());
        }

        public float uMax() {
            return VRTextureBounds.nuMax(this.address());
        }

        public float vMax() {
            return VRTextureBounds.nvMax(this.address());
        }

        public Buffer uMin(float value) {
            VRTextureBounds.nuMin(this.address(), value);
            return this;
        }

        public Buffer vMin(float value) {
            VRTextureBounds.nvMin(this.address(), value);
            return this;
        }

        public Buffer uMax(float value) {
            VRTextureBounds.nuMax(this.address(), value);
            return this;
        }

        public Buffer vMax(float value) {
            VRTextureBounds.nvMax(this.address(), value);
            return this;
        }
    }
}

