/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openvr.HmdMatrix34;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct VRTextureWithPose_t")
public class VRTextureWithPose
extends Struct<VRTextureWithPose>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HANDLE;
    public static final int ETYPE;
    public static final int ECOLORSPACE;
    public static final int MDEVICETOABSOLUTETRACKING;

    protected VRTextureWithPose(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VRTextureWithPose create(long address, @Nullable ByteBuffer container) {
        return new VRTextureWithPose(address, container);
    }

    public VRTextureWithPose(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VRTextureWithPose.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public long handle() {
        return VRTextureWithPose.nhandle(this.address());
    }

    @NativeType(value="ETextureType")
    public int eType() {
        return VRTextureWithPose.neType(this.address());
    }

    @NativeType(value="EColorSpace")
    public int eColorSpace() {
        return VRTextureWithPose.neColorSpace(this.address());
    }

    @NativeType(value="HmdMatrix34_t")
    public HmdMatrix34 mDeviceToAbsoluteTracking() {
        return VRTextureWithPose.nmDeviceToAbsoluteTracking(this.address());
    }

    public VRTextureWithPose handle(@NativeType(value="void *") long value) {
        VRTextureWithPose.nhandle(this.address(), value);
        return this;
    }

    public VRTextureWithPose eType(@NativeType(value="ETextureType") int value) {
        VRTextureWithPose.neType(this.address(), value);
        return this;
    }

    public VRTextureWithPose eColorSpace(@NativeType(value="EColorSpace") int value) {
        VRTextureWithPose.neColorSpace(this.address(), value);
        return this;
    }

    public VRTextureWithPose mDeviceToAbsoluteTracking(@NativeType(value="HmdMatrix34_t") HmdMatrix34 value) {
        VRTextureWithPose.nmDeviceToAbsoluteTracking(this.address(), value);
        return this;
    }

    public VRTextureWithPose mDeviceToAbsoluteTracking(Consumer<HmdMatrix34> consumer) {
        consumer.accept(this.mDeviceToAbsoluteTracking());
        return this;
    }

    public VRTextureWithPose set(long handle, int eType, int eColorSpace, HmdMatrix34 mDeviceToAbsoluteTracking) {
        this.handle(handle);
        this.eType(eType);
        this.eColorSpace(eColorSpace);
        this.mDeviceToAbsoluteTracking(mDeviceToAbsoluteTracking);
        return this;
    }

    public VRTextureWithPose set(VRTextureWithPose src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VRTextureWithPose malloc() {
        return new VRTextureWithPose(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VRTextureWithPose calloc() {
        return new VRTextureWithPose(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VRTextureWithPose create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VRTextureWithPose(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VRTextureWithPose create(long address) {
        return new VRTextureWithPose(address, null);
    }

    public static @Nullable VRTextureWithPose createSafe(long address) {
        return address == 0L ? null : new VRTextureWithPose(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VRTextureWithPose.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VRTextureWithPose.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VRTextureWithPose mallocStack() {
        return VRTextureWithPose.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VRTextureWithPose callocStack() {
        return VRTextureWithPose.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VRTextureWithPose mallocStack(MemoryStack stack) {
        return VRTextureWithPose.malloc(stack);
    }

    @Deprecated
    public static VRTextureWithPose callocStack(MemoryStack stack) {
        return VRTextureWithPose.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VRTextureWithPose.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VRTextureWithPose.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VRTextureWithPose.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VRTextureWithPose.calloc(capacity, stack);
    }

    public static VRTextureWithPose malloc(MemoryStack stack) {
        return new VRTextureWithPose(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VRTextureWithPose calloc(MemoryStack stack) {
        return new VRTextureWithPose(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nhandle(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)HANDLE));
    }

    public static int neType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)ETYPE));
    }

    public static int neColorSpace(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)ECOLORSPACE));
    }

    public static HmdMatrix34 nmDeviceToAbsoluteTracking(long struct) {
        return HmdMatrix34.create(struct + (long)MDEVICETOABSOLUTETRACKING);
    }

    public static void nhandle(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)HANDLE), (long)Checks.check((long)value));
    }

    public static void neType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)ETYPE), (int)value);
    }

    public static void neColorSpace(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)ECOLORSPACE), (int)value);
    }

    public static void nmDeviceToAbsoluteTracking(long struct, HmdMatrix34 value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MDEVICETOABSOLUTETRACKING), (long)HmdMatrix34.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)HANDLE)));
    }

    static {
        Struct.Layout layout = VRTextureWithPose.__struct((Struct.Member[])new Struct.Member[]{VRTextureWithPose.__member((int)POINTER_SIZE), VRTextureWithPose.__member((int)4), VRTextureWithPose.__member((int)4), VRTextureWithPose.__member((int)HmdMatrix34.SIZEOF, (int)HmdMatrix34.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HANDLE = layout.offsetof(0);
        ETYPE = layout.offsetof(1);
        ECOLORSPACE = layout.offsetof(2);
        MDEVICETOABSOLUTETRACKING = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VRTextureWithPose, Buffer>
    implements NativeResource {
        private static final VRTextureWithPose ELEMENT_FACTORY = VRTextureWithPose.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VRTextureWithPose getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public long handle() {
            return VRTextureWithPose.nhandle(this.address());
        }

        @NativeType(value="ETextureType")
        public int eType() {
            return VRTextureWithPose.neType(this.address());
        }

        @NativeType(value="EColorSpace")
        public int eColorSpace() {
            return VRTextureWithPose.neColorSpace(this.address());
        }

        @NativeType(value="HmdMatrix34_t")
        public HmdMatrix34 mDeviceToAbsoluteTracking() {
            return VRTextureWithPose.nmDeviceToAbsoluteTracking(this.address());
        }

        public Buffer handle(@NativeType(value="void *") long value) {
            VRTextureWithPose.nhandle(this.address(), value);
            return this;
        }

        public Buffer eType(@NativeType(value="ETextureType") int value) {
            VRTextureWithPose.neType(this.address(), value);
            return this;
        }

        public Buffer eColorSpace(@NativeType(value="EColorSpace") int value) {
            VRTextureWithPose.neColorSpace(this.address(), value);
            return this;
        }

        public Buffer mDeviceToAbsoluteTracking(@NativeType(value="HmdMatrix34_t") HmdMatrix34 value) {
            VRTextureWithPose.nmDeviceToAbsoluteTracking(this.address(), value);
            return this;
        }

        public Buffer mDeviceToAbsoluteTracking(Consumer<HmdMatrix34> consumer) {
            consumer.accept(this.mDeviceToAbsoluteTracking());
            return this;
        }
    }
}

