/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.XrPlaneDetectorBeginInfoEXT;
import org.lwjgl.openxr.XrPlaneDetectorCreateInfoEXT;
import org.lwjgl.openxr.XrPlaneDetectorEXT;
import org.lwjgl.openxr.XrPlaneDetectorGetInfoEXT;
import org.lwjgl.openxr.XrPlaneDetectorLocationsEXT;
import org.lwjgl.openxr.XrPlaneDetectorPolygonBufferEXT;
import org.lwjgl.openxr.XrSession;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class EXTPlaneDetection {
    public static final int XR_EXT_plane_detection_SPEC_VERSION = 2;
    public static final String XR_EXT_PLANE_DETECTION_EXTENSION_NAME = "XR_EXT_plane_detection";
    public static final int XR_ERROR_SPACE_NOT_LOCATABLE_EXT = -1000429000;
    public static final int XR_ERROR_PLANE_DETECTION_PERMISSION_DENIED_EXT = -1000429001;
    public static final int XR_OBJECT_TYPE_PLANE_DETECTOR_EXT = 1000429000;
    public static final int XR_TYPE_PLANE_DETECTOR_CREATE_INFO_EXT = 1000429001;
    public static final int XR_TYPE_PLANE_DETECTOR_BEGIN_INFO_EXT = 1000429002;
    public static final int XR_TYPE_PLANE_DETECTOR_GET_INFO_EXT = 1000429003;
    public static final int XR_TYPE_PLANE_DETECTOR_LOCATIONS_EXT = 1000429004;
    public static final int XR_TYPE_PLANE_DETECTOR_LOCATION_EXT = 1000429005;
    public static final int XR_TYPE_PLANE_DETECTOR_POLYGON_BUFFER_EXT = 1000429006;
    public static final int XR_TYPE_SYSTEM_PLANE_DETECTION_PROPERTIES_EXT = 1000429007;
    public static final int XR_PLANE_DETECTION_CAPABILITY_PLANE_DETECTION_BIT_EXT = 1;
    public static final int XR_PLANE_DETECTION_CAPABILITY_PLANE_HOLES_BIT_EXT = 2;
    public static final int XR_PLANE_DETECTION_CAPABILITY_SEMANTIC_CEILING_BIT_EXT = 4;
    public static final int XR_PLANE_DETECTION_CAPABILITY_SEMANTIC_FLOOR_BIT_EXT = 8;
    public static final int XR_PLANE_DETECTION_CAPABILITY_SEMANTIC_WALL_BIT_EXT = 16;
    public static final int XR_PLANE_DETECTION_CAPABILITY_SEMANTIC_PLATFORM_BIT_EXT = 32;
    public static final int XR_PLANE_DETECTION_CAPABILITY_ORIENTATION_BIT_EXT = 64;
    public static final int XR_PLANE_DETECTOR_ENABLE_CONTOUR_BIT_EXT = 1;
    public static final int XR_PLANE_DETECTOR_ORIENTATION_HORIZONTAL_UPWARD_EXT = 0;
    public static final int XR_PLANE_DETECTOR_ORIENTATION_HORIZONTAL_DOWNWARD_EXT = 1;
    public static final int XR_PLANE_DETECTOR_ORIENTATION_VERTICAL_EXT = 2;
    public static final int XR_PLANE_DETECTOR_ORIENTATION_ARBITRARY_EXT = 3;
    public static final int XR_PLANE_DETECTOR_SEMANTIC_TYPE_UNDEFINED_EXT = 0;
    public static final int XR_PLANE_DETECTOR_SEMANTIC_TYPE_CEILING_EXT = 1;
    public static final int XR_PLANE_DETECTOR_SEMANTIC_TYPE_FLOOR_EXT = 2;
    public static final int XR_PLANE_DETECTOR_SEMANTIC_TYPE_WALL_EXT = 3;
    public static final int XR_PLANE_DETECTOR_SEMANTIC_TYPE_PLATFORM_EXT = 4;
    public static final int XR_PLANE_DETECTION_STATE_NONE_EXT = 0;
    public static final int XR_PLANE_DETECTION_STATE_PENDING_EXT = 1;
    public static final int XR_PLANE_DETECTION_STATE_DONE_EXT = 2;
    public static final int XR_PLANE_DETECTION_STATE_ERROR_EXT = 3;
    public static final int XR_PLANE_DETECTION_STATE_FATAL_EXT = 4;

    protected EXTPlaneDetection() {
        throw new UnsupportedOperationException();
    }

    public static int nxrCreatePlaneDetectorEXT(XrSession session, long createInfo, long planeDetector) {
        long __functionAddress = session.getCapabilities().xrCreatePlaneDetectorEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPPI((long)session.address(), (long)createInfo, (long)planeDetector, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrCreatePlaneDetectorEXT(XrSession session, @NativeType(value="XrPlaneDetectorCreateInfoEXT const *") XrPlaneDetectorCreateInfoEXT createInfo, @NativeType(value="XrPlaneDetectorEXT *") PointerBuffer planeDetector) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)planeDetector, (int)1);
        }
        return EXTPlaneDetection.nxrCreatePlaneDetectorEXT(session, createInfo.address(), MemoryUtil.memAddress((CustomBuffer)planeDetector));
    }

    @NativeType(value="XrResult")
    public static int xrDestroyPlaneDetectorEXT(XrPlaneDetectorEXT planeDetector) {
        long __functionAddress = planeDetector.getCapabilities().xrDestroyPlaneDetectorEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPI((long)planeDetector.address(), (long)__functionAddress);
    }

    public static int nxrBeginPlaneDetectionEXT(XrPlaneDetectorEXT planeDetector, long beginInfo) {
        long __functionAddress = planeDetector.getCapabilities().xrBeginPlaneDetectionEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            XrPlaneDetectorBeginInfoEXT.validate(beginInfo);
        }
        return JNI.callPPI((long)planeDetector.address(), (long)beginInfo, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrBeginPlaneDetectionEXT(XrPlaneDetectorEXT planeDetector, @NativeType(value="XrPlaneDetectorBeginInfoEXT const *") XrPlaneDetectorBeginInfoEXT beginInfo) {
        return EXTPlaneDetection.nxrBeginPlaneDetectionEXT(planeDetector, beginInfo.address());
    }

    public static int nxrGetPlaneDetectionStateEXT(XrPlaneDetectorEXT planeDetector, long state) {
        long __functionAddress = planeDetector.getCapabilities().xrGetPlaneDetectionStateEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPPI((long)planeDetector.address(), (long)state, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetPlaneDetectionStateEXT(XrPlaneDetectorEXT planeDetector, @NativeType(value="XrPlaneDetectionStateEXT *") IntBuffer state) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)state, (int)1);
        }
        return EXTPlaneDetection.nxrGetPlaneDetectionStateEXT(planeDetector, MemoryUtil.memAddress((IntBuffer)state));
    }

    public static int nxrGetPlaneDetectionsEXT(XrPlaneDetectorEXT planeDetector, long info, long locations) {
        long __functionAddress = planeDetector.getCapabilities().xrGetPlaneDetectionsEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            XrPlaneDetectorGetInfoEXT.validate(info);
        }
        return JNI.callPPPI((long)planeDetector.address(), (long)info, (long)locations, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetPlaneDetectionsEXT(XrPlaneDetectorEXT planeDetector, @NativeType(value="XrPlaneDetectorGetInfoEXT const *") XrPlaneDetectorGetInfoEXT info, @NativeType(value="XrPlaneDetectorLocationsEXT *") XrPlaneDetectorLocationsEXT locations) {
        return EXTPlaneDetection.nxrGetPlaneDetectionsEXT(planeDetector, info.address(), locations.address());
    }

    public static int nxrGetPlanePolygonBufferEXT(XrPlaneDetectorEXT planeDetector, long planeId, int polygonBufferIndex, long polygonBuffer) {
        long __functionAddress = planeDetector.getCapabilities().xrGetPlanePolygonBufferEXT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.callPJPI((long)planeDetector.address(), (long)planeId, (int)polygonBufferIndex, (long)polygonBuffer, (long)__functionAddress);
    }

    @NativeType(value="XrResult")
    public static int xrGetPlanePolygonBufferEXT(XrPlaneDetectorEXT planeDetector, @NativeType(value="uint64_t") long planeId, @NativeType(value="uint32_t") int polygonBufferIndex, @NativeType(value="XrPlaneDetectorPolygonBufferEXT *") XrPlaneDetectorPolygonBufferEXT polygonBuffer) {
        return EXTPlaneDetection.nxrGetPlanePolygonBufferEXT(planeDetector, planeId, polygonBufferIndex, polygonBuffer.address());
    }
}

