/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrAction;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrActionSpaceCreateInfo
extends Struct<XrActionSpaceCreateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int ACTION;
    public static final int SUBACTIONPATH;
    public static final int POSEINACTIONSPACE;

    protected XrActionSpaceCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrActionSpaceCreateInfo create(long address, @Nullable ByteBuffer container) {
        return new XrActionSpaceCreateInfo(address, container);
    }

    public XrActionSpaceCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrActionSpaceCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrActionSpaceCreateInfo.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrActionSpaceCreateInfo.nnext(this.address());
    }

    @NativeType(value="XrAction")
    public long action() {
        return XrActionSpaceCreateInfo.naction(this.address());
    }

    @NativeType(value="XrPath")
    public long subactionPath() {
        return XrActionSpaceCreateInfo.nsubactionPath(this.address());
    }

    public XrPosef poseInActionSpace() {
        return XrActionSpaceCreateInfo.nposeInActionSpace(this.address());
    }

    public XrActionSpaceCreateInfo type(@NativeType(value="XrStructureType") int value) {
        XrActionSpaceCreateInfo.ntype(this.address(), value);
        return this;
    }

    public XrActionSpaceCreateInfo type$Default() {
        return this.type(38);
    }

    public XrActionSpaceCreateInfo next(@NativeType(value="void const *") long value) {
        XrActionSpaceCreateInfo.nnext(this.address(), value);
        return this;
    }

    public XrActionSpaceCreateInfo action(XrAction value) {
        XrActionSpaceCreateInfo.naction(this.address(), value);
        return this;
    }

    public XrActionSpaceCreateInfo subactionPath(@NativeType(value="XrPath") long value) {
        XrActionSpaceCreateInfo.nsubactionPath(this.address(), value);
        return this;
    }

    public XrActionSpaceCreateInfo poseInActionSpace(XrPosef value) {
        XrActionSpaceCreateInfo.nposeInActionSpace(this.address(), value);
        return this;
    }

    public XrActionSpaceCreateInfo poseInActionSpace(Consumer<XrPosef> consumer) {
        consumer.accept(this.poseInActionSpace());
        return this;
    }

    public XrActionSpaceCreateInfo set(int type, long next, XrAction action, long subactionPath, XrPosef poseInActionSpace) {
        this.type(type);
        this.next(next);
        this.action(action);
        this.subactionPath(subactionPath);
        this.poseInActionSpace(poseInActionSpace);
        return this;
    }

    public XrActionSpaceCreateInfo set(XrActionSpaceCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrActionSpaceCreateInfo malloc() {
        return new XrActionSpaceCreateInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrActionSpaceCreateInfo calloc() {
        return new XrActionSpaceCreateInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrActionSpaceCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrActionSpaceCreateInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrActionSpaceCreateInfo create(long address) {
        return new XrActionSpaceCreateInfo(address, null);
    }

    public static @Nullable XrActionSpaceCreateInfo createSafe(long address) {
        return address == 0L ? null : new XrActionSpaceCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrActionSpaceCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrActionSpaceCreateInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrActionSpaceCreateInfo malloc(MemoryStack stack) {
        return new XrActionSpaceCreateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrActionSpaceCreateInfo calloc(MemoryStack stack) {
        return new XrActionSpaceCreateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long naction(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)ACTION));
    }

    public static long nsubactionPath(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)SUBACTIONPATH));
    }

    public static XrPosef nposeInActionSpace(long struct) {
        return XrPosef.create(struct + (long)POSEINACTIONSPACE);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void naction(long struct, XrAction value) {
        MemoryUtil.memPutAddress((long)(struct + (long)ACTION), (long)value.address());
    }

    public static void nsubactionPath(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)SUBACTIONPATH), (long)value);
    }

    public static void nposeInActionSpace(long struct, XrPosef value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)POSEINACTIONSPACE), (long)XrPosef.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)ACTION)));
    }

    static {
        Struct.Layout layout = XrActionSpaceCreateInfo.__struct((Struct.Member[])new Struct.Member[]{XrActionSpaceCreateInfo.__member((int)4), XrActionSpaceCreateInfo.__member((int)POINTER_SIZE), XrActionSpaceCreateInfo.__member((int)POINTER_SIZE), XrActionSpaceCreateInfo.__member((int)8), XrActionSpaceCreateInfo.__member((int)XrPosef.SIZEOF, (int)XrPosef.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        ACTION = layout.offsetof(2);
        SUBACTIONPATH = layout.offsetof(3);
        POSEINACTIONSPACE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrActionSpaceCreateInfo, Buffer>
    implements NativeResource {
        private static final XrActionSpaceCreateInfo ELEMENT_FACTORY = XrActionSpaceCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrActionSpaceCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrActionSpaceCreateInfo.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrActionSpaceCreateInfo.nnext(this.address());
        }

        @NativeType(value="XrAction")
        public long action() {
            return XrActionSpaceCreateInfo.naction(this.address());
        }

        @NativeType(value="XrPath")
        public long subactionPath() {
            return XrActionSpaceCreateInfo.nsubactionPath(this.address());
        }

        public XrPosef poseInActionSpace() {
            return XrActionSpaceCreateInfo.nposeInActionSpace(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrActionSpaceCreateInfo.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(38);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrActionSpaceCreateInfo.nnext(this.address(), value);
            return this;
        }

        public Buffer action(XrAction value) {
            XrActionSpaceCreateInfo.naction(this.address(), value);
            return this;
        }

        public Buffer subactionPath(@NativeType(value="XrPath") long value) {
            XrActionSpaceCreateInfo.nsubactionPath(this.address(), value);
            return this;
        }

        public Buffer poseInActionSpace(XrPosef value) {
            XrActionSpaceCreateInfo.nposeInActionSpace(this.address(), value);
            return this;
        }

        public Buffer poseInActionSpace(Consumer<XrPosef> consumer) {
            consumer.accept(this.poseInActionSpace());
            return this;
        }
    }
}

