/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrActiveActionSet;
import org.lwjgl.openxr.XrActiveActionSetPrioritiesEXT;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrActionsSyncInfo
extends Struct<XrActionsSyncInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int COUNTACTIVEACTIONSETS;
    public static final int ACTIVEACTIONSETS;

    protected XrActionsSyncInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrActionsSyncInfo create(long address, @Nullable ByteBuffer container) {
        return new XrActionsSyncInfo(address, container);
    }

    public XrActionsSyncInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrActionsSyncInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrActionsSyncInfo.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrActionsSyncInfo.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int countActiveActionSets() {
        return XrActionsSyncInfo.ncountActiveActionSets(this.address());
    }

    @NativeType(value="XrActiveActionSet const *")
    public @Nullable XrActiveActionSet.Buffer activeActionSets() {
        return XrActionsSyncInfo.nactiveActionSets(this.address());
    }

    public XrActionsSyncInfo type(@NativeType(value="XrStructureType") int value) {
        XrActionsSyncInfo.ntype(this.address(), value);
        return this;
    }

    public XrActionsSyncInfo type$Default() {
        return this.type(61);
    }

    public XrActionsSyncInfo next(@NativeType(value="void const *") long value) {
        XrActionsSyncInfo.nnext(this.address(), value);
        return this;
    }

    public XrActionsSyncInfo next(XrActiveActionSetPrioritiesEXT value) {
        return this.next(value.next(this.next()).address());
    }

    public XrActionsSyncInfo countActiveActionSets(@NativeType(value="uint32_t") int value) {
        XrActionsSyncInfo.ncountActiveActionSets(this.address(), value);
        return this;
    }

    public XrActionsSyncInfo activeActionSets(@NativeType(value="XrActiveActionSet const *") @Nullable XrActiveActionSet.Buffer value) {
        XrActionsSyncInfo.nactiveActionSets(this.address(), value);
        return this;
    }

    public XrActionsSyncInfo set(int type, long next, int countActiveActionSets, @Nullable XrActiveActionSet.Buffer activeActionSets) {
        this.type(type);
        this.next(next);
        this.countActiveActionSets(countActiveActionSets);
        this.activeActionSets(activeActionSets);
        return this;
    }

    public XrActionsSyncInfo set(XrActionsSyncInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrActionsSyncInfo malloc() {
        return new XrActionsSyncInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrActionsSyncInfo calloc() {
        return new XrActionsSyncInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrActionsSyncInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrActionsSyncInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrActionsSyncInfo create(long address) {
        return new XrActionsSyncInfo(address, null);
    }

    public static @Nullable XrActionsSyncInfo createSafe(long address) {
        return address == 0L ? null : new XrActionsSyncInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrActionsSyncInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrActionsSyncInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrActionsSyncInfo malloc(MemoryStack stack) {
        return new XrActionsSyncInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrActionsSyncInfo calloc(MemoryStack stack) {
        return new XrActionsSyncInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int ncountActiveActionSets(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)COUNTACTIVEACTIONSETS));
    }

    public static @Nullable XrActiveActionSet.Buffer nactiveActionSets(long struct) {
        return XrActiveActionSet.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)ACTIVEACTIONSETS)), XrActionsSyncInfo.ncountActiveActionSets(struct));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void ncountActiveActionSets(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)COUNTACTIVEACTIONSETS), (int)value);
    }

    public static void nactiveActionSets(long struct, @Nullable XrActiveActionSet.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)ACTIVEACTIONSETS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        if (value != null) {
            XrActionsSyncInfo.ncountActiveActionSets(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = XrActionsSyncInfo.__struct((Struct.Member[])new Struct.Member[]{XrActionsSyncInfo.__member((int)4), XrActionsSyncInfo.__member((int)POINTER_SIZE), XrActionsSyncInfo.__member((int)4), XrActionsSyncInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        COUNTACTIVEACTIONSETS = layout.offsetof(2);
        ACTIVEACTIONSETS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrActionsSyncInfo, Buffer>
    implements NativeResource {
        private static final XrActionsSyncInfo ELEMENT_FACTORY = XrActionsSyncInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrActionsSyncInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrActionsSyncInfo.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrActionsSyncInfo.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int countActiveActionSets() {
            return XrActionsSyncInfo.ncountActiveActionSets(this.address());
        }

        @NativeType(value="XrActiveActionSet const *")
        public @Nullable XrActiveActionSet.Buffer activeActionSets() {
            return XrActionsSyncInfo.nactiveActionSets(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrActionsSyncInfo.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(61);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrActionsSyncInfo.nnext(this.address(), value);
            return this;
        }

        public Buffer next(XrActiveActionSetPrioritiesEXT value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer countActiveActionSets(@NativeType(value="uint32_t") int value) {
            XrActionsSyncInfo.ncountActiveActionSets(this.address(), value);
            return this;
        }

        public Buffer activeActionSets(@NativeType(value="XrActiveActionSet const *") @Nullable XrActiveActionSet.Buffer value) {
            XrActionsSyncInfo.nactiveActionSets(this.address(), value);
            return this;
        }
    }
}

