/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrBodyJointLocationFB;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrBodyJointLocationsFB
extends Struct<XrBodyJointLocationsFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int ISACTIVE;
    public static final int CONFIDENCE;
    public static final int JOINTCOUNT;
    public static final int JOINTLOCATIONS;
    public static final int SKELETONCHANGEDCOUNT;
    public static final int TIME;

    protected XrBodyJointLocationsFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrBodyJointLocationsFB create(long address, @Nullable ByteBuffer container) {
        return new XrBodyJointLocationsFB(address, container);
    }

    public XrBodyJointLocationsFB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrBodyJointLocationsFB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrBodyJointLocationsFB.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrBodyJointLocationsFB.nnext(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean isActive() {
        return XrBodyJointLocationsFB.nisActive(this.address()) != 0;
    }

    public float confidence() {
        return XrBodyJointLocationsFB.nconfidence(this.address());
    }

    @NativeType(value="uint32_t")
    public int jointCount() {
        return XrBodyJointLocationsFB.njointCount(this.address());
    }

    @NativeType(value="XrBodyJointLocationFB *")
    public XrBodyJointLocationFB.Buffer jointLocations() {
        return XrBodyJointLocationsFB.njointLocations(this.address());
    }

    @NativeType(value="uint32_t")
    public int skeletonChangedCount() {
        return XrBodyJointLocationsFB.nskeletonChangedCount(this.address());
    }

    @NativeType(value="XrTime")
    public long time() {
        return XrBodyJointLocationsFB.ntime(this.address());
    }

    public XrBodyJointLocationsFB type(@NativeType(value="XrStructureType") int value) {
        XrBodyJointLocationsFB.ntype(this.address(), value);
        return this;
    }

    public XrBodyJointLocationsFB type$Default() {
        return this.type(1000076005);
    }

    public XrBodyJointLocationsFB next(@NativeType(value="void *") long value) {
        XrBodyJointLocationsFB.nnext(this.address(), value);
        return this;
    }

    public XrBodyJointLocationsFB isActive(@NativeType(value="XrBool32") boolean value) {
        XrBodyJointLocationsFB.nisActive(this.address(), value ? 1 : 0);
        return this;
    }

    public XrBodyJointLocationsFB confidence(float value) {
        XrBodyJointLocationsFB.nconfidence(this.address(), value);
        return this;
    }

    public XrBodyJointLocationsFB jointLocations(@NativeType(value="XrBodyJointLocationFB *") XrBodyJointLocationFB.Buffer value) {
        XrBodyJointLocationsFB.njointLocations(this.address(), value);
        return this;
    }

    public XrBodyJointLocationsFB skeletonChangedCount(@NativeType(value="uint32_t") int value) {
        XrBodyJointLocationsFB.nskeletonChangedCount(this.address(), value);
        return this;
    }

    public XrBodyJointLocationsFB time(@NativeType(value="XrTime") long value) {
        XrBodyJointLocationsFB.ntime(this.address(), value);
        return this;
    }

    public XrBodyJointLocationsFB set(int type, long next, boolean isActive, float confidence, XrBodyJointLocationFB.Buffer jointLocations, int skeletonChangedCount, long time) {
        this.type(type);
        this.next(next);
        this.isActive(isActive);
        this.confidence(confidence);
        this.jointLocations(jointLocations);
        this.skeletonChangedCount(skeletonChangedCount);
        this.time(time);
        return this;
    }

    public XrBodyJointLocationsFB set(XrBodyJointLocationsFB src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrBodyJointLocationsFB malloc() {
        return new XrBodyJointLocationsFB(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrBodyJointLocationsFB calloc() {
        return new XrBodyJointLocationsFB(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrBodyJointLocationsFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrBodyJointLocationsFB(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrBodyJointLocationsFB create(long address) {
        return new XrBodyJointLocationsFB(address, null);
    }

    public static @Nullable XrBodyJointLocationsFB createSafe(long address) {
        return address == 0L ? null : new XrBodyJointLocationsFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrBodyJointLocationsFB.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrBodyJointLocationsFB.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrBodyJointLocationsFB malloc(MemoryStack stack) {
        return new XrBodyJointLocationsFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrBodyJointLocationsFB calloc(MemoryStack stack) {
        return new XrBodyJointLocationsFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nisActive(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)ISACTIVE));
    }

    public static float nconfidence(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)CONFIDENCE));
    }

    public static int njointCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)JOINTCOUNT));
    }

    public static XrBodyJointLocationFB.Buffer njointLocations(long struct) {
        return XrBodyJointLocationFB.create(MemoryUtil.memGetAddress((long)(struct + (long)JOINTLOCATIONS)), XrBodyJointLocationsFB.njointCount(struct));
    }

    public static int nskeletonChangedCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SKELETONCHANGEDCOUNT));
    }

    public static long ntime(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)TIME));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nisActive(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)ISACTIVE), (int)value);
    }

    public static void nconfidence(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)CONFIDENCE), (float)value);
    }

    public static void njointCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)JOINTCOUNT), (int)value);
    }

    public static void njointLocations(long struct, XrBodyJointLocationFB.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)JOINTLOCATIONS), (long)value.address());
        XrBodyJointLocationsFB.njointCount(struct, value.remaining());
    }

    public static void nskeletonChangedCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SKELETONCHANGEDCOUNT), (int)value);
    }

    public static void ntime(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)TIME), (long)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)JOINTLOCATIONS)));
    }

    static {
        Struct.Layout layout = XrBodyJointLocationsFB.__struct((Struct.Member[])new Struct.Member[]{XrBodyJointLocationsFB.__member((int)4), XrBodyJointLocationsFB.__member((int)POINTER_SIZE), XrBodyJointLocationsFB.__member((int)4), XrBodyJointLocationsFB.__member((int)4), XrBodyJointLocationsFB.__member((int)4), XrBodyJointLocationsFB.__member((int)POINTER_SIZE), XrBodyJointLocationsFB.__member((int)4), XrBodyJointLocationsFB.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        ISACTIVE = layout.offsetof(2);
        CONFIDENCE = layout.offsetof(3);
        JOINTCOUNT = layout.offsetof(4);
        JOINTLOCATIONS = layout.offsetof(5);
        SKELETONCHANGEDCOUNT = layout.offsetof(6);
        TIME = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<XrBodyJointLocationsFB, Buffer>
    implements NativeResource {
        private static final XrBodyJointLocationsFB ELEMENT_FACTORY = XrBodyJointLocationsFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrBodyJointLocationsFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrBodyJointLocationsFB.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrBodyJointLocationsFB.nnext(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean isActive() {
            return XrBodyJointLocationsFB.nisActive(this.address()) != 0;
        }

        public float confidence() {
            return XrBodyJointLocationsFB.nconfidence(this.address());
        }

        @NativeType(value="uint32_t")
        public int jointCount() {
            return XrBodyJointLocationsFB.njointCount(this.address());
        }

        @NativeType(value="XrBodyJointLocationFB *")
        public XrBodyJointLocationFB.Buffer jointLocations() {
            return XrBodyJointLocationsFB.njointLocations(this.address());
        }

        @NativeType(value="uint32_t")
        public int skeletonChangedCount() {
            return XrBodyJointLocationsFB.nskeletonChangedCount(this.address());
        }

        @NativeType(value="XrTime")
        public long time() {
            return XrBodyJointLocationsFB.ntime(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrBodyJointLocationsFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000076005);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrBodyJointLocationsFB.nnext(this.address(), value);
            return this;
        }

        public Buffer isActive(@NativeType(value="XrBool32") boolean value) {
            XrBodyJointLocationsFB.nisActive(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer confidence(float value) {
            XrBodyJointLocationsFB.nconfidence(this.address(), value);
            return this;
        }

        public Buffer jointLocations(@NativeType(value="XrBodyJointLocationFB *") XrBodyJointLocationFB.Buffer value) {
            XrBodyJointLocationsFB.njointLocations(this.address(), value);
            return this;
        }

        public Buffer skeletonChangedCount(@NativeType(value="uint32_t") int value) {
            XrBodyJointLocationsFB.nskeletonChangedCount(this.address(), value);
            return this;
        }

        public Buffer time(@NativeType(value="XrTime") long value) {
            XrBodyJointLocationsFB.ntime(this.address(), value);
            return this;
        }
    }
}

