/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrExtent3Df;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrBoxf
extends Struct<XrBoxf>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CENTER;
    public static final int EXTENTS;

    protected XrBoxf(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrBoxf create(long address, @Nullable ByteBuffer container) {
        return new XrBoxf(address, container);
    }

    public XrBoxf(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrBoxf.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public XrPosef center() {
        return XrBoxf.ncenter(this.address());
    }

    public XrExtent3Df extents() {
        return XrBoxf.nextents(this.address());
    }

    public XrBoxf center(XrPosef value) {
        XrBoxf.ncenter(this.address(), value);
        return this;
    }

    public XrBoxf center(Consumer<XrPosef> consumer) {
        consumer.accept(this.center());
        return this;
    }

    public XrBoxf extents(XrExtent3Df value) {
        XrBoxf.nextents(this.address(), value);
        return this;
    }

    public XrBoxf extents(Consumer<XrExtent3Df> consumer) {
        consumer.accept(this.extents());
        return this;
    }

    public XrBoxf set(XrPosef center, XrExtent3Df extents) {
        this.center(center);
        this.extents(extents);
        return this;
    }

    public XrBoxf set(XrBoxf src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrBoxf malloc() {
        return new XrBoxf(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrBoxf calloc() {
        return new XrBoxf(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrBoxf create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrBoxf(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrBoxf create(long address) {
        return new XrBoxf(address, null);
    }

    public static @Nullable XrBoxf createSafe(long address) {
        return address == 0L ? null : new XrBoxf(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrBoxf.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrBoxf.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrBoxf malloc(MemoryStack stack) {
        return new XrBoxf(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrBoxf calloc(MemoryStack stack) {
        return new XrBoxf(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static XrPosef ncenter(long struct) {
        return XrPosef.create(struct + (long)CENTER);
    }

    public static XrExtent3Df nextents(long struct) {
        return XrExtent3Df.create(struct + (long)EXTENTS);
    }

    public static void ncenter(long struct, XrPosef value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)CENTER), (long)XrPosef.SIZEOF);
    }

    public static void nextents(long struct, XrExtent3Df value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)EXTENTS), (long)XrExtent3Df.SIZEOF);
    }

    static {
        Struct.Layout layout = XrBoxf.__struct((Struct.Member[])new Struct.Member[]{XrBoxf.__member((int)XrPosef.SIZEOF, (int)XrPosef.ALIGNOF), XrBoxf.__member((int)XrExtent3Df.SIZEOF, (int)XrExtent3Df.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CENTER = layout.offsetof(0);
        EXTENTS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrBoxf, Buffer>
    implements NativeResource {
        private static final XrBoxf ELEMENT_FACTORY = XrBoxf.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrBoxf getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public XrPosef center() {
            return XrBoxf.ncenter(this.address());
        }

        public XrExtent3Df extents() {
            return XrBoxf.nextents(this.address());
        }

        public Buffer center(XrPosef value) {
            XrBoxf.ncenter(this.address(), value);
            return this;
        }

        public Buffer center(Consumer<XrPosef> consumer) {
            consumer.accept(this.center());
            return this;
        }

        public Buffer extents(XrExtent3Df value) {
            XrBoxf.nextents(this.address(), value);
            return this;
        }

        public Buffer extents(Consumer<XrExtent3Df> consumer) {
            consumer.accept(this.extents());
            return this;
        }
    }
}

