/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrColor4f
extends Struct<XrColor4f>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int R;
    public static final int G;
    public static final int B;
    public static final int A;

    protected XrColor4f(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrColor4f create(long address, @Nullable ByteBuffer container) {
        return new XrColor4f(address, container);
    }

    public XrColor4f(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrColor4f.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float r() {
        return XrColor4f.nr(this.address());
    }

    public float g() {
        return XrColor4f.ng(this.address());
    }

    public float b() {
        return XrColor4f.nb(this.address());
    }

    public float a() {
        return XrColor4f.na(this.address());
    }

    public XrColor4f r(float value) {
        XrColor4f.nr(this.address(), value);
        return this;
    }

    public XrColor4f g(float value) {
        XrColor4f.ng(this.address(), value);
        return this;
    }

    public XrColor4f b(float value) {
        XrColor4f.nb(this.address(), value);
        return this;
    }

    public XrColor4f a(float value) {
        XrColor4f.na(this.address(), value);
        return this;
    }

    public XrColor4f set(float r, float g, float b, float a) {
        this.r(r);
        this.g(g);
        this.b(b);
        this.a(a);
        return this;
    }

    public XrColor4f set(XrColor4f src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrColor4f malloc() {
        return new XrColor4f(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrColor4f calloc() {
        return new XrColor4f(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrColor4f create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrColor4f(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrColor4f create(long address) {
        return new XrColor4f(address, null);
    }

    public static @Nullable XrColor4f createSafe(long address) {
        return address == 0L ? null : new XrColor4f(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrColor4f.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrColor4f.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrColor4f malloc(MemoryStack stack) {
        return new XrColor4f(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrColor4f calloc(MemoryStack stack) {
        return new XrColor4f(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nr(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)R));
    }

    public static float ng(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)G));
    }

    public static float nb(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)B));
    }

    public static float na(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)A));
    }

    public static void nr(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)R), (float)value);
    }

    public static void ng(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)G), (float)value);
    }

    public static void nb(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)B), (float)value);
    }

    public static void na(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)A), (float)value);
    }

    static {
        Struct.Layout layout = XrColor4f.__struct((Struct.Member[])new Struct.Member[]{XrColor4f.__member((int)4), XrColor4f.__member((int)4), XrColor4f.__member((int)4), XrColor4f.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        R = layout.offsetof(0);
        G = layout.offsetof(1);
        B = layout.offsetof(2);
        A = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrColor4f, Buffer>
    implements NativeResource {
        private static final XrColor4f ELEMENT_FACTORY = XrColor4f.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrColor4f getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float r() {
            return XrColor4f.nr(this.address());
        }

        public float g() {
            return XrColor4f.ng(this.address());
        }

        public float b() {
            return XrColor4f.nb(this.address());
        }

        public float a() {
            return XrColor4f.na(this.address());
        }

        public Buffer r(float value) {
            XrColor4f.nr(this.address(), value);
            return this;
        }

        public Buffer g(float value) {
            XrColor4f.ng(this.address(), value);
            return this;
        }

        public Buffer b(float value) {
            XrColor4f.nb(this.address(), value);
            return this;
        }

        public Buffer a(float value) {
            XrColor4f.na(this.address(), value);
            return this;
        }
    }
}

