/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrCompositionLayerBaseHeader;
import org.lwjgl.openxr.XrQuaternionf;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.openxr.XrSwapchain;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrCompositionLayerCubeKHR
extends Struct<XrCompositionLayerCubeKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int LAYERFLAGS;
    public static final int SPACE;
    public static final int EYEVISIBILITY;
    public static final int SWAPCHAIN;
    public static final int IMAGEARRAYINDEX;
    public static final int ORIENTATION;

    protected XrCompositionLayerCubeKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrCompositionLayerCubeKHR create(long address, @Nullable ByteBuffer container) {
        return new XrCompositionLayerCubeKHR(address, container);
    }

    public XrCompositionLayerCubeKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrCompositionLayerCubeKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrCompositionLayerCubeKHR.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrCompositionLayerCubeKHR.nnext(this.address());
    }

    @NativeType(value="XrCompositionLayerFlags")
    public long layerFlags() {
        return XrCompositionLayerCubeKHR.nlayerFlags(this.address());
    }

    @NativeType(value="XrSpace")
    public long space() {
        return XrCompositionLayerCubeKHR.nspace(this.address());
    }

    @NativeType(value="XrEyeVisibility")
    public int eyeVisibility() {
        return XrCompositionLayerCubeKHR.neyeVisibility(this.address());
    }

    @NativeType(value="XrSwapchain")
    public long swapchain() {
        return XrCompositionLayerCubeKHR.nswapchain(this.address());
    }

    @NativeType(value="uint32_t")
    public int imageArrayIndex() {
        return XrCompositionLayerCubeKHR.nimageArrayIndex(this.address());
    }

    public XrQuaternionf orientation() {
        return XrCompositionLayerCubeKHR.norientation(this.address());
    }

    public XrCompositionLayerCubeKHR type(@NativeType(value="XrStructureType") int value) {
        XrCompositionLayerCubeKHR.ntype(this.address(), value);
        return this;
    }

    public XrCompositionLayerCubeKHR type$Default() {
        return this.type(1000006000);
    }

    public XrCompositionLayerCubeKHR next(@NativeType(value="void const *") long value) {
        XrCompositionLayerCubeKHR.nnext(this.address(), value);
        return this;
    }

    public XrCompositionLayerCubeKHR layerFlags(@NativeType(value="XrCompositionLayerFlags") long value) {
        XrCompositionLayerCubeKHR.nlayerFlags(this.address(), value);
        return this;
    }

    public XrCompositionLayerCubeKHR space(XrSpace value) {
        XrCompositionLayerCubeKHR.nspace(this.address(), value);
        return this;
    }

    public XrCompositionLayerCubeKHR eyeVisibility(@NativeType(value="XrEyeVisibility") int value) {
        XrCompositionLayerCubeKHR.neyeVisibility(this.address(), value);
        return this;
    }

    public XrCompositionLayerCubeKHR swapchain(XrSwapchain value) {
        XrCompositionLayerCubeKHR.nswapchain(this.address(), value);
        return this;
    }

    public XrCompositionLayerCubeKHR imageArrayIndex(@NativeType(value="uint32_t") int value) {
        XrCompositionLayerCubeKHR.nimageArrayIndex(this.address(), value);
        return this;
    }

    public XrCompositionLayerCubeKHR orientation(XrQuaternionf value) {
        XrCompositionLayerCubeKHR.norientation(this.address(), value);
        return this;
    }

    public XrCompositionLayerCubeKHR orientation(Consumer<XrQuaternionf> consumer) {
        consumer.accept(this.orientation());
        return this;
    }

    public XrCompositionLayerCubeKHR set(int type, long next, long layerFlags, XrSpace space, int eyeVisibility, XrSwapchain swapchain, int imageArrayIndex, XrQuaternionf orientation) {
        this.type(type);
        this.next(next);
        this.layerFlags(layerFlags);
        this.space(space);
        this.eyeVisibility(eyeVisibility);
        this.swapchain(swapchain);
        this.imageArrayIndex(imageArrayIndex);
        this.orientation(orientation);
        return this;
    }

    public XrCompositionLayerCubeKHR set(XrCompositionLayerCubeKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrCompositionLayerCubeKHR malloc() {
        return new XrCompositionLayerCubeKHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrCompositionLayerCubeKHR calloc() {
        return new XrCompositionLayerCubeKHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrCompositionLayerCubeKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrCompositionLayerCubeKHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrCompositionLayerCubeKHR create(long address) {
        return new XrCompositionLayerCubeKHR(address, null);
    }

    public static @Nullable XrCompositionLayerCubeKHR createSafe(long address) {
        return address == 0L ? null : new XrCompositionLayerCubeKHR(address, null);
    }

    public static XrCompositionLayerCubeKHR create(XrCompositionLayerBaseHeader value) {
        return new XrCompositionLayerCubeKHR(value.address(), XrCompositionLayerCubeKHR.__getContainer((Struct)value));
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrCompositionLayerCubeKHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrCompositionLayerCubeKHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static Buffer create(XrCompositionLayerBaseHeader.Buffer value) {
        return new Buffer(value.address(), XrCompositionLayerCubeKHR.__getContainer((StructBuffer)value), -1, 0, value.remaining(), value.remaining());
    }

    public static XrCompositionLayerCubeKHR malloc(MemoryStack stack) {
        return new XrCompositionLayerCubeKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrCompositionLayerCubeKHR calloc(MemoryStack stack) {
        return new XrCompositionLayerCubeKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long nlayerFlags(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)LAYERFLAGS));
    }

    public static long nspace(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SPACE));
    }

    public static int neyeVisibility(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)EYEVISIBILITY));
    }

    public static long nswapchain(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SWAPCHAIN));
    }

    public static int nimageArrayIndex(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)IMAGEARRAYINDEX));
    }

    public static XrQuaternionf norientation(long struct) {
        return XrQuaternionf.create(struct + (long)ORIENTATION);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nlayerFlags(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)LAYERFLAGS), (long)value);
    }

    public static void nspace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SPACE), (long)value.address());
    }

    public static void neyeVisibility(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)EYEVISIBILITY), (int)value);
    }

    public static void nswapchain(long struct, XrSwapchain value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SWAPCHAIN), (long)value.address());
    }

    public static void nimageArrayIndex(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)IMAGEARRAYINDEX), (int)value);
    }

    public static void norientation(long struct, XrQuaternionf value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)ORIENTATION), (long)XrQuaternionf.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)SPACE)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)SWAPCHAIN)));
    }

    static {
        Struct.Layout layout = XrCompositionLayerCubeKHR.__struct((Struct.Member[])new Struct.Member[]{XrCompositionLayerCubeKHR.__member((int)4), XrCompositionLayerCubeKHR.__member((int)POINTER_SIZE), XrCompositionLayerCubeKHR.__member((int)8), XrCompositionLayerCubeKHR.__member((int)POINTER_SIZE), XrCompositionLayerCubeKHR.__member((int)4), XrCompositionLayerCubeKHR.__member((int)POINTER_SIZE), XrCompositionLayerCubeKHR.__member((int)4), XrCompositionLayerCubeKHR.__member((int)XrQuaternionf.SIZEOF, (int)XrQuaternionf.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        LAYERFLAGS = layout.offsetof(2);
        SPACE = layout.offsetof(3);
        EYEVISIBILITY = layout.offsetof(4);
        SWAPCHAIN = layout.offsetof(5);
        IMAGEARRAYINDEX = layout.offsetof(6);
        ORIENTATION = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<XrCompositionLayerCubeKHR, Buffer>
    implements NativeResource {
        private static final XrCompositionLayerCubeKHR ELEMENT_FACTORY = XrCompositionLayerCubeKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrCompositionLayerCubeKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrCompositionLayerCubeKHR.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrCompositionLayerCubeKHR.nnext(this.address());
        }

        @NativeType(value="XrCompositionLayerFlags")
        public long layerFlags() {
            return XrCompositionLayerCubeKHR.nlayerFlags(this.address());
        }

        @NativeType(value="XrSpace")
        public long space() {
            return XrCompositionLayerCubeKHR.nspace(this.address());
        }

        @NativeType(value="XrEyeVisibility")
        public int eyeVisibility() {
            return XrCompositionLayerCubeKHR.neyeVisibility(this.address());
        }

        @NativeType(value="XrSwapchain")
        public long swapchain() {
            return XrCompositionLayerCubeKHR.nswapchain(this.address());
        }

        @NativeType(value="uint32_t")
        public int imageArrayIndex() {
            return XrCompositionLayerCubeKHR.nimageArrayIndex(this.address());
        }

        public XrQuaternionf orientation() {
            return XrCompositionLayerCubeKHR.norientation(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrCompositionLayerCubeKHR.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000006000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrCompositionLayerCubeKHR.nnext(this.address(), value);
            return this;
        }

        public Buffer layerFlags(@NativeType(value="XrCompositionLayerFlags") long value) {
            XrCompositionLayerCubeKHR.nlayerFlags(this.address(), value);
            return this;
        }

        public Buffer space(XrSpace value) {
            XrCompositionLayerCubeKHR.nspace(this.address(), value);
            return this;
        }

        public Buffer eyeVisibility(@NativeType(value="XrEyeVisibility") int value) {
            XrCompositionLayerCubeKHR.neyeVisibility(this.address(), value);
            return this;
        }

        public Buffer swapchain(XrSwapchain value) {
            XrCompositionLayerCubeKHR.nswapchain(this.address(), value);
            return this;
        }

        public Buffer imageArrayIndex(@NativeType(value="uint32_t") int value) {
            XrCompositionLayerCubeKHR.nimageArrayIndex(this.address(), value);
            return this;
        }

        public Buffer orientation(XrQuaternionf value) {
            XrCompositionLayerCubeKHR.norientation(this.address(), value);
            return this;
        }

        public Buffer orientation(Consumer<XrQuaternionf> consumer) {
            consumer.accept(this.orientation());
            return this;
        }
    }
}

