/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrDebugUtilsLabelEXT
extends Struct<XrDebugUtilsLabelEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int LABELNAME;

    protected XrDebugUtilsLabelEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrDebugUtilsLabelEXT create(long address, @Nullable ByteBuffer container) {
        return new XrDebugUtilsLabelEXT(address, container);
    }

    public XrDebugUtilsLabelEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrDebugUtilsLabelEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrDebugUtilsLabelEXT.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrDebugUtilsLabelEXT.nnext(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer labelName() {
        return XrDebugUtilsLabelEXT.nlabelName(this.address());
    }

    @NativeType(value="char const *")
    public String labelNameString() {
        return XrDebugUtilsLabelEXT.nlabelNameString(this.address());
    }

    public XrDebugUtilsLabelEXT type(@NativeType(value="XrStructureType") int value) {
        XrDebugUtilsLabelEXT.ntype(this.address(), value);
        return this;
    }

    public XrDebugUtilsLabelEXT type$Default() {
        return this.type(1000019003);
    }

    public XrDebugUtilsLabelEXT next(@NativeType(value="void const *") long value) {
        XrDebugUtilsLabelEXT.nnext(this.address(), value);
        return this;
    }

    public XrDebugUtilsLabelEXT labelName(@NativeType(value="char const *") ByteBuffer value) {
        XrDebugUtilsLabelEXT.nlabelName(this.address(), value);
        return this;
    }

    public XrDebugUtilsLabelEXT set(int type, long next, ByteBuffer labelName) {
        this.type(type);
        this.next(next);
        this.labelName(labelName);
        return this;
    }

    public XrDebugUtilsLabelEXT set(XrDebugUtilsLabelEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrDebugUtilsLabelEXT malloc() {
        return new XrDebugUtilsLabelEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrDebugUtilsLabelEXT calloc() {
        return new XrDebugUtilsLabelEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrDebugUtilsLabelEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrDebugUtilsLabelEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrDebugUtilsLabelEXT create(long address) {
        return new XrDebugUtilsLabelEXT(address, null);
    }

    public static @Nullable XrDebugUtilsLabelEXT createSafe(long address) {
        return address == 0L ? null : new XrDebugUtilsLabelEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrDebugUtilsLabelEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrDebugUtilsLabelEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrDebugUtilsLabelEXT malloc(MemoryStack stack) {
        return new XrDebugUtilsLabelEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrDebugUtilsLabelEXT calloc(MemoryStack stack) {
        return new XrDebugUtilsLabelEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static ByteBuffer nlabelName(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)LABELNAME)));
    }

    public static String nlabelNameString(long struct) {
        return MemoryUtil.memUTF8((long)MemoryUtil.memGetAddress((long)(struct + (long)LABELNAME)));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nlabelName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)LABELNAME), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)LABELNAME)));
    }

    static {
        Struct.Layout layout = XrDebugUtilsLabelEXT.__struct((Struct.Member[])new Struct.Member[]{XrDebugUtilsLabelEXT.__member((int)4), XrDebugUtilsLabelEXT.__member((int)POINTER_SIZE), XrDebugUtilsLabelEXT.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        LABELNAME = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrDebugUtilsLabelEXT, Buffer>
    implements NativeResource {
        private static final XrDebugUtilsLabelEXT ELEMENT_FACTORY = XrDebugUtilsLabelEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrDebugUtilsLabelEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrDebugUtilsLabelEXT.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrDebugUtilsLabelEXT.nnext(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer labelName() {
            return XrDebugUtilsLabelEXT.nlabelName(this.address());
        }

        @NativeType(value="char const *")
        public String labelNameString() {
            return XrDebugUtilsLabelEXT.nlabelNameString(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrDebugUtilsLabelEXT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000019003);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrDebugUtilsLabelEXT.nnext(this.address(), value);
            return this;
        }

        public Buffer labelName(@NativeType(value="char const *") ByteBuffer value) {
            XrDebugUtilsLabelEXT.nlabelName(this.address(), value);
            return this;
        }
    }
}

