/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrExtent3Df;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class XrExtent3DfKHR
extends XrExtent3Df {
    protected XrExtent3DfKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected XrExtent3DfKHR create(long address, @Nullable ByteBuffer container) {
        return new XrExtent3DfKHR(address, container);
    }

    public XrExtent3DfKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public XrExtent3DfKHR width(float value) {
        XrExtent3DfKHR.nwidth(this.address(), value);
        return this;
    }

    @Override
    public XrExtent3DfKHR height(float value) {
        XrExtent3DfKHR.nheight(this.address(), value);
        return this;
    }

    @Override
    public XrExtent3DfKHR depth(float value) {
        XrExtent3DfKHR.ndepth(this.address(), value);
        return this;
    }

    @Override
    public XrExtent3DfKHR set(float width, float height, float depth) {
        this.width(width);
        this.height(height);
        this.depth(depth);
        return this;
    }

    public XrExtent3DfKHR set(XrExtent3DfKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrExtent3DfKHR malloc() {
        return new XrExtent3DfKHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrExtent3DfKHR calloc() {
        return new XrExtent3DfKHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrExtent3DfKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrExtent3DfKHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrExtent3DfKHR create(long address) {
        return new XrExtent3DfKHR(address, null);
    }

    public static @Nullable XrExtent3DfKHR createSafe(long address) {
        return address == 0L ? null : new XrExtent3DfKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrExtent3DfKHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrExtent3DfKHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrExtent3DfKHR malloc(MemoryStack stack) {
        return new XrExtent3DfKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrExtent3DfKHR calloc(MemoryStack stack) {
        return new XrExtent3DfKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends XrExtent3Df.Buffer {
        private static final XrExtent3DfKHR ELEMENT_FACTORY = XrExtent3DfKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected XrExtent3DfKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer width(float value) {
            XrExtent3DfKHR.nwidth(this.address(), value);
            return this;
        }

        @Override
        public Buffer height(float value) {
            XrExtent3DfKHR.nheight(this.address(), value);
            return this;
        }

        @Override
        public Buffer depth(float value) {
            XrExtent3DfKHR.ndepth(this.address(), value);
            return this;
        }
    }
}

