/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrExternalCameraExtrinsicsOCULUS
extends Struct<XrExternalCameraExtrinsicsOCULUS>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LASTCHANGETIME;
    public static final int CAMERASTATUSFLAGS;
    public static final int ATTACHEDTODEVICE;
    public static final int RELATIVEPOSE;

    protected XrExternalCameraExtrinsicsOCULUS(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrExternalCameraExtrinsicsOCULUS create(long address, @Nullable ByteBuffer container) {
        return new XrExternalCameraExtrinsicsOCULUS(address, container);
    }

    public XrExternalCameraExtrinsicsOCULUS(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrExternalCameraExtrinsicsOCULUS.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrTime")
    public long lastChangeTime() {
        return XrExternalCameraExtrinsicsOCULUS.nlastChangeTime(this.address());
    }

    @NativeType(value="XrExternalCameraStatusFlagsOCULUS")
    public long cameraStatusFlags() {
        return XrExternalCameraExtrinsicsOCULUS.ncameraStatusFlags(this.address());
    }

    @NativeType(value="XrExternalCameraAttachedToDeviceOCULUS")
    public int attachedToDevice() {
        return XrExternalCameraExtrinsicsOCULUS.nattachedToDevice(this.address());
    }

    public XrPosef relativePose() {
        return XrExternalCameraExtrinsicsOCULUS.nrelativePose(this.address());
    }

    public XrExternalCameraExtrinsicsOCULUS lastChangeTime(@NativeType(value="XrTime") long value) {
        XrExternalCameraExtrinsicsOCULUS.nlastChangeTime(this.address(), value);
        return this;
    }

    public XrExternalCameraExtrinsicsOCULUS cameraStatusFlags(@NativeType(value="XrExternalCameraStatusFlagsOCULUS") long value) {
        XrExternalCameraExtrinsicsOCULUS.ncameraStatusFlags(this.address(), value);
        return this;
    }

    public XrExternalCameraExtrinsicsOCULUS attachedToDevice(@NativeType(value="XrExternalCameraAttachedToDeviceOCULUS") int value) {
        XrExternalCameraExtrinsicsOCULUS.nattachedToDevice(this.address(), value);
        return this;
    }

    public XrExternalCameraExtrinsicsOCULUS relativePose(XrPosef value) {
        XrExternalCameraExtrinsicsOCULUS.nrelativePose(this.address(), value);
        return this;
    }

    public XrExternalCameraExtrinsicsOCULUS relativePose(Consumer<XrPosef> consumer) {
        consumer.accept(this.relativePose());
        return this;
    }

    public XrExternalCameraExtrinsicsOCULUS set(long lastChangeTime, long cameraStatusFlags, int attachedToDevice, XrPosef relativePose) {
        this.lastChangeTime(lastChangeTime);
        this.cameraStatusFlags(cameraStatusFlags);
        this.attachedToDevice(attachedToDevice);
        this.relativePose(relativePose);
        return this;
    }

    public XrExternalCameraExtrinsicsOCULUS set(XrExternalCameraExtrinsicsOCULUS src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrExternalCameraExtrinsicsOCULUS malloc() {
        return new XrExternalCameraExtrinsicsOCULUS(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrExternalCameraExtrinsicsOCULUS calloc() {
        return new XrExternalCameraExtrinsicsOCULUS(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrExternalCameraExtrinsicsOCULUS create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrExternalCameraExtrinsicsOCULUS(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrExternalCameraExtrinsicsOCULUS create(long address) {
        return new XrExternalCameraExtrinsicsOCULUS(address, null);
    }

    public static @Nullable XrExternalCameraExtrinsicsOCULUS createSafe(long address) {
        return address == 0L ? null : new XrExternalCameraExtrinsicsOCULUS(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrExternalCameraExtrinsicsOCULUS.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrExternalCameraExtrinsicsOCULUS.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrExternalCameraExtrinsicsOCULUS malloc(MemoryStack stack) {
        return new XrExternalCameraExtrinsicsOCULUS(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrExternalCameraExtrinsicsOCULUS calloc(MemoryStack stack) {
        return new XrExternalCameraExtrinsicsOCULUS(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nlastChangeTime(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)LASTCHANGETIME));
    }

    public static long ncameraStatusFlags(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)CAMERASTATUSFLAGS));
    }

    public static int nattachedToDevice(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)ATTACHEDTODEVICE));
    }

    public static XrPosef nrelativePose(long struct) {
        return XrPosef.create(struct + (long)RELATIVEPOSE);
    }

    public static void nlastChangeTime(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)LASTCHANGETIME), (long)value);
    }

    public static void ncameraStatusFlags(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)CAMERASTATUSFLAGS), (long)value);
    }

    public static void nattachedToDevice(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)ATTACHEDTODEVICE), (int)value);
    }

    public static void nrelativePose(long struct, XrPosef value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)RELATIVEPOSE), (long)XrPosef.SIZEOF);
    }

    static {
        Struct.Layout layout = XrExternalCameraExtrinsicsOCULUS.__struct((Struct.Member[])new Struct.Member[]{XrExternalCameraExtrinsicsOCULUS.__member((int)8), XrExternalCameraExtrinsicsOCULUS.__member((int)8), XrExternalCameraExtrinsicsOCULUS.__member((int)4), XrExternalCameraExtrinsicsOCULUS.__member((int)XrPosef.SIZEOF, (int)XrPosef.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LASTCHANGETIME = layout.offsetof(0);
        CAMERASTATUSFLAGS = layout.offsetof(1);
        ATTACHEDTODEVICE = layout.offsetof(2);
        RELATIVEPOSE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrExternalCameraExtrinsicsOCULUS, Buffer>
    implements NativeResource {
        private static final XrExternalCameraExtrinsicsOCULUS ELEMENT_FACTORY = XrExternalCameraExtrinsicsOCULUS.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrExternalCameraExtrinsicsOCULUS getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrTime")
        public long lastChangeTime() {
            return XrExternalCameraExtrinsicsOCULUS.nlastChangeTime(this.address());
        }

        @NativeType(value="XrExternalCameraStatusFlagsOCULUS")
        public long cameraStatusFlags() {
            return XrExternalCameraExtrinsicsOCULUS.ncameraStatusFlags(this.address());
        }

        @NativeType(value="XrExternalCameraAttachedToDeviceOCULUS")
        public int attachedToDevice() {
            return XrExternalCameraExtrinsicsOCULUS.nattachedToDevice(this.address());
        }

        public XrPosef relativePose() {
            return XrExternalCameraExtrinsicsOCULUS.nrelativePose(this.address());
        }

        public Buffer lastChangeTime(@NativeType(value="XrTime") long value) {
            XrExternalCameraExtrinsicsOCULUS.nlastChangeTime(this.address(), value);
            return this;
        }

        public Buffer cameraStatusFlags(@NativeType(value="XrExternalCameraStatusFlagsOCULUS") long value) {
            XrExternalCameraExtrinsicsOCULUS.ncameraStatusFlags(this.address(), value);
            return this;
        }

        public Buffer attachedToDevice(@NativeType(value="XrExternalCameraAttachedToDeviceOCULUS") int value) {
            XrExternalCameraExtrinsicsOCULUS.nattachedToDevice(this.address(), value);
            return this;
        }

        public Buffer relativePose(XrPosef value) {
            XrExternalCameraExtrinsicsOCULUS.nrelativePose(this.address(), value);
            return this;
        }

        public Buffer relativePose(Consumer<XrPosef> consumer) {
            consumer.accept(this.relativePose());
            return this;
        }
    }
}

