/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrExternalCameraExtrinsicsOCULUS;
import org.lwjgl.openxr.XrExternalCameraIntrinsicsOCULUS;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrExternalCameraOCULUS
extends Struct<XrExternalCameraOCULUS>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int NAME;
    public static final int INTRINSICS;
    public static final int EXTRINSICS;

    protected XrExternalCameraOCULUS(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrExternalCameraOCULUS create(long address, @Nullable ByteBuffer container) {
        return new XrExternalCameraOCULUS(address, container);
    }

    public XrExternalCameraOCULUS(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrExternalCameraOCULUS.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrExternalCameraOCULUS.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrExternalCameraOCULUS.nnext(this.address());
    }

    @NativeType(value="char[XR_MAX_EXTERNAL_CAMERA_NAME_SIZE_OCULUS]")
    public ByteBuffer name() {
        return XrExternalCameraOCULUS.nname(this.address());
    }

    @NativeType(value="char[XR_MAX_EXTERNAL_CAMERA_NAME_SIZE_OCULUS]")
    public String nameString() {
        return XrExternalCameraOCULUS.nnameString(this.address());
    }

    public XrExternalCameraIntrinsicsOCULUS intrinsics() {
        return XrExternalCameraOCULUS.nintrinsics(this.address());
    }

    public XrExternalCameraExtrinsicsOCULUS extrinsics() {
        return XrExternalCameraOCULUS.nextrinsics(this.address());
    }

    public XrExternalCameraOCULUS type(@NativeType(value="XrStructureType") int value) {
        XrExternalCameraOCULUS.ntype(this.address(), value);
        return this;
    }

    public XrExternalCameraOCULUS type$Default() {
        return this.type(1000226000);
    }

    public XrExternalCameraOCULUS next(@NativeType(value="void const *") long value) {
        XrExternalCameraOCULUS.nnext(this.address(), value);
        return this;
    }

    public XrExternalCameraOCULUS set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrExternalCameraOCULUS set(XrExternalCameraOCULUS src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrExternalCameraOCULUS malloc() {
        return new XrExternalCameraOCULUS(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrExternalCameraOCULUS calloc() {
        return new XrExternalCameraOCULUS(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrExternalCameraOCULUS create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrExternalCameraOCULUS(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrExternalCameraOCULUS create(long address) {
        return new XrExternalCameraOCULUS(address, null);
    }

    public static @Nullable XrExternalCameraOCULUS createSafe(long address) {
        return address == 0L ? null : new XrExternalCameraOCULUS(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrExternalCameraOCULUS.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrExternalCameraOCULUS.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrExternalCameraOCULUS malloc(MemoryStack stack) {
        return new XrExternalCameraOCULUS(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrExternalCameraOCULUS calloc(MemoryStack stack) {
        return new XrExternalCameraOCULUS(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)NAME), (int)32);
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memUTF8((long)(struct + (long)NAME));
    }

    public static XrExternalCameraIntrinsicsOCULUS nintrinsics(long struct) {
        return XrExternalCameraIntrinsicsOCULUS.create(struct + (long)INTRINSICS);
    }

    public static XrExternalCameraExtrinsicsOCULUS nextrinsics(long struct) {
        return XrExternalCameraExtrinsicsOCULUS.create(struct + (long)EXTRINSICS);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    static {
        Struct.Layout layout = XrExternalCameraOCULUS.__struct((Struct.Member[])new Struct.Member[]{XrExternalCameraOCULUS.__member((int)4), XrExternalCameraOCULUS.__member((int)POINTER_SIZE), XrExternalCameraOCULUS.__array((int)1, (int)32), XrExternalCameraOCULUS.__member((int)XrExternalCameraIntrinsicsOCULUS.SIZEOF, (int)XrExternalCameraIntrinsicsOCULUS.ALIGNOF), XrExternalCameraOCULUS.__member((int)XrExternalCameraExtrinsicsOCULUS.SIZEOF, (int)XrExternalCameraExtrinsicsOCULUS.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        NAME = layout.offsetof(2);
        INTRINSICS = layout.offsetof(3);
        EXTRINSICS = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrExternalCameraOCULUS, Buffer>
    implements NativeResource {
        private static final XrExternalCameraOCULUS ELEMENT_FACTORY = XrExternalCameraOCULUS.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrExternalCameraOCULUS getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrExternalCameraOCULUS.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrExternalCameraOCULUS.nnext(this.address());
        }

        @NativeType(value="char[XR_MAX_EXTERNAL_CAMERA_NAME_SIZE_OCULUS]")
        public ByteBuffer name() {
            return XrExternalCameraOCULUS.nname(this.address());
        }

        @NativeType(value="char[XR_MAX_EXTERNAL_CAMERA_NAME_SIZE_OCULUS]")
        public String nameString() {
            return XrExternalCameraOCULUS.nnameString(this.address());
        }

        public XrExternalCameraIntrinsicsOCULUS intrinsics() {
            return XrExternalCameraOCULUS.nintrinsics(this.address());
        }

        public XrExternalCameraExtrinsicsOCULUS extrinsics() {
            return XrExternalCameraOCULUS.nextrinsics(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrExternalCameraOCULUS.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000226000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrExternalCameraOCULUS.nnext(this.address(), value);
            return this;
        }
    }
}

