/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrFaceTrackerCreateInfoFB
extends Struct<XrFaceTrackerCreateInfoFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int FACEEXPRESSIONSET;

    protected XrFaceTrackerCreateInfoFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrFaceTrackerCreateInfoFB create(long address, @Nullable ByteBuffer container) {
        return new XrFaceTrackerCreateInfoFB(address, container);
    }

    public XrFaceTrackerCreateInfoFB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrFaceTrackerCreateInfoFB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrFaceTrackerCreateInfoFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrFaceTrackerCreateInfoFB.nnext(this.address());
    }

    @NativeType(value="XrFaceExpressionSetFB")
    public int faceExpressionSet() {
        return XrFaceTrackerCreateInfoFB.nfaceExpressionSet(this.address());
    }

    public XrFaceTrackerCreateInfoFB type(@NativeType(value="XrStructureType") int value) {
        XrFaceTrackerCreateInfoFB.ntype(this.address(), value);
        return this;
    }

    public XrFaceTrackerCreateInfoFB type$Default() {
        return this.type(1000201005);
    }

    public XrFaceTrackerCreateInfoFB next(@NativeType(value="void const *") long value) {
        XrFaceTrackerCreateInfoFB.nnext(this.address(), value);
        return this;
    }

    public XrFaceTrackerCreateInfoFB faceExpressionSet(@NativeType(value="XrFaceExpressionSetFB") int value) {
        XrFaceTrackerCreateInfoFB.nfaceExpressionSet(this.address(), value);
        return this;
    }

    public XrFaceTrackerCreateInfoFB set(int type, long next, int faceExpressionSet) {
        this.type(type);
        this.next(next);
        this.faceExpressionSet(faceExpressionSet);
        return this;
    }

    public XrFaceTrackerCreateInfoFB set(XrFaceTrackerCreateInfoFB src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrFaceTrackerCreateInfoFB malloc() {
        return new XrFaceTrackerCreateInfoFB(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrFaceTrackerCreateInfoFB calloc() {
        return new XrFaceTrackerCreateInfoFB(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrFaceTrackerCreateInfoFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrFaceTrackerCreateInfoFB(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrFaceTrackerCreateInfoFB create(long address) {
        return new XrFaceTrackerCreateInfoFB(address, null);
    }

    public static @Nullable XrFaceTrackerCreateInfoFB createSafe(long address) {
        return address == 0L ? null : new XrFaceTrackerCreateInfoFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrFaceTrackerCreateInfoFB.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrFaceTrackerCreateInfoFB.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrFaceTrackerCreateInfoFB malloc(MemoryStack stack) {
        return new XrFaceTrackerCreateInfoFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrFaceTrackerCreateInfoFB calloc(MemoryStack stack) {
        return new XrFaceTrackerCreateInfoFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nfaceExpressionSet(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FACEEXPRESSIONSET));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nfaceExpressionSet(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FACEEXPRESSIONSET), (int)value);
    }

    static {
        Struct.Layout layout = XrFaceTrackerCreateInfoFB.__struct((Struct.Member[])new Struct.Member[]{XrFaceTrackerCreateInfoFB.__member((int)4), XrFaceTrackerCreateInfoFB.__member((int)POINTER_SIZE), XrFaceTrackerCreateInfoFB.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        FACEEXPRESSIONSET = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrFaceTrackerCreateInfoFB, Buffer>
    implements NativeResource {
        private static final XrFaceTrackerCreateInfoFB ELEMENT_FACTORY = XrFaceTrackerCreateInfoFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrFaceTrackerCreateInfoFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrFaceTrackerCreateInfoFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrFaceTrackerCreateInfoFB.nnext(this.address());
        }

        @NativeType(value="XrFaceExpressionSetFB")
        public int faceExpressionSet() {
            return XrFaceTrackerCreateInfoFB.nfaceExpressionSet(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrFaceTrackerCreateInfoFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000201005);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrFaceTrackerCreateInfoFB.nnext(this.address(), value);
            return this;
        }

        public Buffer faceExpressionSet(@NativeType(value="XrFaceExpressionSetFB") int value) {
            XrFaceTrackerCreateInfoFB.nfaceExpressionSet(this.address(), value);
            return this;
        }
    }
}

