/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrFacialExpressionsHTC
extends Struct<XrFacialExpressionsHTC>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int ISACTIVE;
    public static final int SAMPLETIME;
    public static final int EXPRESSIONCOUNT;
    public static final int EXPRESSIONWEIGHTINGS;

    protected XrFacialExpressionsHTC(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrFacialExpressionsHTC create(long address, @Nullable ByteBuffer container) {
        return new XrFacialExpressionsHTC(address, container);
    }

    public XrFacialExpressionsHTC(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrFacialExpressionsHTC.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrFacialExpressionsHTC.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrFacialExpressionsHTC.nnext(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean isActive() {
        return XrFacialExpressionsHTC.nisActive(this.address()) != 0;
    }

    @NativeType(value="XrTime")
    public long sampleTime() {
        return XrFacialExpressionsHTC.nsampleTime(this.address());
    }

    @NativeType(value="uint32_t")
    public int expressionCount() {
        return XrFacialExpressionsHTC.nexpressionCount(this.address());
    }

    @NativeType(value="float *")
    public FloatBuffer expressionWeightings(int capacity) {
        return XrFacialExpressionsHTC.nexpressionWeightings(this.address(), capacity);
    }

    public XrFacialExpressionsHTC type(@NativeType(value="XrStructureType") int value) {
        XrFacialExpressionsHTC.ntype(this.address(), value);
        return this;
    }

    public XrFacialExpressionsHTC type$Default() {
        return this.type(1000104002);
    }

    public XrFacialExpressionsHTC next(@NativeType(value="void const *") long value) {
        XrFacialExpressionsHTC.nnext(this.address(), value);
        return this;
    }

    public XrFacialExpressionsHTC isActive(@NativeType(value="XrBool32") boolean value) {
        XrFacialExpressionsHTC.nisActive(this.address(), value ? 1 : 0);
        return this;
    }

    public XrFacialExpressionsHTC sampleTime(@NativeType(value="XrTime") long value) {
        XrFacialExpressionsHTC.nsampleTime(this.address(), value);
        return this;
    }

    public XrFacialExpressionsHTC expressionCount(@NativeType(value="uint32_t") int value) {
        XrFacialExpressionsHTC.nexpressionCount(this.address(), value);
        return this;
    }

    public XrFacialExpressionsHTC expressionWeightings(@NativeType(value="float *") FloatBuffer value) {
        XrFacialExpressionsHTC.nexpressionWeightings(this.address(), value);
        return this;
    }

    public XrFacialExpressionsHTC set(int type, long next, boolean isActive, long sampleTime, int expressionCount, FloatBuffer expressionWeightings) {
        this.type(type);
        this.next(next);
        this.isActive(isActive);
        this.sampleTime(sampleTime);
        this.expressionCount(expressionCount);
        this.expressionWeightings(expressionWeightings);
        return this;
    }

    public XrFacialExpressionsHTC set(XrFacialExpressionsHTC src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrFacialExpressionsHTC malloc() {
        return new XrFacialExpressionsHTC(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrFacialExpressionsHTC calloc() {
        return new XrFacialExpressionsHTC(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrFacialExpressionsHTC create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrFacialExpressionsHTC(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrFacialExpressionsHTC create(long address) {
        return new XrFacialExpressionsHTC(address, null);
    }

    public static @Nullable XrFacialExpressionsHTC createSafe(long address) {
        return address == 0L ? null : new XrFacialExpressionsHTC(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrFacialExpressionsHTC.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrFacialExpressionsHTC.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrFacialExpressionsHTC malloc(MemoryStack stack) {
        return new XrFacialExpressionsHTC(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrFacialExpressionsHTC calloc(MemoryStack stack) {
        return new XrFacialExpressionsHTC(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nisActive(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)ISACTIVE));
    }

    public static long nsampleTime(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)SAMPLETIME));
    }

    public static int nexpressionCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)EXPRESSIONCOUNT));
    }

    public static FloatBuffer nexpressionWeightings(long struct, int capacity) {
        return MemoryUtil.memFloatBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)EXPRESSIONWEIGHTINGS)), (int)capacity);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nisActive(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)ISACTIVE), (int)value);
    }

    public static void nsampleTime(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)SAMPLETIME), (long)value);
    }

    public static void nexpressionCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)EXPRESSIONCOUNT), (int)value);
    }

    public static void nexpressionWeightings(long struct, FloatBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)EXPRESSIONWEIGHTINGS), (long)MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)EXPRESSIONWEIGHTINGS)));
    }

    static {
        Struct.Layout layout = XrFacialExpressionsHTC.__struct((Struct.Member[])new Struct.Member[]{XrFacialExpressionsHTC.__member((int)4), XrFacialExpressionsHTC.__member((int)POINTER_SIZE), XrFacialExpressionsHTC.__member((int)4), XrFacialExpressionsHTC.__member((int)8), XrFacialExpressionsHTC.__member((int)4), XrFacialExpressionsHTC.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        ISACTIVE = layout.offsetof(2);
        SAMPLETIME = layout.offsetof(3);
        EXPRESSIONCOUNT = layout.offsetof(4);
        EXPRESSIONWEIGHTINGS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<XrFacialExpressionsHTC, Buffer>
    implements NativeResource {
        private static final XrFacialExpressionsHTC ELEMENT_FACTORY = XrFacialExpressionsHTC.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrFacialExpressionsHTC getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrFacialExpressionsHTC.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrFacialExpressionsHTC.nnext(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean isActive() {
            return XrFacialExpressionsHTC.nisActive(this.address()) != 0;
        }

        @NativeType(value="XrTime")
        public long sampleTime() {
            return XrFacialExpressionsHTC.nsampleTime(this.address());
        }

        @NativeType(value="uint32_t")
        public int expressionCount() {
            return XrFacialExpressionsHTC.nexpressionCount(this.address());
        }

        @NativeType(value="float *")
        public FloatBuffer expressionWeightings(int capacity) {
            return XrFacialExpressionsHTC.nexpressionWeightings(this.address(), capacity);
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrFacialExpressionsHTC.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000104002);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrFacialExpressionsHTC.nnext(this.address(), value);
            return this;
        }

        public Buffer isActive(@NativeType(value="XrBool32") boolean value) {
            XrFacialExpressionsHTC.nisActive(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer sampleTime(@NativeType(value="XrTime") long value) {
            XrFacialExpressionsHTC.nsampleTime(this.address(), value);
            return this;
        }

        public Buffer expressionCount(@NativeType(value="uint32_t") int value) {
            XrFacialExpressionsHTC.nexpressionCount(this.address(), value);
            return this;
        }

        public Buffer expressionWeightings(@NativeType(value="float *") FloatBuffer value) {
            XrFacialExpressionsHTC.nexpressionWeightings(this.address(), value);
            return this;
        }
    }
}

