/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrVector3f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrHandJointVelocityEXT
extends Struct<XrHandJointVelocityEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VELOCITYFLAGS;
    public static final int LINEARVELOCITY;
    public static final int ANGULARVELOCITY;

    protected XrHandJointVelocityEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrHandJointVelocityEXT create(long address, @Nullable ByteBuffer container) {
        return new XrHandJointVelocityEXT(address, container);
    }

    public XrHandJointVelocityEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrHandJointVelocityEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrSpaceVelocityFlags")
    public long velocityFlags() {
        return XrHandJointVelocityEXT.nvelocityFlags(this.address());
    }

    public XrVector3f linearVelocity() {
        return XrHandJointVelocityEXT.nlinearVelocity(this.address());
    }

    public XrVector3f angularVelocity() {
        return XrHandJointVelocityEXT.nangularVelocity(this.address());
    }

    public XrHandJointVelocityEXT velocityFlags(@NativeType(value="XrSpaceVelocityFlags") long value) {
        XrHandJointVelocityEXT.nvelocityFlags(this.address(), value);
        return this;
    }

    public XrHandJointVelocityEXT linearVelocity(XrVector3f value) {
        XrHandJointVelocityEXT.nlinearVelocity(this.address(), value);
        return this;
    }

    public XrHandJointVelocityEXT linearVelocity(Consumer<XrVector3f> consumer) {
        consumer.accept(this.linearVelocity());
        return this;
    }

    public XrHandJointVelocityEXT angularVelocity(XrVector3f value) {
        XrHandJointVelocityEXT.nangularVelocity(this.address(), value);
        return this;
    }

    public XrHandJointVelocityEXT angularVelocity(Consumer<XrVector3f> consumer) {
        consumer.accept(this.angularVelocity());
        return this;
    }

    public XrHandJointVelocityEXT set(long velocityFlags, XrVector3f linearVelocity, XrVector3f angularVelocity) {
        this.velocityFlags(velocityFlags);
        this.linearVelocity(linearVelocity);
        this.angularVelocity(angularVelocity);
        return this;
    }

    public XrHandJointVelocityEXT set(XrHandJointVelocityEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrHandJointVelocityEXT malloc() {
        return new XrHandJointVelocityEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrHandJointVelocityEXT calloc() {
        return new XrHandJointVelocityEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrHandJointVelocityEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrHandJointVelocityEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrHandJointVelocityEXT create(long address) {
        return new XrHandJointVelocityEXT(address, null);
    }

    public static @Nullable XrHandJointVelocityEXT createSafe(long address) {
        return address == 0L ? null : new XrHandJointVelocityEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrHandJointVelocityEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrHandJointVelocityEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrHandJointVelocityEXT malloc(MemoryStack stack) {
        return new XrHandJointVelocityEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrHandJointVelocityEXT calloc(MemoryStack stack) {
        return new XrHandJointVelocityEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nvelocityFlags(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)VELOCITYFLAGS));
    }

    public static XrVector3f nlinearVelocity(long struct) {
        return XrVector3f.create(struct + (long)LINEARVELOCITY);
    }

    public static XrVector3f nangularVelocity(long struct) {
        return XrVector3f.create(struct + (long)ANGULARVELOCITY);
    }

    public static void nvelocityFlags(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)VELOCITYFLAGS), (long)value);
    }

    public static void nlinearVelocity(long struct, XrVector3f value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)LINEARVELOCITY), (long)XrVector3f.SIZEOF);
    }

    public static void nangularVelocity(long struct, XrVector3f value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)ANGULARVELOCITY), (long)XrVector3f.SIZEOF);
    }

    static {
        Struct.Layout layout = XrHandJointVelocityEXT.__struct((Struct.Member[])new Struct.Member[]{XrHandJointVelocityEXT.__member((int)8), XrHandJointVelocityEXT.__member((int)XrVector3f.SIZEOF, (int)XrVector3f.ALIGNOF), XrHandJointVelocityEXT.__member((int)XrVector3f.SIZEOF, (int)XrVector3f.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VELOCITYFLAGS = layout.offsetof(0);
        LINEARVELOCITY = layout.offsetof(1);
        ANGULARVELOCITY = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrHandJointVelocityEXT, Buffer>
    implements NativeResource {
        private static final XrHandJointVelocityEXT ELEMENT_FACTORY = XrHandJointVelocityEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrHandJointVelocityEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrSpaceVelocityFlags")
        public long velocityFlags() {
            return XrHandJointVelocityEXT.nvelocityFlags(this.address());
        }

        public XrVector3f linearVelocity() {
            return XrHandJointVelocityEXT.nlinearVelocity(this.address());
        }

        public XrVector3f angularVelocity() {
            return XrHandJointVelocityEXT.nangularVelocity(this.address());
        }

        public Buffer velocityFlags(@NativeType(value="XrSpaceVelocityFlags") long value) {
            XrHandJointVelocityEXT.nvelocityFlags(this.address(), value);
            return this;
        }

        public Buffer linearVelocity(XrVector3f value) {
            XrHandJointVelocityEXT.nlinearVelocity(this.address(), value);
            return this;
        }

        public Buffer linearVelocity(Consumer<XrVector3f> consumer) {
            consumer.accept(this.linearVelocity());
            return this;
        }

        public Buffer angularVelocity(XrVector3f value) {
            XrHandJointVelocityEXT.nangularVelocity(this.address(), value);
            return this;
        }

        public Buffer angularVelocity(Consumer<XrVector3f> consumer) {
            consumer.accept(this.angularVelocity());
            return this;
        }
    }
}

