/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrAction;
import org.lwjgl.openxr.XrBindingModificationBaseHeaderKHR;
import org.lwjgl.openxr.XrHapticBaseHeader;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrInteractionProfileAnalogThresholdVALVE
extends Struct<XrInteractionProfileAnalogThresholdVALVE>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int ACTION;
    public static final int BINDING;
    public static final int ONTHRESHOLD;
    public static final int OFFTHRESHOLD;
    public static final int ONHAPTIC;
    public static final int OFFHAPTIC;

    protected XrInteractionProfileAnalogThresholdVALVE(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrInteractionProfileAnalogThresholdVALVE create(long address, @Nullable ByteBuffer container) {
        return new XrInteractionProfileAnalogThresholdVALVE(address, container);
    }

    public XrInteractionProfileAnalogThresholdVALVE(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrInteractionProfileAnalogThresholdVALVE.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrInteractionProfileAnalogThresholdVALVE.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrInteractionProfileAnalogThresholdVALVE.nnext(this.address());
    }

    @NativeType(value="XrAction")
    public long action() {
        return XrInteractionProfileAnalogThresholdVALVE.naction(this.address());
    }

    @NativeType(value="XrPath")
    public long binding() {
        return XrInteractionProfileAnalogThresholdVALVE.nbinding(this.address());
    }

    public float onThreshold() {
        return XrInteractionProfileAnalogThresholdVALVE.nonThreshold(this.address());
    }

    public float offThreshold() {
        return XrInteractionProfileAnalogThresholdVALVE.noffThreshold(this.address());
    }

    @NativeType(value="XrHapticBaseHeader const *")
    public @Nullable XrHapticBaseHeader onHaptic() {
        return XrInteractionProfileAnalogThresholdVALVE.nonHaptic(this.address());
    }

    @NativeType(value="XrHapticBaseHeader const *")
    public @Nullable XrHapticBaseHeader offHaptic() {
        return XrInteractionProfileAnalogThresholdVALVE.noffHaptic(this.address());
    }

    public XrInteractionProfileAnalogThresholdVALVE type(@NativeType(value="XrStructureType") int value) {
        XrInteractionProfileAnalogThresholdVALVE.ntype(this.address(), value);
        return this;
    }

    public XrInteractionProfileAnalogThresholdVALVE type$Default() {
        return this.type(1000079000);
    }

    public XrInteractionProfileAnalogThresholdVALVE next(@NativeType(value="void const *") long value) {
        XrInteractionProfileAnalogThresholdVALVE.nnext(this.address(), value);
        return this;
    }

    public XrInteractionProfileAnalogThresholdVALVE action(XrAction value) {
        XrInteractionProfileAnalogThresholdVALVE.naction(this.address(), value);
        return this;
    }

    public XrInteractionProfileAnalogThresholdVALVE binding(@NativeType(value="XrPath") long value) {
        XrInteractionProfileAnalogThresholdVALVE.nbinding(this.address(), value);
        return this;
    }

    public XrInteractionProfileAnalogThresholdVALVE onThreshold(float value) {
        XrInteractionProfileAnalogThresholdVALVE.nonThreshold(this.address(), value);
        return this;
    }

    public XrInteractionProfileAnalogThresholdVALVE offThreshold(float value) {
        XrInteractionProfileAnalogThresholdVALVE.noffThreshold(this.address(), value);
        return this;
    }

    public XrInteractionProfileAnalogThresholdVALVE onHaptic(@NativeType(value="XrHapticBaseHeader const *") @Nullable XrHapticBaseHeader value) {
        XrInteractionProfileAnalogThresholdVALVE.nonHaptic(this.address(), value);
        return this;
    }

    public XrInteractionProfileAnalogThresholdVALVE offHaptic(@NativeType(value="XrHapticBaseHeader const *") @Nullable XrHapticBaseHeader value) {
        XrInteractionProfileAnalogThresholdVALVE.noffHaptic(this.address(), value);
        return this;
    }

    public XrInteractionProfileAnalogThresholdVALVE set(int type, long next, XrAction action, long binding, float onThreshold, float offThreshold, @Nullable XrHapticBaseHeader onHaptic, @Nullable XrHapticBaseHeader offHaptic) {
        this.type(type);
        this.next(next);
        this.action(action);
        this.binding(binding);
        this.onThreshold(onThreshold);
        this.offThreshold(offThreshold);
        this.onHaptic(onHaptic);
        this.offHaptic(offHaptic);
        return this;
    }

    public XrInteractionProfileAnalogThresholdVALVE set(XrInteractionProfileAnalogThresholdVALVE src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrInteractionProfileAnalogThresholdVALVE malloc() {
        return new XrInteractionProfileAnalogThresholdVALVE(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrInteractionProfileAnalogThresholdVALVE calloc() {
        return new XrInteractionProfileAnalogThresholdVALVE(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrInteractionProfileAnalogThresholdVALVE create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrInteractionProfileAnalogThresholdVALVE(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrInteractionProfileAnalogThresholdVALVE create(long address) {
        return new XrInteractionProfileAnalogThresholdVALVE(address, null);
    }

    public static @Nullable XrInteractionProfileAnalogThresholdVALVE createSafe(long address) {
        return address == 0L ? null : new XrInteractionProfileAnalogThresholdVALVE(address, null);
    }

    public static XrInteractionProfileAnalogThresholdVALVE create(XrBindingModificationBaseHeaderKHR value) {
        return new XrInteractionProfileAnalogThresholdVALVE(value.address(), XrInteractionProfileAnalogThresholdVALVE.__getContainer((Struct)value));
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrInteractionProfileAnalogThresholdVALVE.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrInteractionProfileAnalogThresholdVALVE.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static Buffer create(XrBindingModificationBaseHeaderKHR.Buffer value) {
        return new Buffer(value.address(), XrInteractionProfileAnalogThresholdVALVE.__getContainer((StructBuffer)value), -1, 0, value.remaining(), value.remaining());
    }

    public static XrInteractionProfileAnalogThresholdVALVE malloc(MemoryStack stack) {
        return new XrInteractionProfileAnalogThresholdVALVE(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrInteractionProfileAnalogThresholdVALVE calloc(MemoryStack stack) {
        return new XrInteractionProfileAnalogThresholdVALVE(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long naction(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)ACTION));
    }

    public static long nbinding(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)BINDING));
    }

    public static float nonThreshold(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)ONTHRESHOLD));
    }

    public static float noffThreshold(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)OFFTHRESHOLD));
    }

    public static @Nullable XrHapticBaseHeader nonHaptic(long struct) {
        return XrHapticBaseHeader.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)ONHAPTIC)));
    }

    public static @Nullable XrHapticBaseHeader noffHaptic(long struct) {
        return XrHapticBaseHeader.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)OFFHAPTIC)));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void naction(long struct, XrAction value) {
        MemoryUtil.memPutAddress((long)(struct + (long)ACTION), (long)value.address());
    }

    public static void nbinding(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)BINDING), (long)value);
    }

    public static void nonThreshold(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)ONTHRESHOLD), (float)value);
    }

    public static void noffThreshold(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)OFFTHRESHOLD), (float)value);
    }

    public static void nonHaptic(long struct, @Nullable XrHapticBaseHeader value) {
        MemoryUtil.memPutAddress((long)(struct + (long)ONHAPTIC), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void noffHaptic(long struct, @Nullable XrHapticBaseHeader value) {
        MemoryUtil.memPutAddress((long)(struct + (long)OFFHAPTIC), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)ACTION)));
    }

    static {
        Struct.Layout layout = XrInteractionProfileAnalogThresholdVALVE.__struct((Struct.Member[])new Struct.Member[]{XrInteractionProfileAnalogThresholdVALVE.__member((int)4), XrInteractionProfileAnalogThresholdVALVE.__member((int)POINTER_SIZE), XrInteractionProfileAnalogThresholdVALVE.__member((int)POINTER_SIZE), XrInteractionProfileAnalogThresholdVALVE.__member((int)8), XrInteractionProfileAnalogThresholdVALVE.__member((int)4), XrInteractionProfileAnalogThresholdVALVE.__member((int)4), XrInteractionProfileAnalogThresholdVALVE.__member((int)POINTER_SIZE), XrInteractionProfileAnalogThresholdVALVE.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        ACTION = layout.offsetof(2);
        BINDING = layout.offsetof(3);
        ONTHRESHOLD = layout.offsetof(4);
        OFFTHRESHOLD = layout.offsetof(5);
        ONHAPTIC = layout.offsetof(6);
        OFFHAPTIC = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<XrInteractionProfileAnalogThresholdVALVE, Buffer>
    implements NativeResource {
        private static final XrInteractionProfileAnalogThresholdVALVE ELEMENT_FACTORY = XrInteractionProfileAnalogThresholdVALVE.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrInteractionProfileAnalogThresholdVALVE getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrInteractionProfileAnalogThresholdVALVE.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrInteractionProfileAnalogThresholdVALVE.nnext(this.address());
        }

        @NativeType(value="XrAction")
        public long action() {
            return XrInteractionProfileAnalogThresholdVALVE.naction(this.address());
        }

        @NativeType(value="XrPath")
        public long binding() {
            return XrInteractionProfileAnalogThresholdVALVE.nbinding(this.address());
        }

        public float onThreshold() {
            return XrInteractionProfileAnalogThresholdVALVE.nonThreshold(this.address());
        }

        public float offThreshold() {
            return XrInteractionProfileAnalogThresholdVALVE.noffThreshold(this.address());
        }

        @NativeType(value="XrHapticBaseHeader const *")
        public @Nullable XrHapticBaseHeader onHaptic() {
            return XrInteractionProfileAnalogThresholdVALVE.nonHaptic(this.address());
        }

        @NativeType(value="XrHapticBaseHeader const *")
        public @Nullable XrHapticBaseHeader offHaptic() {
            return XrInteractionProfileAnalogThresholdVALVE.noffHaptic(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrInteractionProfileAnalogThresholdVALVE.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000079000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrInteractionProfileAnalogThresholdVALVE.nnext(this.address(), value);
            return this;
        }

        public Buffer action(XrAction value) {
            XrInteractionProfileAnalogThresholdVALVE.naction(this.address(), value);
            return this;
        }

        public Buffer binding(@NativeType(value="XrPath") long value) {
            XrInteractionProfileAnalogThresholdVALVE.nbinding(this.address(), value);
            return this;
        }

        public Buffer onThreshold(float value) {
            XrInteractionProfileAnalogThresholdVALVE.nonThreshold(this.address(), value);
            return this;
        }

        public Buffer offThreshold(float value) {
            XrInteractionProfileAnalogThresholdVALVE.noffThreshold(this.address(), value);
            return this;
        }

        public Buffer onHaptic(@NativeType(value="XrHapticBaseHeader const *") @Nullable XrHapticBaseHeader value) {
            XrInteractionProfileAnalogThresholdVALVE.nonHaptic(this.address(), value);
            return this;
        }

        public Buffer offHaptic(@NativeType(value="XrHapticBaseHeader const *") @Nullable XrHapticBaseHeader value) {
            XrInteractionProfileAnalogThresholdVALVE.noffHaptic(this.address(), value);
            return this;
        }
    }
}

