/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrMarkerDetectorStateML
extends Struct<XrMarkerDetectorStateML>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int STATE;

    protected XrMarkerDetectorStateML(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrMarkerDetectorStateML create(long address, @Nullable ByteBuffer container) {
        return new XrMarkerDetectorStateML(address, container);
    }

    public XrMarkerDetectorStateML(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrMarkerDetectorStateML.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrMarkerDetectorStateML.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrMarkerDetectorStateML.nnext(this.address());
    }

    @NativeType(value="XrMarkerDetectorStatusML")
    public int state() {
        return XrMarkerDetectorStateML.nstate(this.address());
    }

    public XrMarkerDetectorStateML type(@NativeType(value="XrStructureType") int value) {
        XrMarkerDetectorStateML.ntype(this.address(), value);
        return this;
    }

    public XrMarkerDetectorStateML type$Default() {
        return this.type(1000138007);
    }

    public XrMarkerDetectorStateML next(@NativeType(value="void *") long value) {
        XrMarkerDetectorStateML.nnext(this.address(), value);
        return this;
    }

    public XrMarkerDetectorStateML set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrMarkerDetectorStateML set(XrMarkerDetectorStateML src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrMarkerDetectorStateML malloc() {
        return new XrMarkerDetectorStateML(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrMarkerDetectorStateML calloc() {
        return new XrMarkerDetectorStateML(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrMarkerDetectorStateML create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrMarkerDetectorStateML(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrMarkerDetectorStateML create(long address) {
        return new XrMarkerDetectorStateML(address, null);
    }

    public static @Nullable XrMarkerDetectorStateML createSafe(long address) {
        return address == 0L ? null : new XrMarkerDetectorStateML(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrMarkerDetectorStateML.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrMarkerDetectorStateML.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrMarkerDetectorStateML malloc(MemoryStack stack) {
        return new XrMarkerDetectorStateML(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrMarkerDetectorStateML calloc(MemoryStack stack) {
        return new XrMarkerDetectorStateML(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nstate(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STATE));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    static {
        Struct.Layout layout = XrMarkerDetectorStateML.__struct((Struct.Member[])new Struct.Member[]{XrMarkerDetectorStateML.__member((int)4), XrMarkerDetectorStateML.__member((int)POINTER_SIZE), XrMarkerDetectorStateML.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        STATE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrMarkerDetectorStateML, Buffer>
    implements NativeResource {
        private static final XrMarkerDetectorStateML ELEMENT_FACTORY = XrMarkerDetectorStateML.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrMarkerDetectorStateML getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrMarkerDetectorStateML.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrMarkerDetectorStateML.nnext(this.address());
        }

        @NativeType(value="XrMarkerDetectorStatusML")
        public int state() {
            return XrMarkerDetectorStateML.nstate(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrMarkerDetectorStateML.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000138007);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrMarkerDetectorStateML.nnext(this.address(), value);
            return this;
        }
    }
}

