/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrMarkerDetectorML;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrMarkerSpaceCreateInfoML
extends Struct<XrMarkerSpaceCreateInfoML>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int MARKERDETECTOR;
    public static final int MARKER;
    public static final int POSEINMARKERSPACE;

    protected XrMarkerSpaceCreateInfoML(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrMarkerSpaceCreateInfoML create(long address, @Nullable ByteBuffer container) {
        return new XrMarkerSpaceCreateInfoML(address, container);
    }

    public XrMarkerSpaceCreateInfoML(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrMarkerSpaceCreateInfoML.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrMarkerSpaceCreateInfoML.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrMarkerSpaceCreateInfoML.nnext(this.address());
    }

    @NativeType(value="XrMarkerDetectorML")
    public long markerDetector() {
        return XrMarkerSpaceCreateInfoML.nmarkerDetector(this.address());
    }

    @NativeType(value="XrMarkerML")
    public long marker() {
        return XrMarkerSpaceCreateInfoML.nmarker(this.address());
    }

    public XrPosef poseInMarkerSpace() {
        return XrMarkerSpaceCreateInfoML.nposeInMarkerSpace(this.address());
    }

    public XrMarkerSpaceCreateInfoML type(@NativeType(value="XrStructureType") int value) {
        XrMarkerSpaceCreateInfoML.ntype(this.address(), value);
        return this;
    }

    public XrMarkerSpaceCreateInfoML type$Default() {
        return this.type(1000138008);
    }

    public XrMarkerSpaceCreateInfoML next(@NativeType(value="void const *") long value) {
        XrMarkerSpaceCreateInfoML.nnext(this.address(), value);
        return this;
    }

    public XrMarkerSpaceCreateInfoML markerDetector(XrMarkerDetectorML value) {
        XrMarkerSpaceCreateInfoML.nmarkerDetector(this.address(), value);
        return this;
    }

    public XrMarkerSpaceCreateInfoML marker(@NativeType(value="XrMarkerML") long value) {
        XrMarkerSpaceCreateInfoML.nmarker(this.address(), value);
        return this;
    }

    public XrMarkerSpaceCreateInfoML poseInMarkerSpace(XrPosef value) {
        XrMarkerSpaceCreateInfoML.nposeInMarkerSpace(this.address(), value);
        return this;
    }

    public XrMarkerSpaceCreateInfoML poseInMarkerSpace(Consumer<XrPosef> consumer) {
        consumer.accept(this.poseInMarkerSpace());
        return this;
    }

    public XrMarkerSpaceCreateInfoML set(int type, long next, XrMarkerDetectorML markerDetector, long marker, XrPosef poseInMarkerSpace) {
        this.type(type);
        this.next(next);
        this.markerDetector(markerDetector);
        this.marker(marker);
        this.poseInMarkerSpace(poseInMarkerSpace);
        return this;
    }

    public XrMarkerSpaceCreateInfoML set(XrMarkerSpaceCreateInfoML src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrMarkerSpaceCreateInfoML malloc() {
        return new XrMarkerSpaceCreateInfoML(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrMarkerSpaceCreateInfoML calloc() {
        return new XrMarkerSpaceCreateInfoML(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrMarkerSpaceCreateInfoML create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrMarkerSpaceCreateInfoML(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrMarkerSpaceCreateInfoML create(long address) {
        return new XrMarkerSpaceCreateInfoML(address, null);
    }

    public static @Nullable XrMarkerSpaceCreateInfoML createSafe(long address) {
        return address == 0L ? null : new XrMarkerSpaceCreateInfoML(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrMarkerSpaceCreateInfoML.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrMarkerSpaceCreateInfoML.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrMarkerSpaceCreateInfoML malloc(MemoryStack stack) {
        return new XrMarkerSpaceCreateInfoML(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrMarkerSpaceCreateInfoML calloc(MemoryStack stack) {
        return new XrMarkerSpaceCreateInfoML(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long nmarkerDetector(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)MARKERDETECTOR));
    }

    public static long nmarker(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)MARKER));
    }

    public static XrPosef nposeInMarkerSpace(long struct) {
        return XrPosef.create(struct + (long)POSEINMARKERSPACE);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nmarkerDetector(long struct, XrMarkerDetectorML value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MARKERDETECTOR), (long)value.address());
    }

    public static void nmarker(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)MARKER), (long)value);
    }

    public static void nposeInMarkerSpace(long struct, XrPosef value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)POSEINMARKERSPACE), (long)XrPosef.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)MARKERDETECTOR)));
    }

    static {
        Struct.Layout layout = XrMarkerSpaceCreateInfoML.__struct((Struct.Member[])new Struct.Member[]{XrMarkerSpaceCreateInfoML.__member((int)4), XrMarkerSpaceCreateInfoML.__member((int)POINTER_SIZE), XrMarkerSpaceCreateInfoML.__member((int)POINTER_SIZE), XrMarkerSpaceCreateInfoML.__member((int)8), XrMarkerSpaceCreateInfoML.__member((int)XrPosef.SIZEOF, (int)XrPosef.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        MARKERDETECTOR = layout.offsetof(2);
        MARKER = layout.offsetof(3);
        POSEINMARKERSPACE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrMarkerSpaceCreateInfoML, Buffer>
    implements NativeResource {
        private static final XrMarkerSpaceCreateInfoML ELEMENT_FACTORY = XrMarkerSpaceCreateInfoML.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrMarkerSpaceCreateInfoML getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrMarkerSpaceCreateInfoML.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrMarkerSpaceCreateInfoML.nnext(this.address());
        }

        @NativeType(value="XrMarkerDetectorML")
        public long markerDetector() {
            return XrMarkerSpaceCreateInfoML.nmarkerDetector(this.address());
        }

        @NativeType(value="XrMarkerML")
        public long marker() {
            return XrMarkerSpaceCreateInfoML.nmarker(this.address());
        }

        public XrPosef poseInMarkerSpace() {
            return XrMarkerSpaceCreateInfoML.nposeInMarkerSpace(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrMarkerSpaceCreateInfoML.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000138008);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrMarkerSpaceCreateInfoML.nnext(this.address(), value);
            return this;
        }

        public Buffer markerDetector(XrMarkerDetectorML value) {
            XrMarkerSpaceCreateInfoML.nmarkerDetector(this.address(), value);
            return this;
        }

        public Buffer marker(@NativeType(value="XrMarkerML") long value) {
            XrMarkerSpaceCreateInfoML.nmarker(this.address(), value);
            return this;
        }

        public Buffer poseInMarkerSpace(XrPosef value) {
            XrMarkerSpaceCreateInfoML.nposeInMarkerSpace(this.address(), value);
            return this;
        }

        public Buffer poseInMarkerSpace(Consumer<XrPosef> consumer) {
            consumer.accept(this.poseInMarkerSpace());
            return this;
        }
    }
}

