/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSceneBoundsMSFT;
import org.lwjgl.openxr.XrVisualMeshComputeLodInfoMSFT;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrNewSceneComputeInfoMSFT
extends Struct<XrNewSceneComputeInfoMSFT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int REQUESTEDFEATURECOUNT;
    public static final int REQUESTEDFEATURES;
    public static final int CONSISTENCY;
    public static final int BOUNDS;

    protected XrNewSceneComputeInfoMSFT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrNewSceneComputeInfoMSFT create(long address, @Nullable ByteBuffer container) {
        return new XrNewSceneComputeInfoMSFT(address, container);
    }

    public XrNewSceneComputeInfoMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrNewSceneComputeInfoMSFT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrNewSceneComputeInfoMSFT.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrNewSceneComputeInfoMSFT.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int requestedFeatureCount() {
        return XrNewSceneComputeInfoMSFT.nrequestedFeatureCount(this.address());
    }

    @NativeType(value="XrSceneComputeFeatureMSFT const *")
    public IntBuffer requestedFeatures() {
        return XrNewSceneComputeInfoMSFT.nrequestedFeatures(this.address());
    }

    @NativeType(value="XrSceneComputeConsistencyMSFT")
    public int consistency() {
        return XrNewSceneComputeInfoMSFT.nconsistency(this.address());
    }

    public XrSceneBoundsMSFT bounds() {
        return XrNewSceneComputeInfoMSFT.nbounds(this.address());
    }

    public XrNewSceneComputeInfoMSFT type(@NativeType(value="XrStructureType") int value) {
        XrNewSceneComputeInfoMSFT.ntype(this.address(), value);
        return this;
    }

    public XrNewSceneComputeInfoMSFT type$Default() {
        return this.type(1000097002);
    }

    public XrNewSceneComputeInfoMSFT next(@NativeType(value="void const *") long value) {
        XrNewSceneComputeInfoMSFT.nnext(this.address(), value);
        return this;
    }

    public XrNewSceneComputeInfoMSFT next(XrVisualMeshComputeLodInfoMSFT value) {
        return this.next(value.next(this.next()).address());
    }

    public XrNewSceneComputeInfoMSFT requestedFeatures(@NativeType(value="XrSceneComputeFeatureMSFT const *") IntBuffer value) {
        XrNewSceneComputeInfoMSFT.nrequestedFeatures(this.address(), value);
        return this;
    }

    public XrNewSceneComputeInfoMSFT consistency(@NativeType(value="XrSceneComputeConsistencyMSFT") int value) {
        XrNewSceneComputeInfoMSFT.nconsistency(this.address(), value);
        return this;
    }

    public XrNewSceneComputeInfoMSFT bounds(XrSceneBoundsMSFT value) {
        XrNewSceneComputeInfoMSFT.nbounds(this.address(), value);
        return this;
    }

    public XrNewSceneComputeInfoMSFT bounds(Consumer<XrSceneBoundsMSFT> consumer) {
        consumer.accept(this.bounds());
        return this;
    }

    public XrNewSceneComputeInfoMSFT set(int type, long next, IntBuffer requestedFeatures, int consistency, XrSceneBoundsMSFT bounds) {
        this.type(type);
        this.next(next);
        this.requestedFeatures(requestedFeatures);
        this.consistency(consistency);
        this.bounds(bounds);
        return this;
    }

    public XrNewSceneComputeInfoMSFT set(XrNewSceneComputeInfoMSFT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrNewSceneComputeInfoMSFT malloc() {
        return new XrNewSceneComputeInfoMSFT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrNewSceneComputeInfoMSFT calloc() {
        return new XrNewSceneComputeInfoMSFT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrNewSceneComputeInfoMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrNewSceneComputeInfoMSFT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrNewSceneComputeInfoMSFT create(long address) {
        return new XrNewSceneComputeInfoMSFT(address, null);
    }

    public static @Nullable XrNewSceneComputeInfoMSFT createSafe(long address) {
        return address == 0L ? null : new XrNewSceneComputeInfoMSFT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrNewSceneComputeInfoMSFT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrNewSceneComputeInfoMSFT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrNewSceneComputeInfoMSFT malloc(MemoryStack stack) {
        return new XrNewSceneComputeInfoMSFT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrNewSceneComputeInfoMSFT calloc(MemoryStack stack) {
        return new XrNewSceneComputeInfoMSFT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nrequestedFeatureCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)REQUESTEDFEATURECOUNT));
    }

    public static IntBuffer nrequestedFeatures(long struct) {
        return MemoryUtil.memIntBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)REQUESTEDFEATURES)), (int)XrNewSceneComputeInfoMSFT.nrequestedFeatureCount(struct));
    }

    public static int nconsistency(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)CONSISTENCY));
    }

    public static XrSceneBoundsMSFT nbounds(long struct) {
        return XrSceneBoundsMSFT.create(struct + (long)BOUNDS);
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nrequestedFeatureCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)REQUESTEDFEATURECOUNT), (int)value);
    }

    public static void nrequestedFeatures(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)REQUESTEDFEATURES), (long)MemoryUtil.memAddress((IntBuffer)value));
        XrNewSceneComputeInfoMSFT.nrequestedFeatureCount(struct, value.remaining());
    }

    public static void nconsistency(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)CONSISTENCY), (int)value);
    }

    public static void nbounds(long struct, XrSceneBoundsMSFT value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)BOUNDS), (long)XrSceneBoundsMSFT.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)REQUESTEDFEATURES)));
        XrSceneBoundsMSFT.validate(struct + (long)BOUNDS);
    }

    static {
        Struct.Layout layout = XrNewSceneComputeInfoMSFT.__struct((Struct.Member[])new Struct.Member[]{XrNewSceneComputeInfoMSFT.__member((int)4), XrNewSceneComputeInfoMSFT.__member((int)POINTER_SIZE), XrNewSceneComputeInfoMSFT.__member((int)4), XrNewSceneComputeInfoMSFT.__member((int)POINTER_SIZE), XrNewSceneComputeInfoMSFT.__member((int)4), XrNewSceneComputeInfoMSFT.__member((int)XrSceneBoundsMSFT.SIZEOF, (int)XrSceneBoundsMSFT.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        REQUESTEDFEATURECOUNT = layout.offsetof(2);
        REQUESTEDFEATURES = layout.offsetof(3);
        CONSISTENCY = layout.offsetof(4);
        BOUNDS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<XrNewSceneComputeInfoMSFT, Buffer>
    implements NativeResource {
        private static final XrNewSceneComputeInfoMSFT ELEMENT_FACTORY = XrNewSceneComputeInfoMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrNewSceneComputeInfoMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrNewSceneComputeInfoMSFT.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrNewSceneComputeInfoMSFT.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int requestedFeatureCount() {
            return XrNewSceneComputeInfoMSFT.nrequestedFeatureCount(this.address());
        }

        @NativeType(value="XrSceneComputeFeatureMSFT const *")
        public IntBuffer requestedFeatures() {
            return XrNewSceneComputeInfoMSFT.nrequestedFeatures(this.address());
        }

        @NativeType(value="XrSceneComputeConsistencyMSFT")
        public int consistency() {
            return XrNewSceneComputeInfoMSFT.nconsistency(this.address());
        }

        public XrSceneBoundsMSFT bounds() {
            return XrNewSceneComputeInfoMSFT.nbounds(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrNewSceneComputeInfoMSFT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000097002);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrNewSceneComputeInfoMSFT.nnext(this.address(), value);
            return this;
        }

        public Buffer next(XrVisualMeshComputeLodInfoMSFT value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer requestedFeatures(@NativeType(value="XrSceneComputeFeatureMSFT const *") IntBuffer value) {
            XrNewSceneComputeInfoMSFT.nrequestedFeatures(this.address(), value);
            return this;
        }

        public Buffer consistency(@NativeType(value="XrSceneComputeConsistencyMSFT") int value) {
            XrNewSceneComputeInfoMSFT.nconsistency(this.address(), value);
            return this;
        }

        public Buffer bounds(XrSceneBoundsMSFT value) {
            XrNewSceneComputeInfoMSFT.nbounds(this.address(), value);
            return this;
        }

        public Buffer bounds(Consumer<XrSceneBoundsMSFT> consumer) {
            consumer.accept(this.bounds());
            return this;
        }
    }
}

