/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrPassthroughColorLutMETA;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrPassthroughColorMapLutMETA
extends Struct<XrPassthroughColorMapLutMETA>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int COLORLUT;
    public static final int WEIGHT;

    protected XrPassthroughColorMapLutMETA(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrPassthroughColorMapLutMETA create(long address, @Nullable ByteBuffer container) {
        return new XrPassthroughColorMapLutMETA(address, container);
    }

    public XrPassthroughColorMapLutMETA(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrPassthroughColorMapLutMETA.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrPassthroughColorMapLutMETA.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrPassthroughColorMapLutMETA.nnext(this.address());
    }

    @NativeType(value="XrPassthroughColorLutMETA")
    public long colorLut() {
        return XrPassthroughColorMapLutMETA.ncolorLut(this.address());
    }

    public float weight() {
        return XrPassthroughColorMapLutMETA.nweight(this.address());
    }

    public XrPassthroughColorMapLutMETA type(@NativeType(value="XrStructureType") int value) {
        XrPassthroughColorMapLutMETA.ntype(this.address(), value);
        return this;
    }

    public XrPassthroughColorMapLutMETA type$Default() {
        return this.type(1000266100);
    }

    public XrPassthroughColorMapLutMETA next(@NativeType(value="void const *") long value) {
        XrPassthroughColorMapLutMETA.nnext(this.address(), value);
        return this;
    }

    public XrPassthroughColorMapLutMETA colorLut(XrPassthroughColorLutMETA value) {
        XrPassthroughColorMapLutMETA.ncolorLut(this.address(), value);
        return this;
    }

    public XrPassthroughColorMapLutMETA weight(float value) {
        XrPassthroughColorMapLutMETA.nweight(this.address(), value);
        return this;
    }

    public XrPassthroughColorMapLutMETA set(int type, long next, XrPassthroughColorLutMETA colorLut, float weight) {
        this.type(type);
        this.next(next);
        this.colorLut(colorLut);
        this.weight(weight);
        return this;
    }

    public XrPassthroughColorMapLutMETA set(XrPassthroughColorMapLutMETA src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrPassthroughColorMapLutMETA malloc() {
        return new XrPassthroughColorMapLutMETA(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrPassthroughColorMapLutMETA calloc() {
        return new XrPassthroughColorMapLutMETA(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrPassthroughColorMapLutMETA create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrPassthroughColorMapLutMETA(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrPassthroughColorMapLutMETA create(long address) {
        return new XrPassthroughColorMapLutMETA(address, null);
    }

    public static @Nullable XrPassthroughColorMapLutMETA createSafe(long address) {
        return address == 0L ? null : new XrPassthroughColorMapLutMETA(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrPassthroughColorMapLutMETA.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrPassthroughColorMapLutMETA.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrPassthroughColorMapLutMETA malloc(MemoryStack stack) {
        return new XrPassthroughColorMapLutMETA(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrPassthroughColorMapLutMETA calloc(MemoryStack stack) {
        return new XrPassthroughColorMapLutMETA(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long ncolorLut(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)COLORLUT));
    }

    public static float nweight(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)WEIGHT));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void ncolorLut(long struct, XrPassthroughColorLutMETA value) {
        MemoryUtil.memPutAddress((long)(struct + (long)COLORLUT), (long)value.address());
    }

    public static void nweight(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)WEIGHT), (float)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)COLORLUT)));
    }

    static {
        Struct.Layout layout = XrPassthroughColorMapLutMETA.__struct((Struct.Member[])new Struct.Member[]{XrPassthroughColorMapLutMETA.__member((int)4), XrPassthroughColorMapLutMETA.__member((int)POINTER_SIZE), XrPassthroughColorMapLutMETA.__member((int)POINTER_SIZE), XrPassthroughColorMapLutMETA.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        COLORLUT = layout.offsetof(2);
        WEIGHT = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrPassthroughColorMapLutMETA, Buffer>
    implements NativeResource {
        private static final XrPassthroughColorMapLutMETA ELEMENT_FACTORY = XrPassthroughColorMapLutMETA.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrPassthroughColorMapLutMETA getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrPassthroughColorMapLutMETA.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrPassthroughColorMapLutMETA.nnext(this.address());
        }

        @NativeType(value="XrPassthroughColorLutMETA")
        public long colorLut() {
            return XrPassthroughColorMapLutMETA.ncolorLut(this.address());
        }

        public float weight() {
            return XrPassthroughColorMapLutMETA.nweight(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrPassthroughColorMapLutMETA.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000266100);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrPassthroughColorMapLutMETA.nnext(this.address(), value);
            return this;
        }

        public Buffer colorLut(XrPassthroughColorLutMETA value) {
            XrPassthroughColorMapLutMETA.ncolorLut(this.address(), value);
            return this;
        }

        public Buffer weight(float value) {
            XrPassthroughColorMapLutMETA.nweight(this.address(), value);
            return this;
        }
    }
}

