/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrRenderModelBufferFB
extends Struct<XrRenderModelBufferFB>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int BUFFERCAPACITYINPUT;
    public static final int BUFFERCOUNTOUTPUT;
    public static final int BUFFER;

    protected XrRenderModelBufferFB(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrRenderModelBufferFB create(long address, @Nullable ByteBuffer container) {
        return new XrRenderModelBufferFB(address, container);
    }

    public XrRenderModelBufferFB(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrRenderModelBufferFB.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrRenderModelBufferFB.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrRenderModelBufferFB.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int bufferCapacityInput() {
        return XrRenderModelBufferFB.nbufferCapacityInput(this.address());
    }

    @NativeType(value="uint32_t")
    public int bufferCountOutput() {
        return XrRenderModelBufferFB.nbufferCountOutput(this.address());
    }

    @NativeType(value="uint8_t *")
    public @Nullable ByteBuffer buffer() {
        return XrRenderModelBufferFB.nbuffer(this.address());
    }

    public XrRenderModelBufferFB type(@NativeType(value="XrStructureType") int value) {
        XrRenderModelBufferFB.ntype(this.address(), value);
        return this;
    }

    public XrRenderModelBufferFB type$Default() {
        return this.type(1000119002);
    }

    public XrRenderModelBufferFB next(@NativeType(value="void *") long value) {
        XrRenderModelBufferFB.nnext(this.address(), value);
        return this;
    }

    public XrRenderModelBufferFB bufferCapacityInput(@NativeType(value="uint32_t") int value) {
        XrRenderModelBufferFB.nbufferCapacityInput(this.address(), value);
        return this;
    }

    public XrRenderModelBufferFB bufferCountOutput(@NativeType(value="uint32_t") int value) {
        XrRenderModelBufferFB.nbufferCountOutput(this.address(), value);
        return this;
    }

    public XrRenderModelBufferFB buffer(@NativeType(value="uint8_t *") @Nullable ByteBuffer value) {
        XrRenderModelBufferFB.nbuffer(this.address(), value);
        return this;
    }

    public XrRenderModelBufferFB set(int type, long next, int bufferCapacityInput, int bufferCountOutput, @Nullable ByteBuffer buffer) {
        this.type(type);
        this.next(next);
        this.bufferCapacityInput(bufferCapacityInput);
        this.bufferCountOutput(bufferCountOutput);
        this.buffer(buffer);
        return this;
    }

    public XrRenderModelBufferFB set(XrRenderModelBufferFB src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrRenderModelBufferFB malloc() {
        return new XrRenderModelBufferFB(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrRenderModelBufferFB calloc() {
        return new XrRenderModelBufferFB(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrRenderModelBufferFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrRenderModelBufferFB(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrRenderModelBufferFB create(long address) {
        return new XrRenderModelBufferFB(address, null);
    }

    public static @Nullable XrRenderModelBufferFB createSafe(long address) {
        return address == 0L ? null : new XrRenderModelBufferFB(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrRenderModelBufferFB.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrRenderModelBufferFB.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrRenderModelBufferFB malloc(MemoryStack stack) {
        return new XrRenderModelBufferFB(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrRenderModelBufferFB calloc(MemoryStack stack) {
        return new XrRenderModelBufferFB(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nbufferCapacityInput(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)BUFFERCAPACITYINPUT));
    }

    public static int nbufferCountOutput(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)BUFFERCOUNTOUTPUT));
    }

    public static @Nullable ByteBuffer nbuffer(long struct) {
        return MemoryUtil.memByteBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)BUFFER)), (int)XrRenderModelBufferFB.nbufferCapacityInput(struct));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nbufferCapacityInput(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)BUFFERCAPACITYINPUT), (int)value);
    }

    public static void nbufferCountOutput(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)BUFFERCOUNTOUTPUT), (int)value);
    }

    public static void nbuffer(long struct, @Nullable ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)BUFFER), (long)MemoryUtil.memAddressSafe((ByteBuffer)value));
        if (value != null) {
            XrRenderModelBufferFB.nbufferCapacityInput(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = XrRenderModelBufferFB.__struct((Struct.Member[])new Struct.Member[]{XrRenderModelBufferFB.__member((int)4), XrRenderModelBufferFB.__member((int)POINTER_SIZE), XrRenderModelBufferFB.__member((int)4), XrRenderModelBufferFB.__member((int)4), XrRenderModelBufferFB.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        BUFFERCAPACITYINPUT = layout.offsetof(2);
        BUFFERCOUNTOUTPUT = layout.offsetof(3);
        BUFFER = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrRenderModelBufferFB, Buffer>
    implements NativeResource {
        private static final XrRenderModelBufferFB ELEMENT_FACTORY = XrRenderModelBufferFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrRenderModelBufferFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrRenderModelBufferFB.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrRenderModelBufferFB.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int bufferCapacityInput() {
            return XrRenderModelBufferFB.nbufferCapacityInput(this.address());
        }

        @NativeType(value="uint32_t")
        public int bufferCountOutput() {
            return XrRenderModelBufferFB.nbufferCountOutput(this.address());
        }

        @NativeType(value="uint8_t *")
        public @Nullable ByteBuffer buffer() {
            return XrRenderModelBufferFB.nbuffer(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrRenderModelBufferFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000119002);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrRenderModelBufferFB.nnext(this.address(), value);
            return this;
        }

        public Buffer bufferCapacityInput(@NativeType(value="uint32_t") int value) {
            XrRenderModelBufferFB.nbufferCapacityInput(this.address(), value);
            return this;
        }

        public Buffer bufferCountOutput(@NativeType(value="uint32_t") int value) {
            XrRenderModelBufferFB.nbufferCountOutput(this.address(), value);
            return this;
        }

        public Buffer buffer(@NativeType(value="uint8_t *") @Nullable ByteBuffer value) {
            XrRenderModelBufferFB.nbuffer(this.address(), value);
            return this;
        }
    }
}

