/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openxr.XrShareSpacesRecipientBaseHeaderMETA;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrShareSpacesInfoMETA
extends Struct<XrShareSpacesInfoMETA>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SPACECOUNT;
    public static final int SPACES;
    public static final int RECIPIENTINFO;

    protected XrShareSpacesInfoMETA(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrShareSpacesInfoMETA create(long address, @Nullable ByteBuffer container) {
        return new XrShareSpacesInfoMETA(address, container);
    }

    public XrShareSpacesInfoMETA(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrShareSpacesInfoMETA.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrShareSpacesInfoMETA.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrShareSpacesInfoMETA.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int spaceCount() {
        return XrShareSpacesInfoMETA.nspaceCount(this.address());
    }

    @NativeType(value="XrSpace *")
    public PointerBuffer spaces() {
        return XrShareSpacesInfoMETA.nspaces(this.address());
    }

    @NativeType(value="XrShareSpacesRecipientBaseHeaderMETA const *")
    public XrShareSpacesRecipientBaseHeaderMETA recipientInfo() {
        return XrShareSpacesInfoMETA.nrecipientInfo(this.address());
    }

    public XrShareSpacesInfoMETA type(@NativeType(value="XrStructureType") int value) {
        XrShareSpacesInfoMETA.ntype(this.address(), value);
        return this;
    }

    public XrShareSpacesInfoMETA type$Default() {
        return this.type(1000290001);
    }

    public XrShareSpacesInfoMETA next(@NativeType(value="void const *") long value) {
        XrShareSpacesInfoMETA.nnext(this.address(), value);
        return this;
    }

    public XrShareSpacesInfoMETA spaces(@NativeType(value="XrSpace *") PointerBuffer value) {
        XrShareSpacesInfoMETA.nspaces(this.address(), value);
        return this;
    }

    public XrShareSpacesInfoMETA recipientInfo(@NativeType(value="XrShareSpacesRecipientBaseHeaderMETA const *") XrShareSpacesRecipientBaseHeaderMETA value) {
        XrShareSpacesInfoMETA.nrecipientInfo(this.address(), value);
        return this;
    }

    public XrShareSpacesInfoMETA set(int type, long next, PointerBuffer spaces, XrShareSpacesRecipientBaseHeaderMETA recipientInfo) {
        this.type(type);
        this.next(next);
        this.spaces(spaces);
        this.recipientInfo(recipientInfo);
        return this;
    }

    public XrShareSpacesInfoMETA set(XrShareSpacesInfoMETA src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrShareSpacesInfoMETA malloc() {
        return new XrShareSpacesInfoMETA(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrShareSpacesInfoMETA calloc() {
        return new XrShareSpacesInfoMETA(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrShareSpacesInfoMETA create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrShareSpacesInfoMETA(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrShareSpacesInfoMETA create(long address) {
        return new XrShareSpacesInfoMETA(address, null);
    }

    public static @Nullable XrShareSpacesInfoMETA createSafe(long address) {
        return address == 0L ? null : new XrShareSpacesInfoMETA(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrShareSpacesInfoMETA.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrShareSpacesInfoMETA.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrShareSpacesInfoMETA malloc(MemoryStack stack) {
        return new XrShareSpacesInfoMETA(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrShareSpacesInfoMETA calloc(MemoryStack stack) {
        return new XrShareSpacesInfoMETA(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nspaceCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SPACECOUNT));
    }

    public static PointerBuffer nspaces(long struct) {
        return MemoryUtil.memPointerBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)SPACES)), (int)XrShareSpacesInfoMETA.nspaceCount(struct));
    }

    public static XrShareSpacesRecipientBaseHeaderMETA nrecipientInfo(long struct) {
        return XrShareSpacesRecipientBaseHeaderMETA.create(MemoryUtil.memGetAddress((long)(struct + (long)RECIPIENTINFO)));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nspaceCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SPACECOUNT), (int)value);
    }

    public static void nspaces(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SPACES), (long)MemoryUtil.memAddress((CustomBuffer)value));
        XrShareSpacesInfoMETA.nspaceCount(struct, value.remaining());
    }

    public static void nrecipientInfo(long struct, XrShareSpacesRecipientBaseHeaderMETA value) {
        MemoryUtil.memPutAddress((long)(struct + (long)RECIPIENTINFO), (long)value.address());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)SPACES)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)RECIPIENTINFO)));
    }

    static {
        Struct.Layout layout = XrShareSpacesInfoMETA.__struct((Struct.Member[])new Struct.Member[]{XrShareSpacesInfoMETA.__member((int)4), XrShareSpacesInfoMETA.__member((int)POINTER_SIZE), XrShareSpacesInfoMETA.__member((int)4), XrShareSpacesInfoMETA.__member((int)POINTER_SIZE), XrShareSpacesInfoMETA.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SPACECOUNT = layout.offsetof(2);
        SPACES = layout.offsetof(3);
        RECIPIENTINFO = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrShareSpacesInfoMETA, Buffer>
    implements NativeResource {
        private static final XrShareSpacesInfoMETA ELEMENT_FACTORY = XrShareSpacesInfoMETA.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrShareSpacesInfoMETA getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrShareSpacesInfoMETA.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrShareSpacesInfoMETA.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int spaceCount() {
            return XrShareSpacesInfoMETA.nspaceCount(this.address());
        }

        @NativeType(value="XrSpace *")
        public PointerBuffer spaces() {
            return XrShareSpacesInfoMETA.nspaces(this.address());
        }

        @NativeType(value="XrShareSpacesRecipientBaseHeaderMETA const *")
        public XrShareSpacesRecipientBaseHeaderMETA recipientInfo() {
            return XrShareSpacesInfoMETA.nrecipientInfo(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrShareSpacesInfoMETA.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000290001);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrShareSpacesInfoMETA.nnext(this.address(), value);
            return this;
        }

        public Buffer spaces(@NativeType(value="XrSpace *") PointerBuffer value) {
            XrShareSpacesInfoMETA.nspaces(this.address(), value);
            return this;
        }

        public Buffer recipientInfo(@NativeType(value="XrShareSpacesRecipientBaseHeaderMETA const *") XrShareSpacesRecipientBaseHeaderMETA value) {
            XrShareSpacesInfoMETA.nrecipientInfo(this.address(), value);
            return this;
        }
    }
}

