/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSystemGetInfo
extends Struct<XrSystemGetInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int FORMFACTOR;

    protected XrSystemGetInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrSystemGetInfo create(long address, @Nullable ByteBuffer container) {
        return new XrSystemGetInfo(address, container);
    }

    public XrSystemGetInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSystemGetInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSystemGetInfo.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSystemGetInfo.nnext(this.address());
    }

    @NativeType(value="XrFormFactor")
    public int formFactor() {
        return XrSystemGetInfo.nformFactor(this.address());
    }

    public XrSystemGetInfo type(@NativeType(value="XrStructureType") int value) {
        XrSystemGetInfo.ntype(this.address(), value);
        return this;
    }

    public XrSystemGetInfo type$Default() {
        return this.type(4);
    }

    public XrSystemGetInfo next(@NativeType(value="void const *") long value) {
        XrSystemGetInfo.nnext(this.address(), value);
        return this;
    }

    public XrSystemGetInfo formFactor(@NativeType(value="XrFormFactor") int value) {
        XrSystemGetInfo.nformFactor(this.address(), value);
        return this;
    }

    public XrSystemGetInfo set(int type, long next, int formFactor) {
        this.type(type);
        this.next(next);
        this.formFactor(formFactor);
        return this;
    }

    public XrSystemGetInfo set(XrSystemGetInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSystemGetInfo malloc() {
        return new XrSystemGetInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrSystemGetInfo calloc() {
        return new XrSystemGetInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrSystemGetInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrSystemGetInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrSystemGetInfo create(long address) {
        return new XrSystemGetInfo(address, null);
    }

    public static @Nullable XrSystemGetInfo createSafe(long address) {
        return address == 0L ? null : new XrSystemGetInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrSystemGetInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSystemGetInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrSystemGetInfo malloc(MemoryStack stack) {
        return new XrSystemGetInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrSystemGetInfo calloc(MemoryStack stack) {
        return new XrSystemGetInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static int nformFactor(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FORMFACTOR));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nformFactor(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FORMFACTOR), (int)value);
    }

    static {
        Struct.Layout layout = XrSystemGetInfo.__struct((Struct.Member[])new Struct.Member[]{XrSystemGetInfo.__member((int)4), XrSystemGetInfo.__member((int)POINTER_SIZE), XrSystemGetInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        FORMFACTOR = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrSystemGetInfo, Buffer>
    implements NativeResource {
        private static final XrSystemGetInfo ELEMENT_FACTORY = XrSystemGetInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrSystemGetInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSystemGetInfo.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSystemGetInfo.nnext(this.address());
        }

        @NativeType(value="XrFormFactor")
        public int formFactor() {
            return XrSystemGetInfo.nformFactor(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSystemGetInfo.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(4);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSystemGetInfo.nnext(this.address(), value);
            return this;
        }

        public Buffer formFactor(@NativeType(value="XrFormFactor") int value) {
            XrSystemGetInfo.nformFactor(this.address(), value);
            return this;
        }
    }
}

