/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrVector3f
extends Struct<XrVector3f>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int Z;

    protected XrVector3f(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrVector3f create(long address, @Nullable ByteBuffer container) {
        return new XrVector3f(address, container);
    }

    public XrVector3f(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrVector3f.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return XrVector3f.nx(this.address());
    }

    public float y() {
        return XrVector3f.ny(this.address());
    }

    public float z() {
        return XrVector3f.nz(this.address());
    }

    public XrVector3f x(float value) {
        XrVector3f.nx(this.address(), value);
        return this;
    }

    public XrVector3f y(float value) {
        XrVector3f.ny(this.address(), value);
        return this;
    }

    public XrVector3f z(float value) {
        XrVector3f.nz(this.address(), value);
        return this;
    }

    public XrVector3f set(float x, float y, float z) {
        this.x(x);
        this.y(y);
        this.z(z);
        return this;
    }

    public XrVector3f set(XrVector3f src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrVector3f malloc() {
        return new XrVector3f(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrVector3f calloc() {
        return new XrVector3f(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrVector3f create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrVector3f(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrVector3f create(long address) {
        return new XrVector3f(address, null);
    }

    public static @Nullable XrVector3f createSafe(long address) {
        return address == 0L ? null : new XrVector3f(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrVector3f.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrVector3f.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrVector3f malloc(MemoryStack stack) {
        return new XrVector3f(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrVector3f calloc(MemoryStack stack) {
        return new XrVector3f(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nx(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)X));
    }

    public static float ny(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)Y));
    }

    public static float nz(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)Z));
    }

    public static void nx(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)X), (float)value);
    }

    public static void ny(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)Y), (float)value);
    }

    public static void nz(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)Z), (float)value);
    }

    static {
        Struct.Layout layout = XrVector3f.__struct((Struct.Member[])new Struct.Member[]{XrVector3f.__member((int)4), XrVector3f.__member((int)4), XrVector3f.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        Z = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrVector3f, Buffer>
    implements NativeResource {
        private static final XrVector3f ELEMENT_FACTORY = XrVector3f.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrVector3f getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float x() {
            return XrVector3f.nx(this.address());
        }

        public float y() {
            return XrVector3f.ny(this.address());
        }

        public float z() {
            return XrVector3f.nz(this.address());
        }

        public Buffer x(float value) {
            XrVector3f.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            XrVector3f.ny(this.address(), value);
            return this;
        }

        public Buffer z(float value) {
            XrVector3f.nz(this.address(), value);
            return this;
        }
    }
}

