/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrViewState
extends Struct<XrViewState>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int VIEWSTATEFLAGS;

    protected XrViewState(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrViewState create(long address, @Nullable ByteBuffer container) {
        return new XrViewState(address, container);
    }

    public XrViewState(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrViewState.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrViewState.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrViewState.nnext(this.address());
    }

    @NativeType(value="XrViewStateFlags")
    public long viewStateFlags() {
        return XrViewState.nviewStateFlags(this.address());
    }

    public XrViewState type(@NativeType(value="XrStructureType") int value) {
        XrViewState.ntype(this.address(), value);
        return this;
    }

    public XrViewState type$Default() {
        return this.type(11);
    }

    public XrViewState next(@NativeType(value="void *") long value) {
        XrViewState.nnext(this.address(), value);
        return this;
    }

    public XrViewState viewStateFlags(@NativeType(value="XrViewStateFlags") long value) {
        XrViewState.nviewStateFlags(this.address(), value);
        return this;
    }

    public XrViewState set(int type, long next, long viewStateFlags) {
        this.type(type);
        this.next(next);
        this.viewStateFlags(viewStateFlags);
        return this;
    }

    public XrViewState set(XrViewState src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrViewState malloc() {
        return new XrViewState(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrViewState calloc() {
        return new XrViewState(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrViewState create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrViewState(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrViewState create(long address) {
        return new XrViewState(address, null);
    }

    public static @Nullable XrViewState createSafe(long address) {
        return address == 0L ? null : new XrViewState(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrViewState.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrViewState.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrViewState malloc(MemoryStack stack) {
        return new XrViewState(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrViewState calloc(MemoryStack stack) {
        return new XrViewState(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long nviewStateFlags(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)VIEWSTATEFLAGS));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nviewStateFlags(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)VIEWSTATEFLAGS), (long)value);
    }

    static {
        Struct.Layout layout = XrViewState.__struct((Struct.Member[])new Struct.Member[]{XrViewState.__member((int)4), XrViewState.__member((int)POINTER_SIZE), XrViewState.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        VIEWSTATEFLAGS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrViewState, Buffer>
    implements NativeResource {
        private static final XrViewState ELEMENT_FACTORY = XrViewState.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrViewState getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrViewState.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrViewState.nnext(this.address());
        }

        @NativeType(value="XrViewStateFlags")
        public long viewStateFlags() {
            return XrViewState.nviewStateFlags(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrViewState.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(11);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrViewState.nnext(this.address(), value);
            return this;
        }

        public Buffer viewStateFlags(@NativeType(value="XrViewStateFlags") long value) {
            XrViewState.nviewStateFlags(this.address(), value);
            return this;
        }
    }
}

