/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrUuidEXT;
import org.lwjgl.openxr.XrVector3f;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrWorldMeshBlockML
extends Struct<XrWorldMeshBlockML>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int UUID;
    public static final int BLOCKRESULT;
    public static final int LOD;
    public static final int FLAGS;
    public static final int INDEXCOUNT;
    public static final int INDEXBUFFER;
    public static final int VERTEXCOUNT;
    public static final int VERTEXBUFFER;
    public static final int NORMALCOUNT;
    public static final int NORMALBUFFER;
    public static final int CONFIDENCECOUNT;
    public static final int CONFIDENCEBUFFER;

    protected XrWorldMeshBlockML(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrWorldMeshBlockML create(long address, @Nullable ByteBuffer container) {
        return new XrWorldMeshBlockML(address, container);
    }

    public XrWorldMeshBlockML(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrWorldMeshBlockML.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrWorldMeshBlockML.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrWorldMeshBlockML.nnext(this.address());
    }

    public XrUuidEXT uuid() {
        return XrWorldMeshBlockML.nuuid(this.address());
    }

    @NativeType(value="XrWorldMeshBlockResultML")
    public int blockResult() {
        return XrWorldMeshBlockML.nblockResult(this.address());
    }

    @NativeType(value="XrWorldMeshDetectorLodML")
    public int lod() {
        return XrWorldMeshBlockML.nlod(this.address());
    }

    @NativeType(value="XrWorldMeshDetectorFlagsML")
    public long flags() {
        return XrWorldMeshBlockML.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int indexCount() {
        return XrWorldMeshBlockML.nindexCount(this.address());
    }

    @NativeType(value="uint16_t *")
    public ShortBuffer indexBuffer() {
        return XrWorldMeshBlockML.nindexBuffer(this.address());
    }

    @NativeType(value="uint32_t")
    public int vertexCount() {
        return XrWorldMeshBlockML.nvertexCount(this.address());
    }

    @NativeType(value="XrVector3f *")
    public XrVector3f.Buffer vertexBuffer() {
        return XrWorldMeshBlockML.nvertexBuffer(this.address());
    }

    @NativeType(value="uint32_t")
    public int normalCount() {
        return XrWorldMeshBlockML.nnormalCount(this.address());
    }

    @NativeType(value="XrVector3f *")
    public XrVector3f.Buffer normalBuffer() {
        return XrWorldMeshBlockML.nnormalBuffer(this.address());
    }

    @NativeType(value="uint32_t")
    public int confidenceCount() {
        return XrWorldMeshBlockML.nconfidenceCount(this.address());
    }

    @NativeType(value="float *")
    public FloatBuffer confidenceBuffer() {
        return XrWorldMeshBlockML.nconfidenceBuffer(this.address());
    }

    public XrWorldMeshBlockML type(@NativeType(value="XrStructureType") int value) {
        XrWorldMeshBlockML.ntype(this.address(), value);
        return this;
    }

    public XrWorldMeshBlockML type$Default() {
        return this.type(1000474010);
    }

    public XrWorldMeshBlockML next(@NativeType(value="void *") long value) {
        XrWorldMeshBlockML.nnext(this.address(), value);
        return this;
    }

    public XrWorldMeshBlockML uuid(XrUuidEXT value) {
        XrWorldMeshBlockML.nuuid(this.address(), value);
        return this;
    }

    public XrWorldMeshBlockML uuid(Consumer<XrUuidEXT> consumer) {
        consumer.accept(this.uuid());
        return this;
    }

    public XrWorldMeshBlockML blockResult(@NativeType(value="XrWorldMeshBlockResultML") int value) {
        XrWorldMeshBlockML.nblockResult(this.address(), value);
        return this;
    }

    public XrWorldMeshBlockML lod(@NativeType(value="XrWorldMeshDetectorLodML") int value) {
        XrWorldMeshBlockML.nlod(this.address(), value);
        return this;
    }

    public XrWorldMeshBlockML flags(@NativeType(value="XrWorldMeshDetectorFlagsML") long value) {
        XrWorldMeshBlockML.nflags(this.address(), value);
        return this;
    }

    public XrWorldMeshBlockML indexBuffer(@NativeType(value="uint16_t *") ShortBuffer value) {
        XrWorldMeshBlockML.nindexBuffer(this.address(), value);
        return this;
    }

    public XrWorldMeshBlockML vertexBuffer(@NativeType(value="XrVector3f *") XrVector3f.Buffer value) {
        XrWorldMeshBlockML.nvertexBuffer(this.address(), value);
        return this;
    }

    public XrWorldMeshBlockML normalBuffer(@NativeType(value="XrVector3f *") XrVector3f.Buffer value) {
        XrWorldMeshBlockML.nnormalBuffer(this.address(), value);
        return this;
    }

    public XrWorldMeshBlockML confidenceBuffer(@NativeType(value="float *") FloatBuffer value) {
        XrWorldMeshBlockML.nconfidenceBuffer(this.address(), value);
        return this;
    }

    public XrWorldMeshBlockML set(int type, long next, XrUuidEXT uuid, int blockResult, int lod, long flags, ShortBuffer indexBuffer, XrVector3f.Buffer vertexBuffer, XrVector3f.Buffer normalBuffer, FloatBuffer confidenceBuffer) {
        this.type(type);
        this.next(next);
        this.uuid(uuid);
        this.blockResult(blockResult);
        this.lod(lod);
        this.flags(flags);
        this.indexBuffer(indexBuffer);
        this.vertexBuffer(vertexBuffer);
        this.normalBuffer(normalBuffer);
        this.confidenceBuffer(confidenceBuffer);
        return this;
    }

    public XrWorldMeshBlockML set(XrWorldMeshBlockML src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrWorldMeshBlockML malloc() {
        return new XrWorldMeshBlockML(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrWorldMeshBlockML calloc() {
        return new XrWorldMeshBlockML(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrWorldMeshBlockML create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrWorldMeshBlockML(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrWorldMeshBlockML create(long address) {
        return new XrWorldMeshBlockML(address, null);
    }

    public static @Nullable XrWorldMeshBlockML createSafe(long address) {
        return address == 0L ? null : new XrWorldMeshBlockML(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrWorldMeshBlockML.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrWorldMeshBlockML.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrWorldMeshBlockML malloc(MemoryStack stack) {
        return new XrWorldMeshBlockML(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrWorldMeshBlockML calloc(MemoryStack stack) {
        return new XrWorldMeshBlockML(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static XrUuidEXT nuuid(long struct) {
        return XrUuidEXT.create(struct + (long)UUID);
    }

    public static int nblockResult(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)BLOCKRESULT));
    }

    public static int nlod(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)LOD));
    }

    public static long nflags(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)FLAGS));
    }

    public static int nindexCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)INDEXCOUNT));
    }

    public static ShortBuffer nindexBuffer(long struct) {
        return MemoryUtil.memShortBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)INDEXBUFFER)), (int)XrWorldMeshBlockML.nindexCount(struct));
    }

    public static int nvertexCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)VERTEXCOUNT));
    }

    public static XrVector3f.Buffer nvertexBuffer(long struct) {
        return XrVector3f.create(MemoryUtil.memGetAddress((long)(struct + (long)VERTEXBUFFER)), XrWorldMeshBlockML.nvertexCount(struct));
    }

    public static int nnormalCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)NORMALCOUNT));
    }

    public static XrVector3f.Buffer nnormalBuffer(long struct) {
        return XrVector3f.create(MemoryUtil.memGetAddress((long)(struct + (long)NORMALBUFFER)), XrWorldMeshBlockML.nnormalCount(struct));
    }

    public static int nconfidenceCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)CONFIDENCECOUNT));
    }

    public static FloatBuffer nconfidenceBuffer(long struct) {
        return MemoryUtil.memFloatBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)CONFIDENCEBUFFER)), (int)XrWorldMeshBlockML.nconfidenceCount(struct));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nuuid(long struct, XrUuidEXT value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)UUID), (long)XrUuidEXT.SIZEOF);
    }

    public static void nblockResult(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)BLOCKRESULT), (int)value);
    }

    public static void nlod(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)LOD), (int)value);
    }

    public static void nflags(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)FLAGS), (long)value);
    }

    public static void nindexCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)INDEXCOUNT), (int)value);
    }

    public static void nindexBuffer(long struct, ShortBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)INDEXBUFFER), (long)MemoryUtil.memAddress((ShortBuffer)value));
        XrWorldMeshBlockML.nindexCount(struct, value.remaining());
    }

    public static void nvertexCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)VERTEXCOUNT), (int)value);
    }

    public static void nvertexBuffer(long struct, XrVector3f.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)VERTEXBUFFER), (long)value.address());
        XrWorldMeshBlockML.nvertexCount(struct, value.remaining());
    }

    public static void nnormalCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)NORMALCOUNT), (int)value);
    }

    public static void nnormalBuffer(long struct, XrVector3f.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NORMALBUFFER), (long)value.address());
        XrWorldMeshBlockML.nnormalCount(struct, value.remaining());
    }

    public static void nconfidenceCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)CONFIDENCECOUNT), (int)value);
    }

    public static void nconfidenceBuffer(long struct, FloatBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)CONFIDENCEBUFFER), (long)MemoryUtil.memAddress((FloatBuffer)value));
        XrWorldMeshBlockML.nconfidenceCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)INDEXBUFFER)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)VERTEXBUFFER)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)NORMALBUFFER)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)CONFIDENCEBUFFER)));
    }

    static {
        Struct.Layout layout = XrWorldMeshBlockML.__struct((Struct.Member[])new Struct.Member[]{XrWorldMeshBlockML.__member((int)4), XrWorldMeshBlockML.__member((int)POINTER_SIZE), XrWorldMeshBlockML.__member((int)XrUuidEXT.SIZEOF, (int)XrUuidEXT.ALIGNOF), XrWorldMeshBlockML.__member((int)4), XrWorldMeshBlockML.__member((int)4), XrWorldMeshBlockML.__member((int)8), XrWorldMeshBlockML.__member((int)4), XrWorldMeshBlockML.__member((int)POINTER_SIZE), XrWorldMeshBlockML.__member((int)4), XrWorldMeshBlockML.__member((int)POINTER_SIZE), XrWorldMeshBlockML.__member((int)4), XrWorldMeshBlockML.__member((int)POINTER_SIZE), XrWorldMeshBlockML.__member((int)4), XrWorldMeshBlockML.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        UUID = layout.offsetof(2);
        BLOCKRESULT = layout.offsetof(3);
        LOD = layout.offsetof(4);
        FLAGS = layout.offsetof(5);
        INDEXCOUNT = layout.offsetof(6);
        INDEXBUFFER = layout.offsetof(7);
        VERTEXCOUNT = layout.offsetof(8);
        VERTEXBUFFER = layout.offsetof(9);
        NORMALCOUNT = layout.offsetof(10);
        NORMALBUFFER = layout.offsetof(11);
        CONFIDENCECOUNT = layout.offsetof(12);
        CONFIDENCEBUFFER = layout.offsetof(13);
    }

    public static class Buffer
    extends StructBuffer<XrWorldMeshBlockML, Buffer>
    implements NativeResource {
        private static final XrWorldMeshBlockML ELEMENT_FACTORY = XrWorldMeshBlockML.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrWorldMeshBlockML getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrWorldMeshBlockML.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrWorldMeshBlockML.nnext(this.address());
        }

        public XrUuidEXT uuid() {
            return XrWorldMeshBlockML.nuuid(this.address());
        }

        @NativeType(value="XrWorldMeshBlockResultML")
        public int blockResult() {
            return XrWorldMeshBlockML.nblockResult(this.address());
        }

        @NativeType(value="XrWorldMeshDetectorLodML")
        public int lod() {
            return XrWorldMeshBlockML.nlod(this.address());
        }

        @NativeType(value="XrWorldMeshDetectorFlagsML")
        public long flags() {
            return XrWorldMeshBlockML.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int indexCount() {
            return XrWorldMeshBlockML.nindexCount(this.address());
        }

        @NativeType(value="uint16_t *")
        public ShortBuffer indexBuffer() {
            return XrWorldMeshBlockML.nindexBuffer(this.address());
        }

        @NativeType(value="uint32_t")
        public int vertexCount() {
            return XrWorldMeshBlockML.nvertexCount(this.address());
        }

        @NativeType(value="XrVector3f *")
        public XrVector3f.Buffer vertexBuffer() {
            return XrWorldMeshBlockML.nvertexBuffer(this.address());
        }

        @NativeType(value="uint32_t")
        public int normalCount() {
            return XrWorldMeshBlockML.nnormalCount(this.address());
        }

        @NativeType(value="XrVector3f *")
        public XrVector3f.Buffer normalBuffer() {
            return XrWorldMeshBlockML.nnormalBuffer(this.address());
        }

        @NativeType(value="uint32_t")
        public int confidenceCount() {
            return XrWorldMeshBlockML.nconfidenceCount(this.address());
        }

        @NativeType(value="float *")
        public FloatBuffer confidenceBuffer() {
            return XrWorldMeshBlockML.nconfidenceBuffer(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrWorldMeshBlockML.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000474010);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrWorldMeshBlockML.nnext(this.address(), value);
            return this;
        }

        public Buffer uuid(XrUuidEXT value) {
            XrWorldMeshBlockML.nuuid(this.address(), value);
            return this;
        }

        public Buffer uuid(Consumer<XrUuidEXT> consumer) {
            consumer.accept(this.uuid());
            return this;
        }

        public Buffer blockResult(@NativeType(value="XrWorldMeshBlockResultML") int value) {
            XrWorldMeshBlockML.nblockResult(this.address(), value);
            return this;
        }

        public Buffer lod(@NativeType(value="XrWorldMeshDetectorLodML") int value) {
            XrWorldMeshBlockML.nlod(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="XrWorldMeshDetectorFlagsML") long value) {
            XrWorldMeshBlockML.nflags(this.address(), value);
            return this;
        }

        public Buffer indexBuffer(@NativeType(value="uint16_t *") ShortBuffer value) {
            XrWorldMeshBlockML.nindexBuffer(this.address(), value);
            return this;
        }

        public Buffer vertexBuffer(@NativeType(value="XrVector3f *") XrVector3f.Buffer value) {
            XrWorldMeshBlockML.nvertexBuffer(this.address(), value);
            return this;
        }

        public Buffer normalBuffer(@NativeType(value="XrVector3f *") XrVector3f.Buffer value) {
            XrWorldMeshBlockML.nnormalBuffer(this.address(), value);
            return this;
        }

        public Buffer confidenceBuffer(@NativeType(value="float *") FloatBuffer value) {
            XrWorldMeshBlockML.nconfidenceBuffer(this.address(), value);
            return this;
        }
    }
}

