/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrUuidEXT;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrWorldMeshBlockRequestML
extends Struct<XrWorldMeshBlockRequestML>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int UUID;
    public static final int LOD;

    protected XrWorldMeshBlockRequestML(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrWorldMeshBlockRequestML create(long address, @Nullable ByteBuffer container) {
        return new XrWorldMeshBlockRequestML(address, container);
    }

    public XrWorldMeshBlockRequestML(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrWorldMeshBlockRequestML.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrWorldMeshBlockRequestML.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrWorldMeshBlockRequestML.nnext(this.address());
    }

    public XrUuidEXT uuid() {
        return XrWorldMeshBlockRequestML.nuuid(this.address());
    }

    @NativeType(value="XrWorldMeshDetectorLodML")
    public int lod() {
        return XrWorldMeshBlockRequestML.nlod(this.address());
    }

    public XrWorldMeshBlockRequestML type(@NativeType(value="XrStructureType") int value) {
        XrWorldMeshBlockRequestML.ntype(this.address(), value);
        return this;
    }

    public XrWorldMeshBlockRequestML type$Default() {
        return this.type(1000474008);
    }

    public XrWorldMeshBlockRequestML next(@NativeType(value="void *") long value) {
        XrWorldMeshBlockRequestML.nnext(this.address(), value);
        return this;
    }

    public XrWorldMeshBlockRequestML uuid(XrUuidEXT value) {
        XrWorldMeshBlockRequestML.nuuid(this.address(), value);
        return this;
    }

    public XrWorldMeshBlockRequestML uuid(Consumer<XrUuidEXT> consumer) {
        consumer.accept(this.uuid());
        return this;
    }

    public XrWorldMeshBlockRequestML lod(@NativeType(value="XrWorldMeshDetectorLodML") int value) {
        XrWorldMeshBlockRequestML.nlod(this.address(), value);
        return this;
    }

    public XrWorldMeshBlockRequestML set(int type, long next, XrUuidEXT uuid, int lod) {
        this.type(type);
        this.next(next);
        this.uuid(uuid);
        this.lod(lod);
        return this;
    }

    public XrWorldMeshBlockRequestML set(XrWorldMeshBlockRequestML src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrWorldMeshBlockRequestML malloc() {
        return new XrWorldMeshBlockRequestML(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrWorldMeshBlockRequestML calloc() {
        return new XrWorldMeshBlockRequestML(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrWorldMeshBlockRequestML create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrWorldMeshBlockRequestML(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrWorldMeshBlockRequestML create(long address) {
        return new XrWorldMeshBlockRequestML(address, null);
    }

    public static @Nullable XrWorldMeshBlockRequestML createSafe(long address) {
        return address == 0L ? null : new XrWorldMeshBlockRequestML(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrWorldMeshBlockRequestML.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrWorldMeshBlockRequestML.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrWorldMeshBlockRequestML malloc(MemoryStack stack) {
        return new XrWorldMeshBlockRequestML(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrWorldMeshBlockRequestML calloc(MemoryStack stack) {
        return new XrWorldMeshBlockRequestML(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static XrUuidEXT nuuid(long struct) {
        return XrUuidEXT.create(struct + (long)UUID);
    }

    public static int nlod(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)LOD));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nuuid(long struct, XrUuidEXT value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)UUID), (long)XrUuidEXT.SIZEOF);
    }

    public static void nlod(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)LOD), (int)value);
    }

    static {
        Struct.Layout layout = XrWorldMeshBlockRequestML.__struct((Struct.Member[])new Struct.Member[]{XrWorldMeshBlockRequestML.__member((int)4), XrWorldMeshBlockRequestML.__member((int)POINTER_SIZE), XrWorldMeshBlockRequestML.__member((int)XrUuidEXT.SIZEOF, (int)XrUuidEXT.ALIGNOF), XrWorldMeshBlockRequestML.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        UUID = layout.offsetof(2);
        LOD = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrWorldMeshBlockRequestML, Buffer>
    implements NativeResource {
        private static final XrWorldMeshBlockRequestML ELEMENT_FACTORY = XrWorldMeshBlockRequestML.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrWorldMeshBlockRequestML getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrWorldMeshBlockRequestML.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrWorldMeshBlockRequestML.nnext(this.address());
        }

        public XrUuidEXT uuid() {
            return XrWorldMeshBlockRequestML.nuuid(this.address());
        }

        @NativeType(value="XrWorldMeshDetectorLodML")
        public int lod() {
            return XrWorldMeshBlockRequestML.nlod(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrWorldMeshBlockRequestML.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000474008);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrWorldMeshBlockRequestML.nnext(this.address(), value);
            return this;
        }

        public Buffer uuid(XrUuidEXT value) {
            XrWorldMeshBlockRequestML.nuuid(this.address(), value);
            return this;
        }

        public Buffer uuid(Consumer<XrUuidEXT> consumer) {
            consumer.accept(this.uuid());
            return this;
        }

        public Buffer lod(@NativeType(value="XrWorldMeshDetectorLodML") int value) {
            XrWorldMeshBlockRequestML.nlod(this.address(), value);
            return this;
        }
    }
}

