/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrWorldMeshBlockRequestML;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrWorldMeshGetInfoML
extends Struct<XrWorldMeshGetInfoML>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int FLAGS;
    public static final int FILLHOLELENGTH;
    public static final int DISCONNECTEDCOMPONENTAREA;
    public static final int BLOCKCOUNT;
    public static final int BLOCKS;

    protected XrWorldMeshGetInfoML(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XrWorldMeshGetInfoML create(long address, @Nullable ByteBuffer container) {
        return new XrWorldMeshGetInfoML(address, container);
    }

    public XrWorldMeshGetInfoML(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrWorldMeshGetInfoML.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrWorldMeshGetInfoML.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrWorldMeshGetInfoML.nnext(this.address());
    }

    @NativeType(value="XrWorldMeshDetectorFlagsML")
    public long flags() {
        return XrWorldMeshGetInfoML.nflags(this.address());
    }

    public float fillHoleLength() {
        return XrWorldMeshGetInfoML.nfillHoleLength(this.address());
    }

    public float disconnectedComponentArea() {
        return XrWorldMeshGetInfoML.ndisconnectedComponentArea(this.address());
    }

    @NativeType(value="uint32_t")
    public int blockCount() {
        return XrWorldMeshGetInfoML.nblockCount(this.address());
    }

    @NativeType(value="XrWorldMeshBlockRequestML *")
    public XrWorldMeshBlockRequestML.Buffer blocks() {
        return XrWorldMeshGetInfoML.nblocks(this.address());
    }

    public XrWorldMeshGetInfoML type(@NativeType(value="XrStructureType") int value) {
        XrWorldMeshGetInfoML.ntype(this.address(), value);
        return this;
    }

    public XrWorldMeshGetInfoML type$Default() {
        return this.type(1000474009);
    }

    public XrWorldMeshGetInfoML next(@NativeType(value="void const *") long value) {
        XrWorldMeshGetInfoML.nnext(this.address(), value);
        return this;
    }

    public XrWorldMeshGetInfoML flags(@NativeType(value="XrWorldMeshDetectorFlagsML") long value) {
        XrWorldMeshGetInfoML.nflags(this.address(), value);
        return this;
    }

    public XrWorldMeshGetInfoML fillHoleLength(float value) {
        XrWorldMeshGetInfoML.nfillHoleLength(this.address(), value);
        return this;
    }

    public XrWorldMeshGetInfoML disconnectedComponentArea(float value) {
        XrWorldMeshGetInfoML.ndisconnectedComponentArea(this.address(), value);
        return this;
    }

    public XrWorldMeshGetInfoML blocks(@NativeType(value="XrWorldMeshBlockRequestML *") XrWorldMeshBlockRequestML.Buffer value) {
        XrWorldMeshGetInfoML.nblocks(this.address(), value);
        return this;
    }

    public XrWorldMeshGetInfoML set(int type, long next, long flags, float fillHoleLength, float disconnectedComponentArea, XrWorldMeshBlockRequestML.Buffer blocks) {
        this.type(type);
        this.next(next);
        this.flags(flags);
        this.fillHoleLength(fillHoleLength);
        this.disconnectedComponentArea(disconnectedComponentArea);
        this.blocks(blocks);
        return this;
    }

    public XrWorldMeshGetInfoML set(XrWorldMeshGetInfoML src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrWorldMeshGetInfoML malloc() {
        return new XrWorldMeshGetInfoML(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XrWorldMeshGetInfoML calloc() {
        return new XrWorldMeshGetInfoML(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XrWorldMeshGetInfoML create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XrWorldMeshGetInfoML(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XrWorldMeshGetInfoML create(long address) {
        return new XrWorldMeshGetInfoML(address, null);
    }

    public static @Nullable XrWorldMeshGetInfoML createSafe(long address) {
        return address == 0L ? null : new XrWorldMeshGetInfoML(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XrWorldMeshGetInfoML.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrWorldMeshGetInfoML.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static XrWorldMeshGetInfoML malloc(MemoryStack stack) {
        return new XrWorldMeshGetInfoML(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XrWorldMeshGetInfoML calloc(MemoryStack stack) {
        return new XrWorldMeshGetInfoML(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long nflags(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)FLAGS));
    }

    public static float nfillHoleLength(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)FILLHOLELENGTH));
    }

    public static float ndisconnectedComponentArea(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)DISCONNECTEDCOMPONENTAREA));
    }

    public static int nblockCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)BLOCKCOUNT));
    }

    public static XrWorldMeshBlockRequestML.Buffer nblocks(long struct) {
        return XrWorldMeshBlockRequestML.create(MemoryUtil.memGetAddress((long)(struct + (long)BLOCKS)), XrWorldMeshGetInfoML.nblockCount(struct));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nflags(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)FLAGS), (long)value);
    }

    public static void nfillHoleLength(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)FILLHOLELENGTH), (float)value);
    }

    public static void ndisconnectedComponentArea(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)DISCONNECTEDCOMPONENTAREA), (float)value);
    }

    public static void nblockCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)BLOCKCOUNT), (int)value);
    }

    public static void nblocks(long struct, XrWorldMeshBlockRequestML.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)BLOCKS), (long)value.address());
        XrWorldMeshGetInfoML.nblockCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)BLOCKS)));
    }

    static {
        Struct.Layout layout = XrWorldMeshGetInfoML.__struct((Struct.Member[])new Struct.Member[]{XrWorldMeshGetInfoML.__member((int)4), XrWorldMeshGetInfoML.__member((int)POINTER_SIZE), XrWorldMeshGetInfoML.__member((int)8), XrWorldMeshGetInfoML.__member((int)4), XrWorldMeshGetInfoML.__member((int)4), XrWorldMeshGetInfoML.__member((int)4), XrWorldMeshGetInfoML.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        FILLHOLELENGTH = layout.offsetof(3);
        DISCONNECTEDCOMPONENTAREA = layout.offsetof(4);
        BLOCKCOUNT = layout.offsetof(5);
        BLOCKS = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<XrWorldMeshGetInfoML, Buffer>
    implements NativeResource {
        private static final XrWorldMeshGetInfoML ELEMENT_FACTORY = XrWorldMeshGetInfoML.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XrWorldMeshGetInfoML getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrWorldMeshGetInfoML.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrWorldMeshGetInfoML.nnext(this.address());
        }

        @NativeType(value="XrWorldMeshDetectorFlagsML")
        public long flags() {
            return XrWorldMeshGetInfoML.nflags(this.address());
        }

        public float fillHoleLength() {
            return XrWorldMeshGetInfoML.nfillHoleLength(this.address());
        }

        public float disconnectedComponentArea() {
            return XrWorldMeshGetInfoML.ndisconnectedComponentArea(this.address());
        }

        @NativeType(value="uint32_t")
        public int blockCount() {
            return XrWorldMeshGetInfoML.nblockCount(this.address());
        }

        @NativeType(value="XrWorldMeshBlockRequestML *")
        public XrWorldMeshBlockRequestML.Buffer blocks() {
            return XrWorldMeshGetInfoML.nblocks(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrWorldMeshGetInfoML.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000474009);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrWorldMeshGetInfoML.nnext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="XrWorldMeshDetectorFlagsML") long value) {
            XrWorldMeshGetInfoML.nflags(this.address(), value);
            return this;
        }

        public Buffer fillHoleLength(float value) {
            XrWorldMeshGetInfoML.nfillHoleLength(this.address(), value);
            return this;
        }

        public Buffer disconnectedComponentArea(float value) {
            XrWorldMeshGetInfoML.ndisconnectedComponentArea(this.address(), value);
            return this;
        }

        public Buffer blocks(@NativeType(value="XrWorldMeshBlockRequestML *") XrWorldMeshBlockRequestML.Buffer value) {
            XrWorldMeshGetInfoML.nblocks(this.address(), value);
            return this;
        }
    }
}

