/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.opus;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ogg_packet")
public class OGGPacket
extends Struct<OGGPacket> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PACKET;
    public static final int BYTES;
    public static final int B_O_S;
    public static final int E_O_S;
    public static final int GRANULEPOS;
    public static final int PACKETNO;

    protected OGGPacket(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected OGGPacket create(long address, @Nullable ByteBuffer container) {
        return new OGGPacket(address, container);
    }

    public OGGPacket(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OGGPacket.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned char *")
    public ByteBuffer packet() {
        return OGGPacket.npacket(this.address());
    }

    public long bytes() {
        return OGGPacket.nbytes(this.address());
    }

    public long b_o_s() {
        return OGGPacket.nb_o_s(this.address());
    }

    public long e_o_s() {
        return OGGPacket.ne_o_s(this.address());
    }

    @NativeType(value="ogg_int64_t")
    public long granulepos() {
        return OGGPacket.ngranulepos(this.address());
    }

    @NativeType(value="ogg_int64_t")
    public long packetno() {
        return OGGPacket.npacketno(this.address());
    }

    public static OGGPacket create(long address) {
        return new OGGPacket(address, null);
    }

    public static @Nullable OGGPacket createSafe(long address) {
        return address == 0L ? null : new OGGPacket(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static ByteBuffer npacket(long struct) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PACKET)), (int)((int)OGGPacket.nbytes(struct)));
    }

    public static long nbytes(long struct) {
        return MemoryUtil.memGetCLong((long)(struct + (long)BYTES));
    }

    public static long nb_o_s(long struct) {
        return MemoryUtil.memGetCLong((long)(struct + (long)B_O_S));
    }

    public static long ne_o_s(long struct) {
        return MemoryUtil.memGetCLong((long)(struct + (long)E_O_S));
    }

    public static long ngranulepos(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)GRANULEPOS));
    }

    public static long npacketno(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)PACKETNO));
    }

    static {
        Struct.Layout layout = OGGPacket.__struct((Struct.Member[])new Struct.Member[]{OGGPacket.__member((int)POINTER_SIZE), OGGPacket.__member((int)CLONG_SIZE), OGGPacket.__member((int)CLONG_SIZE), OGGPacket.__member((int)CLONG_SIZE), OGGPacket.__member((int)8), OGGPacket.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PACKET = layout.offsetof(0);
        BYTES = layout.offsetof(1);
        B_O_S = layout.offsetof(2);
        E_O_S = layout.offsetof(3);
        GRANULEPOS = layout.offsetof(4);
        PACKETNO = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<OGGPacket, Buffer> {
        private static final OGGPacket ELEMENT_FACTORY = OGGPacket.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected OGGPacket getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned char *")
        public ByteBuffer packet() {
            return OGGPacket.npacket(this.address());
        }

        public long bytes() {
            return OGGPacket.nbytes(this.address());
        }

        public long b_o_s() {
            return OGGPacket.nb_o_s(this.address());
        }

        public long e_o_s() {
            return OGGPacket.ne_o_s(this.address());
        }

        @NativeType(value="ogg_int64_t")
        public long granulepos() {
            return OGGPacket.ngranulepos(this.address());
        }

        @NativeType(value="ogg_int64_t")
        public long packetno() {
            return OGGPacket.npacketno(this.address());
        }
    }
}

