/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRFovPort;
import org.lwjgl.ovr.OVRMatrix4f;
import org.lwjgl.ovr.OVRSizei;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrCameraIntrinsics")
public class OVRCameraIntrinsics
extends Struct<OVRCameraIntrinsics>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LASTCHANGEDTIME;
    public static final int FOVPORT;
    public static final int VIRTUALNEARPLANEDISTANCEMETERS;
    public static final int VIRTUALFARPLANEDISTANCEMETERS;
    public static final int IMAGESENSORPIXELRESOLUTION;
    public static final int LENSDISTORTIONMATRIX;
    public static final int EXPOSUREPERIODSECONDS;
    public static final int EXPOSUREDURATIONSECONDS;

    protected OVRCameraIntrinsics(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected OVRCameraIntrinsics create(long address, @Nullable ByteBuffer container) {
        return new OVRCameraIntrinsics(address, container);
    }

    public OVRCameraIntrinsics(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OVRCameraIntrinsics.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public double LastChangedTime() {
        return OVRCameraIntrinsics.nLastChangedTime(this.address());
    }

    @NativeType(value="ovrFovPort")
    public OVRFovPort FOVPort() {
        return OVRCameraIntrinsics.nFOVPort(this.address());
    }

    public float VirtualNearPlaneDistanceMeters() {
        return OVRCameraIntrinsics.nVirtualNearPlaneDistanceMeters(this.address());
    }

    public float VirtualFarPlaneDistanceMeters() {
        return OVRCameraIntrinsics.nVirtualFarPlaneDistanceMeters(this.address());
    }

    @NativeType(value="ovrSizei")
    public OVRSizei ImageSensorPixelResolution() {
        return OVRCameraIntrinsics.nImageSensorPixelResolution(this.address());
    }

    @NativeType(value="ovrMatrix4f")
    public OVRMatrix4f LensDistortionMatrix() {
        return OVRCameraIntrinsics.nLensDistortionMatrix(this.address());
    }

    public double ExposurePeriodSeconds() {
        return OVRCameraIntrinsics.nExposurePeriodSeconds(this.address());
    }

    public double ExposureDurationSeconds() {
        return OVRCameraIntrinsics.nExposureDurationSeconds(this.address());
    }

    public OVRCameraIntrinsics LastChangedTime(double value) {
        OVRCameraIntrinsics.nLastChangedTime(this.address(), value);
        return this;
    }

    public OVRCameraIntrinsics FOVPort(@NativeType(value="ovrFovPort") OVRFovPort value) {
        OVRCameraIntrinsics.nFOVPort(this.address(), value);
        return this;
    }

    public OVRCameraIntrinsics FOVPort(Consumer<OVRFovPort> consumer) {
        consumer.accept(this.FOVPort());
        return this;
    }

    public OVRCameraIntrinsics VirtualNearPlaneDistanceMeters(float value) {
        OVRCameraIntrinsics.nVirtualNearPlaneDistanceMeters(this.address(), value);
        return this;
    }

    public OVRCameraIntrinsics VirtualFarPlaneDistanceMeters(float value) {
        OVRCameraIntrinsics.nVirtualFarPlaneDistanceMeters(this.address(), value);
        return this;
    }

    public OVRCameraIntrinsics ImageSensorPixelResolution(@NativeType(value="ovrSizei") OVRSizei value) {
        OVRCameraIntrinsics.nImageSensorPixelResolution(this.address(), value);
        return this;
    }

    public OVRCameraIntrinsics ImageSensorPixelResolution(Consumer<OVRSizei> consumer) {
        consumer.accept(this.ImageSensorPixelResolution());
        return this;
    }

    public OVRCameraIntrinsics LensDistortionMatrix(@NativeType(value="ovrMatrix4f") OVRMatrix4f value) {
        OVRCameraIntrinsics.nLensDistortionMatrix(this.address(), value);
        return this;
    }

    public OVRCameraIntrinsics LensDistortionMatrix(Consumer<OVRMatrix4f> consumer) {
        consumer.accept(this.LensDistortionMatrix());
        return this;
    }

    public OVRCameraIntrinsics ExposurePeriodSeconds(double value) {
        OVRCameraIntrinsics.nExposurePeriodSeconds(this.address(), value);
        return this;
    }

    public OVRCameraIntrinsics ExposureDurationSeconds(double value) {
        OVRCameraIntrinsics.nExposureDurationSeconds(this.address(), value);
        return this;
    }

    public OVRCameraIntrinsics set(double LastChangedTime, OVRFovPort FOVPort, float VirtualNearPlaneDistanceMeters, float VirtualFarPlaneDistanceMeters, OVRSizei ImageSensorPixelResolution, OVRMatrix4f LensDistortionMatrix, double ExposurePeriodSeconds, double ExposureDurationSeconds) {
        this.LastChangedTime(LastChangedTime);
        this.FOVPort(FOVPort);
        this.VirtualNearPlaneDistanceMeters(VirtualNearPlaneDistanceMeters);
        this.VirtualFarPlaneDistanceMeters(VirtualFarPlaneDistanceMeters);
        this.ImageSensorPixelResolution(ImageSensorPixelResolution);
        this.LensDistortionMatrix(LensDistortionMatrix);
        this.ExposurePeriodSeconds(ExposurePeriodSeconds);
        this.ExposureDurationSeconds(ExposureDurationSeconds);
        return this;
    }

    public OVRCameraIntrinsics set(OVRCameraIntrinsics src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static OVRCameraIntrinsics malloc() {
        return new OVRCameraIntrinsics(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static OVRCameraIntrinsics calloc() {
        return new OVRCameraIntrinsics(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static OVRCameraIntrinsics create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new OVRCameraIntrinsics(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static OVRCameraIntrinsics create(long address) {
        return new OVRCameraIntrinsics(address, null);
    }

    public static @Nullable OVRCameraIntrinsics createSafe(long address) {
        return address == 0L ? null : new OVRCameraIntrinsics(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)OVRCameraIntrinsics.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRCameraIntrinsics.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static OVRCameraIntrinsics mallocStack() {
        return OVRCameraIntrinsics.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRCameraIntrinsics callocStack() {
        return OVRCameraIntrinsics.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRCameraIntrinsics mallocStack(MemoryStack stack) {
        return OVRCameraIntrinsics.malloc(stack);
    }

    @Deprecated
    public static OVRCameraIntrinsics callocStack(MemoryStack stack) {
        return OVRCameraIntrinsics.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRCameraIntrinsics.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRCameraIntrinsics.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRCameraIntrinsics.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRCameraIntrinsics.calloc(capacity, stack);
    }

    public static OVRCameraIntrinsics malloc(MemoryStack stack) {
        return new OVRCameraIntrinsics(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static OVRCameraIntrinsics calloc(MemoryStack stack) {
        return new OVRCameraIntrinsics(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static double nLastChangedTime(long struct) {
        return MemoryUtil.memGetDouble((long)(struct + (long)LASTCHANGEDTIME));
    }

    public static OVRFovPort nFOVPort(long struct) {
        return OVRFovPort.create(struct + (long)FOVPORT);
    }

    public static float nVirtualNearPlaneDistanceMeters(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)VIRTUALNEARPLANEDISTANCEMETERS));
    }

    public static float nVirtualFarPlaneDistanceMeters(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)VIRTUALFARPLANEDISTANCEMETERS));
    }

    public static OVRSizei nImageSensorPixelResolution(long struct) {
        return OVRSizei.create(struct + (long)IMAGESENSORPIXELRESOLUTION);
    }

    public static OVRMatrix4f nLensDistortionMatrix(long struct) {
        return OVRMatrix4f.create(struct + (long)LENSDISTORTIONMATRIX);
    }

    public static double nExposurePeriodSeconds(long struct) {
        return MemoryUtil.memGetDouble((long)(struct + (long)EXPOSUREPERIODSECONDS));
    }

    public static double nExposureDurationSeconds(long struct) {
        return MemoryUtil.memGetDouble((long)(struct + (long)EXPOSUREDURATIONSECONDS));
    }

    public static void nLastChangedTime(long struct, double value) {
        MemoryUtil.memPutDouble((long)(struct + (long)LASTCHANGEDTIME), (double)value);
    }

    public static void nFOVPort(long struct, OVRFovPort value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)FOVPORT), (long)OVRFovPort.SIZEOF);
    }

    public static void nVirtualNearPlaneDistanceMeters(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)VIRTUALNEARPLANEDISTANCEMETERS), (float)value);
    }

    public static void nVirtualFarPlaneDistanceMeters(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)VIRTUALFARPLANEDISTANCEMETERS), (float)value);
    }

    public static void nImageSensorPixelResolution(long struct, OVRSizei value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)IMAGESENSORPIXELRESOLUTION), (long)OVRSizei.SIZEOF);
    }

    public static void nLensDistortionMatrix(long struct, OVRMatrix4f value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)LENSDISTORTIONMATRIX), (long)OVRMatrix4f.SIZEOF);
    }

    public static void nExposurePeriodSeconds(long struct, double value) {
        MemoryUtil.memPutDouble((long)(struct + (long)EXPOSUREPERIODSECONDS), (double)value);
    }

    public static void nExposureDurationSeconds(long struct, double value) {
        MemoryUtil.memPutDouble((long)(struct + (long)EXPOSUREDURATIONSECONDS), (double)value);
    }

    static {
        Struct.Layout layout = OVRCameraIntrinsics.__struct((Struct.Member[])new Struct.Member[]{OVRCameraIntrinsics.__member((int)8), OVRCameraIntrinsics.__member((int)OVRFovPort.SIZEOF, (int)OVRFovPort.ALIGNOF), OVRCameraIntrinsics.__member((int)4), OVRCameraIntrinsics.__member((int)4), OVRCameraIntrinsics.__member((int)OVRSizei.SIZEOF, (int)OVRSizei.ALIGNOF), OVRCameraIntrinsics.__member((int)OVRMatrix4f.SIZEOF, (int)OVRMatrix4f.ALIGNOF), OVRCameraIntrinsics.__member((int)8), OVRCameraIntrinsics.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LASTCHANGEDTIME = layout.offsetof(0);
        FOVPORT = layout.offsetof(1);
        VIRTUALNEARPLANEDISTANCEMETERS = layout.offsetof(2);
        VIRTUALFARPLANEDISTANCEMETERS = layout.offsetof(3);
        IMAGESENSORPIXELRESOLUTION = layout.offsetof(4);
        LENSDISTORTIONMATRIX = layout.offsetof(5);
        EXPOSUREPERIODSECONDS = layout.offsetof(6);
        EXPOSUREDURATIONSECONDS = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<OVRCameraIntrinsics, Buffer>
    implements NativeResource {
        private static final OVRCameraIntrinsics ELEMENT_FACTORY = OVRCameraIntrinsics.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected OVRCameraIntrinsics getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public double LastChangedTime() {
            return OVRCameraIntrinsics.nLastChangedTime(this.address());
        }

        @NativeType(value="ovrFovPort")
        public OVRFovPort FOVPort() {
            return OVRCameraIntrinsics.nFOVPort(this.address());
        }

        public float VirtualNearPlaneDistanceMeters() {
            return OVRCameraIntrinsics.nVirtualNearPlaneDistanceMeters(this.address());
        }

        public float VirtualFarPlaneDistanceMeters() {
            return OVRCameraIntrinsics.nVirtualFarPlaneDistanceMeters(this.address());
        }

        @NativeType(value="ovrSizei")
        public OVRSizei ImageSensorPixelResolution() {
            return OVRCameraIntrinsics.nImageSensorPixelResolution(this.address());
        }

        @NativeType(value="ovrMatrix4f")
        public OVRMatrix4f LensDistortionMatrix() {
            return OVRCameraIntrinsics.nLensDistortionMatrix(this.address());
        }

        public double ExposurePeriodSeconds() {
            return OVRCameraIntrinsics.nExposurePeriodSeconds(this.address());
        }

        public double ExposureDurationSeconds() {
            return OVRCameraIntrinsics.nExposureDurationSeconds(this.address());
        }

        public Buffer LastChangedTime(double value) {
            OVRCameraIntrinsics.nLastChangedTime(this.address(), value);
            return this;
        }

        public Buffer FOVPort(@NativeType(value="ovrFovPort") OVRFovPort value) {
            OVRCameraIntrinsics.nFOVPort(this.address(), value);
            return this;
        }

        public Buffer FOVPort(Consumer<OVRFovPort> consumer) {
            consumer.accept(this.FOVPort());
            return this;
        }

        public Buffer VirtualNearPlaneDistanceMeters(float value) {
            OVRCameraIntrinsics.nVirtualNearPlaneDistanceMeters(this.address(), value);
            return this;
        }

        public Buffer VirtualFarPlaneDistanceMeters(float value) {
            OVRCameraIntrinsics.nVirtualFarPlaneDistanceMeters(this.address(), value);
            return this;
        }

        public Buffer ImageSensorPixelResolution(@NativeType(value="ovrSizei") OVRSizei value) {
            OVRCameraIntrinsics.nImageSensorPixelResolution(this.address(), value);
            return this;
        }

        public Buffer ImageSensorPixelResolution(Consumer<OVRSizei> consumer) {
            consumer.accept(this.ImageSensorPixelResolution());
            return this;
        }

        public Buffer LensDistortionMatrix(@NativeType(value="ovrMatrix4f") OVRMatrix4f value) {
            OVRCameraIntrinsics.nLensDistortionMatrix(this.address(), value);
            return this;
        }

        public Buffer LensDistortionMatrix(Consumer<OVRMatrix4f> consumer) {
            consumer.accept(this.LensDistortionMatrix());
            return this;
        }

        public Buffer ExposurePeriodSeconds(double value) {
            OVRCameraIntrinsics.nExposurePeriodSeconds(this.address(), value);
            return this;
        }

        public Buffer ExposureDurationSeconds(double value) {
            OVRCameraIntrinsics.nExposureDurationSeconds(this.address(), value);
            return this;
        }
    }
}

