/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrExtensionProperties")
public class OVRExtensionProperties
extends Struct<OVRExtensionProperties> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int EXTENSIONID;
    public static final int EXTENSIONNAME;
    public static final int EXTENSIONVERSION;

    protected OVRExtensionProperties(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected OVRExtensionProperties create(long address, @Nullable ByteBuffer container) {
        return new OVRExtensionProperties(address, container);
    }

    public OVRExtensionProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OVRExtensionProperties.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public int extensionId() {
        return OVRExtensionProperties.nextensionId(this.address());
    }

    @NativeType(value="char[OVR_MAX_EXTENSION_NAME_SIZE]")
    public ByteBuffer extensionName() {
        return OVRExtensionProperties.nextensionName(this.address());
    }

    @NativeType(value="char[OVR_MAX_EXTENSION_NAME_SIZE]")
    public String extensionNameString() {
        return OVRExtensionProperties.nextensionNameString(this.address());
    }

    @NativeType(value="uint32_t")
    public int extensionVersion() {
        return OVRExtensionProperties.nextensionVersion(this.address());
    }

    public static OVRExtensionProperties create(long address) {
        return new OVRExtensionProperties(address, null);
    }

    public static @Nullable OVRExtensionProperties createSafe(long address) {
        return address == 0L ? null : new OVRExtensionProperties(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static int nextensionId(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)EXTENSIONID));
    }

    public static ByteBuffer nextensionName(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)EXTENSIONNAME), (int)128);
    }

    public static String nextensionNameString(long struct) {
        return MemoryUtil.memASCII((long)(struct + (long)EXTENSIONNAME));
    }

    public static int nextensionVersion(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)EXTENSIONVERSION));
    }

    static {
        Struct.Layout layout = OVRExtensionProperties.__struct((Struct.Member[])new Struct.Member[]{OVRExtensionProperties.__member((int)4), OVRExtensionProperties.__array((int)1, (int)128), OVRExtensionProperties.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        EXTENSIONID = layout.offsetof(0);
        EXTENSIONNAME = layout.offsetof(1);
        EXTENSIONVERSION = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<OVRExtensionProperties, Buffer> {
        private static final OVRExtensionProperties ELEMENT_FACTORY = OVRExtensionProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected OVRExtensionProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int extensionId() {
            return OVRExtensionProperties.nextensionId(this.address());
        }

        @NativeType(value="char[OVR_MAX_EXTENSION_NAME_SIZE]")
        public ByteBuffer extensionName() {
            return OVRExtensionProperties.nextensionName(this.address());
        }

        @NativeType(value="char[OVR_MAX_EXTENSION_NAME_SIZE]")
        public String extensionNameString() {
            return OVRExtensionProperties.nextensionNameString(this.address());
        }

        @NativeType(value="uint32_t")
        public int extensionVersion() {
            return OVRExtensionProperties.nextensionVersion(this.address());
        }
    }
}

