/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRFovPort;
import org.lwjgl.ovr.OVRQuatf;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrFovStencilDesc")
public class OVRFovStencilDesc
extends Struct<OVRFovStencilDesc>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STENCILTYPE;
    public static final int STENCILFLAGS;
    public static final int EYE;
    public static final int FOVPORT;
    public static final int HMDTOEYEROTATION;

    protected OVRFovStencilDesc(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected OVRFovStencilDesc create(long address, @Nullable ByteBuffer container) {
        return new OVRFovStencilDesc(address, container);
    }

    public OVRFovStencilDesc(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OVRFovStencilDesc.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrFovStencilType")
    public int StencilType() {
        return OVRFovStencilDesc.nStencilType(this.address());
    }

    @NativeType(value="uint32_t")
    public int StencilFlags() {
        return OVRFovStencilDesc.nStencilFlags(this.address());
    }

    @NativeType(value="ovrEyeType")
    public int Eye() {
        return OVRFovStencilDesc.nEye(this.address());
    }

    @NativeType(value="ovrFovPort")
    public OVRFovPort FovPort() {
        return OVRFovStencilDesc.nFovPort(this.address());
    }

    @NativeType(value="ovrQuatf")
    public OVRQuatf HmdToEyeRotation() {
        return OVRFovStencilDesc.nHmdToEyeRotation(this.address());
    }

    public OVRFovStencilDesc StencilType(@NativeType(value="ovrFovStencilType") int value) {
        OVRFovStencilDesc.nStencilType(this.address(), value);
        return this;
    }

    public OVRFovStencilDesc StencilFlags(@NativeType(value="uint32_t") int value) {
        OVRFovStencilDesc.nStencilFlags(this.address(), value);
        return this;
    }

    public OVRFovStencilDesc Eye(@NativeType(value="ovrEyeType") int value) {
        OVRFovStencilDesc.nEye(this.address(), value);
        return this;
    }

    public OVRFovStencilDesc FovPort(@NativeType(value="ovrFovPort") OVRFovPort value) {
        OVRFovStencilDesc.nFovPort(this.address(), value);
        return this;
    }

    public OVRFovStencilDesc FovPort(Consumer<OVRFovPort> consumer) {
        consumer.accept(this.FovPort());
        return this;
    }

    public OVRFovStencilDesc HmdToEyeRotation(@NativeType(value="ovrQuatf") OVRQuatf value) {
        OVRFovStencilDesc.nHmdToEyeRotation(this.address(), value);
        return this;
    }

    public OVRFovStencilDesc HmdToEyeRotation(Consumer<OVRQuatf> consumer) {
        consumer.accept(this.HmdToEyeRotation());
        return this;
    }

    public OVRFovStencilDesc set(int StencilType, int StencilFlags, int Eye, OVRFovPort FovPort, OVRQuatf HmdToEyeRotation) {
        this.StencilType(StencilType);
        this.StencilFlags(StencilFlags);
        this.Eye(Eye);
        this.FovPort(FovPort);
        this.HmdToEyeRotation(HmdToEyeRotation);
        return this;
    }

    public OVRFovStencilDesc set(OVRFovStencilDesc src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static OVRFovStencilDesc malloc() {
        return new OVRFovStencilDesc(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static OVRFovStencilDesc calloc() {
        return new OVRFovStencilDesc(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static OVRFovStencilDesc create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new OVRFovStencilDesc(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static OVRFovStencilDesc create(long address) {
        return new OVRFovStencilDesc(address, null);
    }

    public static @Nullable OVRFovStencilDesc createSafe(long address) {
        return address == 0L ? null : new OVRFovStencilDesc(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)OVRFovStencilDesc.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRFovStencilDesc.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static OVRFovStencilDesc mallocStack() {
        return OVRFovStencilDesc.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRFovStencilDesc callocStack() {
        return OVRFovStencilDesc.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRFovStencilDesc mallocStack(MemoryStack stack) {
        return OVRFovStencilDesc.malloc(stack);
    }

    @Deprecated
    public static OVRFovStencilDesc callocStack(MemoryStack stack) {
        return OVRFovStencilDesc.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRFovStencilDesc.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRFovStencilDesc.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRFovStencilDesc.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRFovStencilDesc.calloc(capacity, stack);
    }

    public static OVRFovStencilDesc malloc(MemoryStack stack) {
        return new OVRFovStencilDesc(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static OVRFovStencilDesc calloc(MemoryStack stack) {
        return new OVRFovStencilDesc(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nStencilType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STENCILTYPE));
    }

    public static int nStencilFlags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STENCILFLAGS));
    }

    public static int nEye(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)EYE));
    }

    public static OVRFovPort nFovPort(long struct) {
        return OVRFovPort.create(struct + (long)FOVPORT);
    }

    public static OVRQuatf nHmdToEyeRotation(long struct) {
        return OVRQuatf.create(struct + (long)HMDTOEYEROTATION);
    }

    public static void nStencilType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STENCILTYPE), (int)value);
    }

    public static void nStencilFlags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STENCILFLAGS), (int)value);
    }

    public static void nEye(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)EYE), (int)value);
    }

    public static void nFovPort(long struct, OVRFovPort value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)FOVPORT), (long)OVRFovPort.SIZEOF);
    }

    public static void nHmdToEyeRotation(long struct, OVRQuatf value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)HMDTOEYEROTATION), (long)OVRQuatf.SIZEOF);
    }

    static {
        Struct.Layout layout = OVRFovStencilDesc.__struct((int)DEFAULT_PACK_ALIGNMENT, (int)POINTER_SIZE, (Struct.Member[])new Struct.Member[]{OVRFovStencilDesc.__member((int)4), OVRFovStencilDesc.__member((int)4), OVRFovStencilDesc.__member((int)4), OVRFovStencilDesc.__member((int)OVRFovPort.SIZEOF, (int)OVRFovPort.ALIGNOF), OVRFovStencilDesc.__member((int)OVRQuatf.SIZEOF, (int)OVRQuatf.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STENCILTYPE = layout.offsetof(0);
        STENCILFLAGS = layout.offsetof(1);
        EYE = layout.offsetof(2);
        FOVPORT = layout.offsetof(3);
        HMDTOEYEROTATION = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<OVRFovStencilDesc, Buffer>
    implements NativeResource {
        private static final OVRFovStencilDesc ELEMENT_FACTORY = OVRFovStencilDesc.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected OVRFovStencilDesc getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="ovrFovStencilType")
        public int StencilType() {
            return OVRFovStencilDesc.nStencilType(this.address());
        }

        @NativeType(value="uint32_t")
        public int StencilFlags() {
            return OVRFovStencilDesc.nStencilFlags(this.address());
        }

        @NativeType(value="ovrEyeType")
        public int Eye() {
            return OVRFovStencilDesc.nEye(this.address());
        }

        @NativeType(value="ovrFovPort")
        public OVRFovPort FovPort() {
            return OVRFovStencilDesc.nFovPort(this.address());
        }

        @NativeType(value="ovrQuatf")
        public OVRQuatf HmdToEyeRotation() {
            return OVRFovStencilDesc.nHmdToEyeRotation(this.address());
        }

        public Buffer StencilType(@NativeType(value="ovrFovStencilType") int value) {
            OVRFovStencilDesc.nStencilType(this.address(), value);
            return this;
        }

        public Buffer StencilFlags(@NativeType(value="uint32_t") int value) {
            OVRFovStencilDesc.nStencilFlags(this.address(), value);
            return this;
        }

        public Buffer Eye(@NativeType(value="ovrEyeType") int value) {
            OVRFovStencilDesc.nEye(this.address(), value);
            return this;
        }

        public Buffer FovPort(@NativeType(value="ovrFovPort") OVRFovPort value) {
            OVRFovStencilDesc.nFovPort(this.address(), value);
            return this;
        }

        public Buffer FovPort(Consumer<OVRFovPort> consumer) {
            consumer.accept(this.FovPort());
            return this;
        }

        public Buffer HmdToEyeRotation(@NativeType(value="ovrQuatf") OVRQuatf value) {
            OVRFovStencilDesc.nHmdToEyeRotation(this.address(), value);
            return this;
        }

        public Buffer HmdToEyeRotation(Consumer<OVRQuatf> consumer) {
            consumer.accept(this.HmdToEyeRotation());
            return this;
        }
    }
}

