/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrGraphicsLuid")
public class OVRGraphicsLuid
extends Struct<OVRGraphicsLuid>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RESERVED;

    protected OVRGraphicsLuid(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected OVRGraphicsLuid create(long address, @Nullable ByteBuffer container) {
        return new OVRGraphicsLuid(address, container);
    }

    public OVRGraphicsLuid(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OVRGraphicsLuid.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char[8]")
    public ByteBuffer Reserved() {
        return OVRGraphicsLuid.nReserved(this.address());
    }

    @NativeType(value="char")
    public byte Reserved(int index) {
        return OVRGraphicsLuid.nReserved(this.address(), index);
    }

    public static OVRGraphicsLuid malloc() {
        return new OVRGraphicsLuid(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static OVRGraphicsLuid calloc() {
        return new OVRGraphicsLuid(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static OVRGraphicsLuid create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new OVRGraphicsLuid(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static OVRGraphicsLuid create(long address) {
        return new OVRGraphicsLuid(address, null);
    }

    public static @Nullable OVRGraphicsLuid createSafe(long address) {
        return address == 0L ? null : new OVRGraphicsLuid(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)OVRGraphicsLuid.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRGraphicsLuid.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static OVRGraphicsLuid mallocStack() {
        return OVRGraphicsLuid.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRGraphicsLuid callocStack() {
        return OVRGraphicsLuid.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRGraphicsLuid mallocStack(MemoryStack stack) {
        return OVRGraphicsLuid.malloc(stack);
    }

    @Deprecated
    public static OVRGraphicsLuid callocStack(MemoryStack stack) {
        return OVRGraphicsLuid.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRGraphicsLuid.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRGraphicsLuid.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRGraphicsLuid.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRGraphicsLuid.calloc(capacity, stack);
    }

    public static OVRGraphicsLuid malloc(MemoryStack stack) {
        return new OVRGraphicsLuid(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static OVRGraphicsLuid calloc(MemoryStack stack) {
        return new OVRGraphicsLuid(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nReserved(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)RESERVED), (int)8);
    }

    public static byte nReserved(long struct, int index) {
        return MemoryUtil.memGetByte((long)(struct + (long)RESERVED + Checks.check((int)index, (int)8) * 1L));
    }

    static {
        Struct.Layout layout = OVRGraphicsLuid.__struct((int)DEFAULT_PACK_ALIGNMENT, (int)POINTER_SIZE, (Struct.Member[])new Struct.Member[]{OVRGraphicsLuid.__array((int)1, (int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RESERVED = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<OVRGraphicsLuid, Buffer>
    implements NativeResource {
        private static final OVRGraphicsLuid ELEMENT_FACTORY = OVRGraphicsLuid.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected OVRGraphicsLuid getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char[8]")
        public ByteBuffer Reserved() {
            return OVRGraphicsLuid.nReserved(this.address());
        }

        @NativeType(value="char")
        public byte Reserved(int index) {
            return OVRGraphicsLuid.nReserved(this.address(), index);
        }
    }
}

