/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrHapticsBuffer")
public class OVRHapticsBuffer
extends Struct<OVRHapticsBuffer>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SAMPLES;
    public static final int SAMPLESCOUNT;
    public static final int SUBMITMODE;

    protected OVRHapticsBuffer(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected OVRHapticsBuffer create(long address, @Nullable ByteBuffer container) {
        return new OVRHapticsBuffer(address, container);
    }

    public OVRHapticsBuffer(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OVRHapticsBuffer.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public ByteBuffer Samples(int capacity) {
        return OVRHapticsBuffer.nSamples(this.address(), capacity);
    }

    public int SamplesCount() {
        return OVRHapticsBuffer.nSamplesCount(this.address());
    }

    @NativeType(value="ovrHapticsBufferSubmitMode")
    public int SubmitMode() {
        return OVRHapticsBuffer.nSubmitMode(this.address());
    }

    public OVRHapticsBuffer Samples(@NativeType(value="void *") ByteBuffer value) {
        OVRHapticsBuffer.nSamples(this.address(), value);
        return this;
    }

    public OVRHapticsBuffer SamplesCount(int value) {
        OVRHapticsBuffer.nSamplesCount(this.address(), value);
        return this;
    }

    public OVRHapticsBuffer SubmitMode(@NativeType(value="ovrHapticsBufferSubmitMode") int value) {
        OVRHapticsBuffer.nSubmitMode(this.address(), value);
        return this;
    }

    public OVRHapticsBuffer set(ByteBuffer Samples, int SamplesCount, int SubmitMode) {
        this.Samples(Samples);
        this.SamplesCount(SamplesCount);
        this.SubmitMode(SubmitMode);
        return this;
    }

    public OVRHapticsBuffer set(OVRHapticsBuffer src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static OVRHapticsBuffer malloc() {
        return new OVRHapticsBuffer(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static OVRHapticsBuffer calloc() {
        return new OVRHapticsBuffer(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static OVRHapticsBuffer create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new OVRHapticsBuffer(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static OVRHapticsBuffer create(long address) {
        return new OVRHapticsBuffer(address, null);
    }

    public static @Nullable OVRHapticsBuffer createSafe(long address) {
        return address == 0L ? null : new OVRHapticsBuffer(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)OVRHapticsBuffer.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRHapticsBuffer.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static OVRHapticsBuffer mallocStack() {
        return OVRHapticsBuffer.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRHapticsBuffer callocStack() {
        return OVRHapticsBuffer.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRHapticsBuffer mallocStack(MemoryStack stack) {
        return OVRHapticsBuffer.malloc(stack);
    }

    @Deprecated
    public static OVRHapticsBuffer callocStack(MemoryStack stack) {
        return OVRHapticsBuffer.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRHapticsBuffer.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRHapticsBuffer.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRHapticsBuffer.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRHapticsBuffer.calloc(capacity, stack);
    }

    public static OVRHapticsBuffer malloc(MemoryStack stack) {
        return new OVRHapticsBuffer(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static OVRHapticsBuffer calloc(MemoryStack stack) {
        return new OVRHapticsBuffer(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nSamples(long struct, int capacity) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)SAMPLES)), (int)capacity);
    }

    public static int nSamplesCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SAMPLESCOUNT));
    }

    public static int nSubmitMode(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SUBMITMODE));
    }

    public static void nSamples(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SAMPLES), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void nSamplesCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SAMPLESCOUNT), (int)value);
    }

    public static void nSubmitMode(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SUBMITMODE), (int)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)SAMPLES)));
    }

    static {
        Struct.Layout layout = OVRHapticsBuffer.__struct((Struct.Member[])new Struct.Member[]{OVRHapticsBuffer.__member((int)POINTER_SIZE), OVRHapticsBuffer.__member((int)4), OVRHapticsBuffer.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SAMPLES = layout.offsetof(0);
        SAMPLESCOUNT = layout.offsetof(1);
        SUBMITMODE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<OVRHapticsBuffer, Buffer>
    implements NativeResource {
        private static final OVRHapticsBuffer ELEMENT_FACTORY = OVRHapticsBuffer.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected OVRHapticsBuffer getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public ByteBuffer Samples(int capacity) {
            return OVRHapticsBuffer.nSamples(this.address(), capacity);
        }

        public int SamplesCount() {
            return OVRHapticsBuffer.nSamplesCount(this.address());
        }

        @NativeType(value="ovrHapticsBufferSubmitMode")
        public int SubmitMode() {
            return OVRHapticsBuffer.nSubmitMode(this.address());
        }

        public Buffer Samples(@NativeType(value="void *") ByteBuffer value) {
            OVRHapticsBuffer.nSamples(this.address(), value);
            return this;
        }

        public Buffer SamplesCount(int value) {
            OVRHapticsBuffer.nSamplesCount(this.address(), value);
            return this;
        }

        public Buffer SubmitMode(@NativeType(value="ovrHapticsBufferSubmitMode") int value) {
            OVRHapticsBuffer.nSubmitMode(this.address(), value);
            return this;
        }
    }
}

