/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRVector2f;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrInputState")
public class OVRInputState
extends Struct<OVRInputState>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TIMEINSECONDS;
    public static final int BUTTONS;
    public static final int TOUCHES;
    public static final int INDEXTRIGGER;
    public static final int HANDTRIGGER;
    public static final int THUMBSTICK;
    public static final int CONTROLLERTYPE;
    public static final int INDEXTRIGGERNODEADZONE;
    public static final int HANDTRIGGERNODEADZONE;
    public static final int THUMBSTICKNODEADZONE;
    public static final int INDEXTRIGGERRAW;
    public static final int HANDTRIGGERRAW;
    public static final int THUMBSTICKRAW;

    protected OVRInputState(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected OVRInputState create(long address, @Nullable ByteBuffer container) {
        return new OVRInputState(address, container);
    }

    public OVRInputState(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OVRInputState.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public double TimeInSeconds() {
        return OVRInputState.nTimeInSeconds(this.address());
    }

    @NativeType(value="unsigned int")
    public int Buttons() {
        return OVRInputState.nButtons(this.address());
    }

    @NativeType(value="unsigned int")
    public int Touches() {
        return OVRInputState.nTouches(this.address());
    }

    @NativeType(value="float[ovrHand_Count]")
    public FloatBuffer IndexTrigger() {
        return OVRInputState.nIndexTrigger(this.address());
    }

    public float IndexTrigger(int index) {
        return OVRInputState.nIndexTrigger(this.address(), index);
    }

    @NativeType(value="float[ovrHand_Count]")
    public FloatBuffer HandTrigger() {
        return OVRInputState.nHandTrigger(this.address());
    }

    public float HandTrigger(int index) {
        return OVRInputState.nHandTrigger(this.address(), index);
    }

    @NativeType(value="ovrVector2f[ovrHand_Count]")
    public OVRVector2f.Buffer Thumbstick() {
        return OVRInputState.nThumbstick(this.address());
    }

    @NativeType(value="ovrVector2f")
    public OVRVector2f Thumbstick(int index) {
        return OVRInputState.nThumbstick(this.address(), index);
    }

    @NativeType(value="ovrControllerType")
    public int ControllerType() {
        return OVRInputState.nControllerType(this.address());
    }

    @NativeType(value="float[ovrHand_Count]")
    public FloatBuffer IndexTriggerNoDeadzone() {
        return OVRInputState.nIndexTriggerNoDeadzone(this.address());
    }

    public float IndexTriggerNoDeadzone(int index) {
        return OVRInputState.nIndexTriggerNoDeadzone(this.address(), index);
    }

    @NativeType(value="float[ovrHand_Count]")
    public FloatBuffer HandTriggerNoDeadzone() {
        return OVRInputState.nHandTriggerNoDeadzone(this.address());
    }

    public float HandTriggerNoDeadzone(int index) {
        return OVRInputState.nHandTriggerNoDeadzone(this.address(), index);
    }

    @NativeType(value="ovrVector2f[ovrHand_Count]")
    public OVRVector2f.Buffer ThumbstickNoDeadzone() {
        return OVRInputState.nThumbstickNoDeadzone(this.address());
    }

    @NativeType(value="ovrVector2f")
    public OVRVector2f ThumbstickNoDeadzone(int index) {
        return OVRInputState.nThumbstickNoDeadzone(this.address(), index);
    }

    @NativeType(value="float[ovrHand_Count]")
    public FloatBuffer IndexTriggerRaw() {
        return OVRInputState.nIndexTriggerRaw(this.address());
    }

    public float IndexTriggerRaw(int index) {
        return OVRInputState.nIndexTriggerRaw(this.address(), index);
    }

    @NativeType(value="float[ovrHand_Count]")
    public FloatBuffer HandTriggerRaw() {
        return OVRInputState.nHandTriggerRaw(this.address());
    }

    public float HandTriggerRaw(int index) {
        return OVRInputState.nHandTriggerRaw(this.address(), index);
    }

    @NativeType(value="ovrVector2f[ovrHand_Count]")
    public OVRVector2f.Buffer ThumbstickRaw() {
        return OVRInputState.nThumbstickRaw(this.address());
    }

    @NativeType(value="ovrVector2f")
    public OVRVector2f ThumbstickRaw(int index) {
        return OVRInputState.nThumbstickRaw(this.address(), index);
    }

    public static OVRInputState malloc() {
        return new OVRInputState(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static OVRInputState calloc() {
        return new OVRInputState(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static OVRInputState create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new OVRInputState(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static OVRInputState create(long address) {
        return new OVRInputState(address, null);
    }

    public static @Nullable OVRInputState createSafe(long address) {
        return address == 0L ? null : new OVRInputState(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)OVRInputState.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRInputState.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static OVRInputState mallocStack() {
        return OVRInputState.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRInputState callocStack() {
        return OVRInputState.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRInputState mallocStack(MemoryStack stack) {
        return OVRInputState.malloc(stack);
    }

    @Deprecated
    public static OVRInputState callocStack(MemoryStack stack) {
        return OVRInputState.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRInputState.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRInputState.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRInputState.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRInputState.calloc(capacity, stack);
    }

    public static OVRInputState malloc(MemoryStack stack) {
        return new OVRInputState(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static OVRInputState calloc(MemoryStack stack) {
        return new OVRInputState(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static double nTimeInSeconds(long struct) {
        return MemoryUtil.memGetDouble((long)(struct + (long)TIMEINSECONDS));
    }

    public static int nButtons(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)BUTTONS));
    }

    public static int nTouches(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TOUCHES));
    }

    public static FloatBuffer nIndexTrigger(long struct) {
        return MemoryUtil.memFloatBuffer((long)(struct + (long)INDEXTRIGGER), (int)2);
    }

    public static float nIndexTrigger(long struct, int index) {
        return MemoryUtil.memGetFloat((long)(struct + (long)INDEXTRIGGER + Checks.check((int)index, (int)2) * 4L));
    }

    public static FloatBuffer nHandTrigger(long struct) {
        return MemoryUtil.memFloatBuffer((long)(struct + (long)HANDTRIGGER), (int)2);
    }

    public static float nHandTrigger(long struct, int index) {
        return MemoryUtil.memGetFloat((long)(struct + (long)HANDTRIGGER + Checks.check((int)index, (int)2) * 4L));
    }

    public static OVRVector2f.Buffer nThumbstick(long struct) {
        return OVRVector2f.create(struct + (long)THUMBSTICK, 2);
    }

    public static OVRVector2f nThumbstick(long struct, int index) {
        return OVRVector2f.create(struct + (long)THUMBSTICK + Checks.check((int)index, (int)2) * (long)OVRVector2f.SIZEOF);
    }

    public static int nControllerType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)CONTROLLERTYPE));
    }

    public static FloatBuffer nIndexTriggerNoDeadzone(long struct) {
        return MemoryUtil.memFloatBuffer((long)(struct + (long)INDEXTRIGGERNODEADZONE), (int)2);
    }

    public static float nIndexTriggerNoDeadzone(long struct, int index) {
        return MemoryUtil.memGetFloat((long)(struct + (long)INDEXTRIGGERNODEADZONE + Checks.check((int)index, (int)2) * 4L));
    }

    public static FloatBuffer nHandTriggerNoDeadzone(long struct) {
        return MemoryUtil.memFloatBuffer((long)(struct + (long)HANDTRIGGERNODEADZONE), (int)2);
    }

    public static float nHandTriggerNoDeadzone(long struct, int index) {
        return MemoryUtil.memGetFloat((long)(struct + (long)HANDTRIGGERNODEADZONE + Checks.check((int)index, (int)2) * 4L));
    }

    public static OVRVector2f.Buffer nThumbstickNoDeadzone(long struct) {
        return OVRVector2f.create(struct + (long)THUMBSTICKNODEADZONE, 2);
    }

    public static OVRVector2f nThumbstickNoDeadzone(long struct, int index) {
        return OVRVector2f.create(struct + (long)THUMBSTICKNODEADZONE + Checks.check((int)index, (int)2) * (long)OVRVector2f.SIZEOF);
    }

    public static FloatBuffer nIndexTriggerRaw(long struct) {
        return MemoryUtil.memFloatBuffer((long)(struct + (long)INDEXTRIGGERRAW), (int)2);
    }

    public static float nIndexTriggerRaw(long struct, int index) {
        return MemoryUtil.memGetFloat((long)(struct + (long)INDEXTRIGGERRAW + Checks.check((int)index, (int)2) * 4L));
    }

    public static FloatBuffer nHandTriggerRaw(long struct) {
        return MemoryUtil.memFloatBuffer((long)(struct + (long)HANDTRIGGERRAW), (int)2);
    }

    public static float nHandTriggerRaw(long struct, int index) {
        return MemoryUtil.memGetFloat((long)(struct + (long)HANDTRIGGERRAW + Checks.check((int)index, (int)2) * 4L));
    }

    public static OVRVector2f.Buffer nThumbstickRaw(long struct) {
        return OVRVector2f.create(struct + (long)THUMBSTICKRAW, 2);
    }

    public static OVRVector2f nThumbstickRaw(long struct, int index) {
        return OVRVector2f.create(struct + (long)THUMBSTICKRAW + Checks.check((int)index, (int)2) * (long)OVRVector2f.SIZEOF);
    }

    static {
        Struct.Layout layout = OVRInputState.__struct((Struct.Member[])new Struct.Member[]{OVRInputState.__member((int)8), OVRInputState.__member((int)4), OVRInputState.__member((int)4), OVRInputState.__array((int)4, (int)2), OVRInputState.__array((int)4, (int)2), OVRInputState.__array((int)OVRVector2f.SIZEOF, (int)OVRVector2f.ALIGNOF, (int)2), OVRInputState.__member((int)4), OVRInputState.__array((int)4, (int)2), OVRInputState.__array((int)4, (int)2), OVRInputState.__array((int)OVRVector2f.SIZEOF, (int)OVRVector2f.ALIGNOF, (int)2), OVRInputState.__array((int)4, (int)2), OVRInputState.__array((int)4, (int)2), OVRInputState.__array((int)OVRVector2f.SIZEOF, (int)OVRVector2f.ALIGNOF, (int)2)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TIMEINSECONDS = layout.offsetof(0);
        BUTTONS = layout.offsetof(1);
        TOUCHES = layout.offsetof(2);
        INDEXTRIGGER = layout.offsetof(3);
        HANDTRIGGER = layout.offsetof(4);
        THUMBSTICK = layout.offsetof(5);
        CONTROLLERTYPE = layout.offsetof(6);
        INDEXTRIGGERNODEADZONE = layout.offsetof(7);
        HANDTRIGGERNODEADZONE = layout.offsetof(8);
        THUMBSTICKNODEADZONE = layout.offsetof(9);
        INDEXTRIGGERRAW = layout.offsetof(10);
        HANDTRIGGERRAW = layout.offsetof(11);
        THUMBSTICKRAW = layout.offsetof(12);
    }

    public static class Buffer
    extends StructBuffer<OVRInputState, Buffer>
    implements NativeResource {
        private static final OVRInputState ELEMENT_FACTORY = OVRInputState.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected OVRInputState getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public double TimeInSeconds() {
            return OVRInputState.nTimeInSeconds(this.address());
        }

        @NativeType(value="unsigned int")
        public int Buttons() {
            return OVRInputState.nButtons(this.address());
        }

        @NativeType(value="unsigned int")
        public int Touches() {
            return OVRInputState.nTouches(this.address());
        }

        @NativeType(value="float[ovrHand_Count]")
        public FloatBuffer IndexTrigger() {
            return OVRInputState.nIndexTrigger(this.address());
        }

        public float IndexTrigger(int index) {
            return OVRInputState.nIndexTrigger(this.address(), index);
        }

        @NativeType(value="float[ovrHand_Count]")
        public FloatBuffer HandTrigger() {
            return OVRInputState.nHandTrigger(this.address());
        }

        public float HandTrigger(int index) {
            return OVRInputState.nHandTrigger(this.address(), index);
        }

        @NativeType(value="ovrVector2f[ovrHand_Count]")
        public OVRVector2f.Buffer Thumbstick() {
            return OVRInputState.nThumbstick(this.address());
        }

        @NativeType(value="ovrVector2f")
        public OVRVector2f Thumbstick(int index) {
            return OVRInputState.nThumbstick(this.address(), index);
        }

        @NativeType(value="ovrControllerType")
        public int ControllerType() {
            return OVRInputState.nControllerType(this.address());
        }

        @NativeType(value="float[ovrHand_Count]")
        public FloatBuffer IndexTriggerNoDeadzone() {
            return OVRInputState.nIndexTriggerNoDeadzone(this.address());
        }

        public float IndexTriggerNoDeadzone(int index) {
            return OVRInputState.nIndexTriggerNoDeadzone(this.address(), index);
        }

        @NativeType(value="float[ovrHand_Count]")
        public FloatBuffer HandTriggerNoDeadzone() {
            return OVRInputState.nHandTriggerNoDeadzone(this.address());
        }

        public float HandTriggerNoDeadzone(int index) {
            return OVRInputState.nHandTriggerNoDeadzone(this.address(), index);
        }

        @NativeType(value="ovrVector2f[ovrHand_Count]")
        public OVRVector2f.Buffer ThumbstickNoDeadzone() {
            return OVRInputState.nThumbstickNoDeadzone(this.address());
        }

        @NativeType(value="ovrVector2f")
        public OVRVector2f ThumbstickNoDeadzone(int index) {
            return OVRInputState.nThumbstickNoDeadzone(this.address(), index);
        }

        @NativeType(value="float[ovrHand_Count]")
        public FloatBuffer IndexTriggerRaw() {
            return OVRInputState.nIndexTriggerRaw(this.address());
        }

        public float IndexTriggerRaw(int index) {
            return OVRInputState.nIndexTriggerRaw(this.address(), index);
        }

        @NativeType(value="float[ovrHand_Count]")
        public FloatBuffer HandTriggerRaw() {
            return OVRInputState.nHandTriggerRaw(this.address());
        }

        public float HandTriggerRaw(int index) {
            return OVRInputState.nHandTriggerRaw(this.address(), index);
        }

        @NativeType(value="ovrVector2f[ovrHand_Count]")
        public OVRVector2f.Buffer ThumbstickRaw() {
            return OVRInputState.nThumbstickRaw(this.address());
        }

        @NativeType(value="ovrVector2f")
        public OVRVector2f ThumbstickRaw(int index) {
            return OVRInputState.nThumbstickRaw(this.address(), index);
        }
    }
}

