/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.ovr.OVRLayerHeader;
import org.lwjgl.ovr.OVRMatrix4f;
import org.lwjgl.ovr.OVRPosef;
import org.lwjgl.ovr.OVRRecti;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrLayerEyeMatrix")
public class OVRLayerEyeMatrix
extends Struct<OVRLayerEyeMatrix>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HEADER;
    public static final int COLORTEXTURE;
    public static final int VIEWPORT;
    public static final int RENDERPOSE;
    public static final int MATRIX;
    public static final int SENSORSAMPLETIME;

    protected OVRLayerEyeMatrix(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected OVRLayerEyeMatrix create(long address, @Nullable ByteBuffer container) {
        return new OVRLayerEyeMatrix(address, container);
    }

    public OVRLayerEyeMatrix(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OVRLayerEyeMatrix.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrLayerHeader")
    public OVRLayerHeader Header() {
        return OVRLayerEyeMatrix.nHeader(this.address());
    }

    @NativeType(value="ovrTextureSwapChain[ovrEye_Count]")
    public PointerBuffer ColorTexture() {
        return OVRLayerEyeMatrix.nColorTexture(this.address());
    }

    @NativeType(value="ovrTextureSwapChain")
    public long ColorTexture(int index) {
        return OVRLayerEyeMatrix.nColorTexture(this.address(), index);
    }

    @NativeType(value="ovrRecti[ovrEye_Count]")
    public OVRRecti.Buffer Viewport() {
        return OVRLayerEyeMatrix.nViewport(this.address());
    }

    @NativeType(value="ovrRecti")
    public OVRRecti Viewport(int index) {
        return OVRLayerEyeMatrix.nViewport(this.address(), index);
    }

    @NativeType(value="ovrPosef[ovrEye_Count]")
    public OVRPosef.Buffer RenderPose() {
        return OVRLayerEyeMatrix.nRenderPose(this.address());
    }

    @NativeType(value="ovrPosef")
    public OVRPosef RenderPose(int index) {
        return OVRLayerEyeMatrix.nRenderPose(this.address(), index);
    }

    @NativeType(value="ovrMatrix4f[ovrEye_Count]")
    public OVRMatrix4f.Buffer Matrix() {
        return OVRLayerEyeMatrix.nMatrix(this.address());
    }

    @NativeType(value="ovrMatrix4f")
    public OVRMatrix4f Matrix(int index) {
        return OVRLayerEyeMatrix.nMatrix(this.address(), index);
    }

    public double SensorSampleTime() {
        return OVRLayerEyeMatrix.nSensorSampleTime(this.address());
    }

    public OVRLayerEyeMatrix Header(@NativeType(value="ovrLayerHeader") OVRLayerHeader value) {
        OVRLayerEyeMatrix.nHeader(this.address(), value);
        return this;
    }

    public OVRLayerEyeMatrix Header(Consumer<OVRLayerHeader> consumer) {
        consumer.accept(this.Header());
        return this;
    }

    public OVRLayerEyeMatrix ColorTexture(@NativeType(value="ovrTextureSwapChain[ovrEye_Count]") PointerBuffer value) {
        OVRLayerEyeMatrix.nColorTexture(this.address(), value);
        return this;
    }

    public OVRLayerEyeMatrix ColorTexture(int index, @NativeType(value="ovrTextureSwapChain") long value) {
        OVRLayerEyeMatrix.nColorTexture(this.address(), index, value);
        return this;
    }

    public OVRLayerEyeMatrix Viewport(@NativeType(value="ovrRecti[ovrEye_Count]") OVRRecti.Buffer value) {
        OVRLayerEyeMatrix.nViewport(this.address(), value);
        return this;
    }

    public OVRLayerEyeMatrix Viewport(int index, @NativeType(value="ovrRecti") OVRRecti value) {
        OVRLayerEyeMatrix.nViewport(this.address(), index, value);
        return this;
    }

    public OVRLayerEyeMatrix Viewport(Consumer<OVRRecti.Buffer> consumer) {
        consumer.accept(this.Viewport());
        return this;
    }

    public OVRLayerEyeMatrix Viewport(int index, Consumer<OVRRecti> consumer) {
        consumer.accept(this.Viewport(index));
        return this;
    }

    public OVRLayerEyeMatrix RenderPose(@NativeType(value="ovrPosef[ovrEye_Count]") OVRPosef.Buffer value) {
        OVRLayerEyeMatrix.nRenderPose(this.address(), value);
        return this;
    }

    public OVRLayerEyeMatrix RenderPose(int index, @NativeType(value="ovrPosef") OVRPosef value) {
        OVRLayerEyeMatrix.nRenderPose(this.address(), index, value);
        return this;
    }

    public OVRLayerEyeMatrix RenderPose(Consumer<OVRPosef.Buffer> consumer) {
        consumer.accept(this.RenderPose());
        return this;
    }

    public OVRLayerEyeMatrix RenderPose(int index, Consumer<OVRPosef> consumer) {
        consumer.accept(this.RenderPose(index));
        return this;
    }

    public OVRLayerEyeMatrix Matrix(@NativeType(value="ovrMatrix4f[ovrEye_Count]") OVRMatrix4f.Buffer value) {
        OVRLayerEyeMatrix.nMatrix(this.address(), value);
        return this;
    }

    public OVRLayerEyeMatrix Matrix(int index, @NativeType(value="ovrMatrix4f") OVRMatrix4f value) {
        OVRLayerEyeMatrix.nMatrix(this.address(), index, value);
        return this;
    }

    public OVRLayerEyeMatrix Matrix(Consumer<OVRMatrix4f.Buffer> consumer) {
        consumer.accept(this.Matrix());
        return this;
    }

    public OVRLayerEyeMatrix Matrix(int index, Consumer<OVRMatrix4f> consumer) {
        consumer.accept(this.Matrix(index));
        return this;
    }

    public OVRLayerEyeMatrix SensorSampleTime(double value) {
        OVRLayerEyeMatrix.nSensorSampleTime(this.address(), value);
        return this;
    }

    public OVRLayerEyeMatrix set(OVRLayerHeader Header, PointerBuffer ColorTexture, OVRRecti.Buffer Viewport, OVRPosef.Buffer RenderPose, OVRMatrix4f.Buffer Matrix, double SensorSampleTime) {
        this.Header(Header);
        this.ColorTexture(ColorTexture);
        this.Viewport(Viewport);
        this.RenderPose(RenderPose);
        this.Matrix(Matrix);
        this.SensorSampleTime(SensorSampleTime);
        return this;
    }

    public OVRLayerEyeMatrix set(OVRLayerEyeMatrix src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static OVRLayerEyeMatrix malloc() {
        return new OVRLayerEyeMatrix(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static OVRLayerEyeMatrix calloc() {
        return new OVRLayerEyeMatrix(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static OVRLayerEyeMatrix create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new OVRLayerEyeMatrix(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static OVRLayerEyeMatrix create(long address) {
        return new OVRLayerEyeMatrix(address, null);
    }

    public static @Nullable OVRLayerEyeMatrix createSafe(long address) {
        return address == 0L ? null : new OVRLayerEyeMatrix(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)OVRLayerEyeMatrix.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRLayerEyeMatrix.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static OVRLayerEyeMatrix mallocStack() {
        return OVRLayerEyeMatrix.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRLayerEyeMatrix callocStack() {
        return OVRLayerEyeMatrix.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRLayerEyeMatrix mallocStack(MemoryStack stack) {
        return OVRLayerEyeMatrix.malloc(stack);
    }

    @Deprecated
    public static OVRLayerEyeMatrix callocStack(MemoryStack stack) {
        return OVRLayerEyeMatrix.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRLayerEyeMatrix.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRLayerEyeMatrix.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRLayerEyeMatrix.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRLayerEyeMatrix.calloc(capacity, stack);
    }

    public static OVRLayerEyeMatrix malloc(MemoryStack stack) {
        return new OVRLayerEyeMatrix(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static OVRLayerEyeMatrix calloc(MemoryStack stack) {
        return new OVRLayerEyeMatrix(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static OVRLayerHeader nHeader(long struct) {
        return OVRLayerHeader.create(struct + (long)HEADER);
    }

    public static PointerBuffer nColorTexture(long struct) {
        return MemoryUtil.memPointerBuffer((long)(struct + (long)COLORTEXTURE), (int)2);
    }

    public static long nColorTexture(long struct, int index) {
        return MemoryUtil.memGetAddress((long)(struct + (long)COLORTEXTURE + Checks.check((int)index, (int)2) * (long)POINTER_SIZE));
    }

    public static OVRRecti.Buffer nViewport(long struct) {
        return OVRRecti.create(struct + (long)VIEWPORT, 2);
    }

    public static OVRRecti nViewport(long struct, int index) {
        return OVRRecti.create(struct + (long)VIEWPORT + Checks.check((int)index, (int)2) * (long)OVRRecti.SIZEOF);
    }

    public static OVRPosef.Buffer nRenderPose(long struct) {
        return OVRPosef.create(struct + (long)RENDERPOSE, 2);
    }

    public static OVRPosef nRenderPose(long struct, int index) {
        return OVRPosef.create(struct + (long)RENDERPOSE + Checks.check((int)index, (int)2) * (long)OVRPosef.SIZEOF);
    }

    public static OVRMatrix4f.Buffer nMatrix(long struct) {
        return OVRMatrix4f.create(struct + (long)MATRIX, 2);
    }

    public static OVRMatrix4f nMatrix(long struct, int index) {
        return OVRMatrix4f.create(struct + (long)MATRIX + Checks.check((int)index, (int)2) * (long)OVRMatrix4f.SIZEOF);
    }

    public static double nSensorSampleTime(long struct) {
        return MemoryUtil.memGetDouble((long)(struct + (long)SENSORSAMPLETIME));
    }

    public static void nHeader(long struct, OVRLayerHeader value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)HEADER), (long)OVRLayerHeader.SIZEOF);
    }

    public static void nColorTexture(long struct, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((CustomBuffer)value, (int)2);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((CustomBuffer)value), (long)(struct + (long)COLORTEXTURE), (long)(value.remaining() * POINTER_SIZE));
    }

    public static void nColorTexture(long struct, int index, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)COLORTEXTURE + Checks.check((int)index, (int)2) * (long)POINTER_SIZE), (long)value);
    }

    public static void nViewport(long struct, OVRRecti.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((CustomBuffer)value, (int)2);
        }
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)VIEWPORT), (long)(value.remaining() * OVRRecti.SIZEOF));
    }

    public static void nViewport(long struct, int index, OVRRecti value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)VIEWPORT + Checks.check((int)index, (int)2) * (long)OVRRecti.SIZEOF), (long)OVRRecti.SIZEOF);
    }

    public static void nRenderPose(long struct, OVRPosef.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((CustomBuffer)value, (int)2);
        }
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)RENDERPOSE), (long)(value.remaining() * OVRPosef.SIZEOF));
    }

    public static void nRenderPose(long struct, int index, OVRPosef value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)RENDERPOSE + Checks.check((int)index, (int)2) * (long)OVRPosef.SIZEOF), (long)OVRPosef.SIZEOF);
    }

    public static void nMatrix(long struct, OVRMatrix4f.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((CustomBuffer)value, (int)2);
        }
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MATRIX), (long)(value.remaining() * OVRMatrix4f.SIZEOF));
    }

    public static void nMatrix(long struct, int index, OVRMatrix4f value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MATRIX + Checks.check((int)index, (int)2) * (long)OVRMatrix4f.SIZEOF), (long)OVRMatrix4f.SIZEOF);
    }

    public static void nSensorSampleTime(long struct, double value) {
        MemoryUtil.memPutDouble((long)(struct + (long)SENSORSAMPLETIME), (double)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)COLORTEXTURE)));
    }

    static {
        Struct.Layout layout = OVRLayerEyeMatrix.__struct((Struct.Member[])new Struct.Member[]{OVRLayerEyeMatrix.__member((int)OVRLayerHeader.SIZEOF, (int)OVRLayerHeader.ALIGNOF, (boolean)true), OVRLayerEyeMatrix.__array((int)POINTER_SIZE, (int)2), OVRLayerEyeMatrix.__array((int)OVRRecti.SIZEOF, (int)OVRRecti.ALIGNOF, (int)2), OVRLayerEyeMatrix.__array((int)OVRPosef.SIZEOF, (int)OVRPosef.ALIGNOF, (int)2), OVRLayerEyeMatrix.__array((int)OVRMatrix4f.SIZEOF, (int)OVRMatrix4f.ALIGNOF, (int)2), OVRLayerEyeMatrix.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HEADER = layout.offsetof(0);
        COLORTEXTURE = layout.offsetof(1);
        VIEWPORT = layout.offsetof(2);
        RENDERPOSE = layout.offsetof(3);
        MATRIX = layout.offsetof(4);
        SENSORSAMPLETIME = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<OVRLayerEyeMatrix, Buffer>
    implements NativeResource {
        private static final OVRLayerEyeMatrix ELEMENT_FACTORY = OVRLayerEyeMatrix.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected OVRLayerEyeMatrix getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="ovrLayerHeader")
        public OVRLayerHeader Header() {
            return OVRLayerEyeMatrix.nHeader(this.address());
        }

        @NativeType(value="ovrTextureSwapChain[ovrEye_Count]")
        public PointerBuffer ColorTexture() {
            return OVRLayerEyeMatrix.nColorTexture(this.address());
        }

        @NativeType(value="ovrTextureSwapChain")
        public long ColorTexture(int index) {
            return OVRLayerEyeMatrix.nColorTexture(this.address(), index);
        }

        @NativeType(value="ovrRecti[ovrEye_Count]")
        public OVRRecti.Buffer Viewport() {
            return OVRLayerEyeMatrix.nViewport(this.address());
        }

        @NativeType(value="ovrRecti")
        public OVRRecti Viewport(int index) {
            return OVRLayerEyeMatrix.nViewport(this.address(), index);
        }

        @NativeType(value="ovrPosef[ovrEye_Count]")
        public OVRPosef.Buffer RenderPose() {
            return OVRLayerEyeMatrix.nRenderPose(this.address());
        }

        @NativeType(value="ovrPosef")
        public OVRPosef RenderPose(int index) {
            return OVRLayerEyeMatrix.nRenderPose(this.address(), index);
        }

        @NativeType(value="ovrMatrix4f[ovrEye_Count]")
        public OVRMatrix4f.Buffer Matrix() {
            return OVRLayerEyeMatrix.nMatrix(this.address());
        }

        @NativeType(value="ovrMatrix4f")
        public OVRMatrix4f Matrix(int index) {
            return OVRLayerEyeMatrix.nMatrix(this.address(), index);
        }

        public double SensorSampleTime() {
            return OVRLayerEyeMatrix.nSensorSampleTime(this.address());
        }

        public Buffer Header(@NativeType(value="ovrLayerHeader") OVRLayerHeader value) {
            OVRLayerEyeMatrix.nHeader(this.address(), value);
            return this;
        }

        public Buffer Header(Consumer<OVRLayerHeader> consumer) {
            consumer.accept(this.Header());
            return this;
        }

        public Buffer ColorTexture(@NativeType(value="ovrTextureSwapChain[ovrEye_Count]") PointerBuffer value) {
            OVRLayerEyeMatrix.nColorTexture(this.address(), value);
            return this;
        }

        public Buffer ColorTexture(int index, @NativeType(value="ovrTextureSwapChain") long value) {
            OVRLayerEyeMatrix.nColorTexture(this.address(), index, value);
            return this;
        }

        public Buffer Viewport(@NativeType(value="ovrRecti[ovrEye_Count]") OVRRecti.Buffer value) {
            OVRLayerEyeMatrix.nViewport(this.address(), value);
            return this;
        }

        public Buffer Viewport(int index, @NativeType(value="ovrRecti") OVRRecti value) {
            OVRLayerEyeMatrix.nViewport(this.address(), index, value);
            return this;
        }

        public Buffer Viewport(Consumer<OVRRecti.Buffer> consumer) {
            consumer.accept(this.Viewport());
            return this;
        }

        public Buffer Viewport(int index, Consumer<OVRRecti> consumer) {
            consumer.accept(this.Viewport(index));
            return this;
        }

        public Buffer RenderPose(@NativeType(value="ovrPosef[ovrEye_Count]") OVRPosef.Buffer value) {
            OVRLayerEyeMatrix.nRenderPose(this.address(), value);
            return this;
        }

        public Buffer RenderPose(int index, @NativeType(value="ovrPosef") OVRPosef value) {
            OVRLayerEyeMatrix.nRenderPose(this.address(), index, value);
            return this;
        }

        public Buffer RenderPose(Consumer<OVRPosef.Buffer> consumer) {
            consumer.accept(this.RenderPose());
            return this;
        }

        public Buffer RenderPose(int index, Consumer<OVRPosef> consumer) {
            consumer.accept(this.RenderPose(index));
            return this;
        }

        public Buffer Matrix(@NativeType(value="ovrMatrix4f[ovrEye_Count]") OVRMatrix4f.Buffer value) {
            OVRLayerEyeMatrix.nMatrix(this.address(), value);
            return this;
        }

        public Buffer Matrix(int index, @NativeType(value="ovrMatrix4f") OVRMatrix4f value) {
            OVRLayerEyeMatrix.nMatrix(this.address(), index, value);
            return this;
        }

        public Buffer Matrix(Consumer<OVRMatrix4f.Buffer> consumer) {
            consumer.accept(this.Matrix());
            return this;
        }

        public Buffer Matrix(int index, Consumer<OVRMatrix4f> consumer) {
            consumer.accept(this.Matrix(index));
            return this;
        }

        public Buffer SensorSampleTime(double value) {
            OVRLayerEyeMatrix.nSensorSampleTime(this.address(), value);
            return this;
        }
    }
}

