/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrLayerHeader")
public class OVRLayerHeader
extends Struct<OVRLayerHeader>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int FLAGS;

    protected OVRLayerHeader(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected OVRLayerHeader create(long address, @Nullable ByteBuffer container) {
        return new OVRLayerHeader(address, container);
    }

    public OVRLayerHeader(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OVRLayerHeader.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrLayerType")
    public int Type() {
        return OVRLayerHeader.nType(this.address());
    }

    @NativeType(value="unsigned int")
    public int Flags() {
        return OVRLayerHeader.nFlags(this.address());
    }

    public OVRLayerHeader Type(@NativeType(value="ovrLayerType") int value) {
        OVRLayerHeader.nType(this.address(), value);
        return this;
    }

    public OVRLayerHeader Flags(@NativeType(value="unsigned int") int value) {
        OVRLayerHeader.nFlags(this.address(), value);
        return this;
    }

    public OVRLayerHeader set(int Type, int Flags) {
        this.Type(Type);
        this.Flags(Flags);
        return this;
    }

    public OVRLayerHeader set(OVRLayerHeader src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static OVRLayerHeader malloc() {
        return new OVRLayerHeader(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static OVRLayerHeader calloc() {
        return new OVRLayerHeader(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static OVRLayerHeader create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new OVRLayerHeader(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static OVRLayerHeader create(long address) {
        return new OVRLayerHeader(address, null);
    }

    public static @Nullable OVRLayerHeader createSafe(long address) {
        return address == 0L ? null : new OVRLayerHeader(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)OVRLayerHeader.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRLayerHeader.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static OVRLayerHeader mallocStack() {
        return OVRLayerHeader.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRLayerHeader callocStack() {
        return OVRLayerHeader.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRLayerHeader mallocStack(MemoryStack stack) {
        return OVRLayerHeader.malloc(stack);
    }

    @Deprecated
    public static OVRLayerHeader callocStack(MemoryStack stack) {
        return OVRLayerHeader.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRLayerHeader.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRLayerHeader.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRLayerHeader.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRLayerHeader.calloc(capacity, stack);
    }

    public static OVRLayerHeader malloc(MemoryStack stack) {
        return new OVRLayerHeader(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static OVRLayerHeader calloc(MemoryStack stack) {
        return new OVRLayerHeader(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nType(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static int nFlags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FLAGS));
    }

    public static void nType(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nFlags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FLAGS), (int)value);
    }

    static {
        Struct.Layout layout = OVRLayerHeader.__struct((int)DEFAULT_PACK_ALIGNMENT, (int)POINTER_SIZE, (Struct.Member[])new Struct.Member[]{OVRLayerHeader.__member((int)4), OVRLayerHeader.__member((int)4), OVRLayerHeader.__padding((int)128, (boolean)true)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        FLAGS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<OVRLayerHeader, Buffer>
    implements NativeResource {
        private static final OVRLayerHeader ELEMENT_FACTORY = OVRLayerHeader.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected OVRLayerHeader getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="ovrLayerType")
        public int Type() {
            return OVRLayerHeader.nType(this.address());
        }

        @NativeType(value="unsigned int")
        public int Flags() {
            return OVRLayerHeader.nFlags(this.address());
        }

        public Buffer Type(@NativeType(value="ovrLayerType") int value) {
            OVRLayerHeader.nType(this.address(), value);
            return this;
        }

        public Buffer Flags(@NativeType(value="unsigned int") int value) {
            OVRLayerHeader.nFlags(this.address(), value);
            return this;
        }
    }
}

