/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrMatrix4f")
public class OVRMatrix4f
extends Struct<OVRMatrix4f>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int M;

    protected OVRMatrix4f(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected OVRMatrix4f create(long address, @Nullable ByteBuffer container) {
        return new OVRMatrix4f(address, container);
    }

    public OVRMatrix4f(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OVRMatrix4f.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="float[16]")
    public FloatBuffer M() {
        return OVRMatrix4f.nM(this.address());
    }

    public float M(int index) {
        return OVRMatrix4f.nM(this.address(), index);
    }

    public OVRMatrix4f M(@NativeType(value="float[16]") FloatBuffer value) {
        OVRMatrix4f.nM(this.address(), value);
        return this;
    }

    public OVRMatrix4f M(int index, float value) {
        OVRMatrix4f.nM(this.address(), index, value);
        return this;
    }

    public OVRMatrix4f set(OVRMatrix4f src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static OVRMatrix4f malloc() {
        return new OVRMatrix4f(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static OVRMatrix4f calloc() {
        return new OVRMatrix4f(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static OVRMatrix4f create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new OVRMatrix4f(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static OVRMatrix4f create(long address) {
        return new OVRMatrix4f(address, null);
    }

    public static @Nullable OVRMatrix4f createSafe(long address) {
        return address == 0L ? null : new OVRMatrix4f(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)OVRMatrix4f.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRMatrix4f.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static OVRMatrix4f mallocStack() {
        return OVRMatrix4f.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRMatrix4f callocStack() {
        return OVRMatrix4f.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRMatrix4f mallocStack(MemoryStack stack) {
        return OVRMatrix4f.malloc(stack);
    }

    @Deprecated
    public static OVRMatrix4f callocStack(MemoryStack stack) {
        return OVRMatrix4f.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRMatrix4f.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRMatrix4f.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRMatrix4f.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRMatrix4f.calloc(capacity, stack);
    }

    public static OVRMatrix4f malloc(MemoryStack stack) {
        return new OVRMatrix4f(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static OVRMatrix4f calloc(MemoryStack stack) {
        return new OVRMatrix4f(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static FloatBuffer nM(long struct) {
        return MemoryUtil.memFloatBuffer((long)(struct + (long)M), (int)16);
    }

    public static float nM(long struct, int index) {
        return MemoryUtil.memGetFloat((long)(struct + (long)M + Checks.check((int)index, (int)16) * 4L));
    }

    public static void nM(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)16);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((FloatBuffer)value), (long)(struct + (long)M), (long)(value.remaining() * 4));
    }

    public static void nM(long struct, int index, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)M + Checks.check((int)index, (int)16) * 4L), (float)value);
    }

    static {
        Struct.Layout layout = OVRMatrix4f.__struct((Struct.Member[])new Struct.Member[]{OVRMatrix4f.__array((int)4, (int)16)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        M = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<OVRMatrix4f, Buffer>
    implements NativeResource {
        private static final OVRMatrix4f ELEMENT_FACTORY = OVRMatrix4f.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected OVRMatrix4f getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="float[16]")
        public FloatBuffer M() {
            return OVRMatrix4f.nM(this.address());
        }

        public float M(int index) {
            return OVRMatrix4f.nM(this.address(), index);
        }

        public Buffer M(@NativeType(value="float[16]") FloatBuffer value) {
            OVRMatrix4f.nM(this.address(), value);
            return this;
        }

        public Buffer M(int index, float value) {
            OVRMatrix4f.nM(this.address(), index, value);
            return this;
        }
    }
}

