/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrMirrorTextureDesc")
public class OVRMirrorTextureDesc
extends Struct<OVRMirrorTextureDesc>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FORMAT;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int MISCFLAGS;

    protected OVRMirrorTextureDesc(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected OVRMirrorTextureDesc create(long address, @Nullable ByteBuffer container) {
        return new OVRMirrorTextureDesc(address, container);
    }

    public OVRMirrorTextureDesc(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OVRMirrorTextureDesc.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrTextureFormat")
    public int Format() {
        return OVRMirrorTextureDesc.nFormat(this.address());
    }

    public int Width() {
        return OVRMirrorTextureDesc.nWidth(this.address());
    }

    public int Height() {
        return OVRMirrorTextureDesc.nHeight(this.address());
    }

    @NativeType(value="unsigned int")
    public int MiscFlags() {
        return OVRMirrorTextureDesc.nMiscFlags(this.address());
    }

    public OVRMirrorTextureDesc Format(@NativeType(value="ovrTextureFormat") int value) {
        OVRMirrorTextureDesc.nFormat(this.address(), value);
        return this;
    }

    public OVRMirrorTextureDesc Width(int value) {
        OVRMirrorTextureDesc.nWidth(this.address(), value);
        return this;
    }

    public OVRMirrorTextureDesc Height(int value) {
        OVRMirrorTextureDesc.nHeight(this.address(), value);
        return this;
    }

    public OVRMirrorTextureDesc MiscFlags(@NativeType(value="unsigned int") int value) {
        OVRMirrorTextureDesc.nMiscFlags(this.address(), value);
        return this;
    }

    public OVRMirrorTextureDesc set(int Format, int Width, int Height, int MiscFlags) {
        this.Format(Format);
        this.Width(Width);
        this.Height(Height);
        this.MiscFlags(MiscFlags);
        return this;
    }

    public OVRMirrorTextureDesc set(OVRMirrorTextureDesc src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static OVRMirrorTextureDesc malloc() {
        return new OVRMirrorTextureDesc(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static OVRMirrorTextureDesc calloc() {
        return new OVRMirrorTextureDesc(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static OVRMirrorTextureDesc create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new OVRMirrorTextureDesc(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static OVRMirrorTextureDesc create(long address) {
        return new OVRMirrorTextureDesc(address, null);
    }

    public static @Nullable OVRMirrorTextureDesc createSafe(long address) {
        return address == 0L ? null : new OVRMirrorTextureDesc(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)OVRMirrorTextureDesc.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRMirrorTextureDesc.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static OVRMirrorTextureDesc mallocStack() {
        return OVRMirrorTextureDesc.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRMirrorTextureDesc callocStack() {
        return OVRMirrorTextureDesc.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRMirrorTextureDesc mallocStack(MemoryStack stack) {
        return OVRMirrorTextureDesc.malloc(stack);
    }

    @Deprecated
    public static OVRMirrorTextureDesc callocStack(MemoryStack stack) {
        return OVRMirrorTextureDesc.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRMirrorTextureDesc.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRMirrorTextureDesc.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRMirrorTextureDesc.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRMirrorTextureDesc.calloc(capacity, stack);
    }

    public static OVRMirrorTextureDesc malloc(MemoryStack stack) {
        return new OVRMirrorTextureDesc(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static OVRMirrorTextureDesc calloc(MemoryStack stack) {
        return new OVRMirrorTextureDesc(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nFormat(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FORMAT));
    }

    public static int nWidth(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)WIDTH));
    }

    public static int nHeight(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)HEIGHT));
    }

    public static int nMiscFlags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MISCFLAGS));
    }

    public static void nFormat(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FORMAT), (int)value);
    }

    public static void nWidth(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)WIDTH), (int)value);
    }

    public static void nHeight(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)HEIGHT), (int)value);
    }

    public static void nMiscFlags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MISCFLAGS), (int)value);
    }

    static {
        Struct.Layout layout = OVRMirrorTextureDesc.__struct((Struct.Member[])new Struct.Member[]{OVRMirrorTextureDesc.__member((int)4), OVRMirrorTextureDesc.__member((int)4), OVRMirrorTextureDesc.__member((int)4), OVRMirrorTextureDesc.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FORMAT = layout.offsetof(0);
        WIDTH = layout.offsetof(1);
        HEIGHT = layout.offsetof(2);
        MISCFLAGS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<OVRMirrorTextureDesc, Buffer>
    implements NativeResource {
        private static final OVRMirrorTextureDesc ELEMENT_FACTORY = OVRMirrorTextureDesc.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected OVRMirrorTextureDesc getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="ovrTextureFormat")
        public int Format() {
            return OVRMirrorTextureDesc.nFormat(this.address());
        }

        public int Width() {
            return OVRMirrorTextureDesc.nWidth(this.address());
        }

        public int Height() {
            return OVRMirrorTextureDesc.nHeight(this.address());
        }

        @NativeType(value="unsigned int")
        public int MiscFlags() {
            return OVRMirrorTextureDesc.nMiscFlags(this.address());
        }

        public Buffer Format(@NativeType(value="ovrTextureFormat") int value) {
            OVRMirrorTextureDesc.nFormat(this.address(), value);
            return this;
        }

        public Buffer Width(int value) {
            OVRMirrorTextureDesc.nWidth(this.address(), value);
            return this;
        }

        public Buffer Height(int value) {
            OVRMirrorTextureDesc.nHeight(this.address(), value);
            return this;
        }

        public Buffer MiscFlags(@NativeType(value="unsigned int") int value) {
            OVRMirrorTextureDesc.nMiscFlags(this.address(), value);
            return this;
        }
    }
}

