/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrSessionStatus")
public class OVRSessionStatus
extends Struct<OVRSessionStatus>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ISVISIBLE;
    public static final int HMDPRESENT;
    public static final int HMDMOUNTED;
    public static final int DISPLAYLOST;
    public static final int SHOULDQUIT;
    public static final int SHOULDRECENTER;
    public static final int HASINPUTFOCUS;
    public static final int OVERLAYPRESENT;
    public static final int DEPTHREQUESTED;

    protected OVRSessionStatus(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected OVRSessionStatus create(long address, @Nullable ByteBuffer container) {
        return new OVRSessionStatus(address, container);
    }

    public OVRSessionStatus(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OVRSessionStatus.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrBool")
    public boolean IsVisible() {
        return OVRSessionStatus.nIsVisible(this.address());
    }

    @NativeType(value="ovrBool")
    public boolean HmdPresent() {
        return OVRSessionStatus.nHmdPresent(this.address());
    }

    @NativeType(value="ovrBool")
    public boolean HmdMounted() {
        return OVRSessionStatus.nHmdMounted(this.address());
    }

    @NativeType(value="ovrBool")
    public boolean DisplayLost() {
        return OVRSessionStatus.nDisplayLost(this.address());
    }

    @NativeType(value="ovrBool")
    public boolean ShouldQuit() {
        return OVRSessionStatus.nShouldQuit(this.address());
    }

    @NativeType(value="ovrBool")
    public boolean ShouldRecenter() {
        return OVRSessionStatus.nShouldRecenter(this.address());
    }

    @NativeType(value="ovrBool")
    public boolean HasInputFocus() {
        return OVRSessionStatus.nHasInputFocus(this.address());
    }

    @NativeType(value="ovrBool")
    public boolean OverlayPresent() {
        return OVRSessionStatus.nOverlayPresent(this.address());
    }

    @NativeType(value="ovrBool")
    public boolean DepthRequested() {
        return OVRSessionStatus.nDepthRequested(this.address());
    }

    public static OVRSessionStatus malloc() {
        return new OVRSessionStatus(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static OVRSessionStatus calloc() {
        return new OVRSessionStatus(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static OVRSessionStatus create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new OVRSessionStatus(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static OVRSessionStatus create(long address) {
        return new OVRSessionStatus(address, null);
    }

    public static @Nullable OVRSessionStatus createSafe(long address) {
        return address == 0L ? null : new OVRSessionStatus(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)OVRSessionStatus.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRSessionStatus.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static OVRSessionStatus mallocStack() {
        return OVRSessionStatus.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRSessionStatus callocStack() {
        return OVRSessionStatus.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRSessionStatus mallocStack(MemoryStack stack) {
        return OVRSessionStatus.malloc(stack);
    }

    @Deprecated
    public static OVRSessionStatus callocStack(MemoryStack stack) {
        return OVRSessionStatus.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRSessionStatus.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRSessionStatus.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRSessionStatus.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRSessionStatus.calloc(capacity, stack);
    }

    public static OVRSessionStatus malloc(MemoryStack stack) {
        return new OVRSessionStatus(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static OVRSessionStatus calloc(MemoryStack stack) {
        return new OVRSessionStatus(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static boolean nIsVisible(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)ISVISIBLE)) != 0;
    }

    public static boolean nHmdPresent(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)HMDPRESENT)) != 0;
    }

    public static boolean nHmdMounted(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)HMDMOUNTED)) != 0;
    }

    public static boolean nDisplayLost(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)DISPLAYLOST)) != 0;
    }

    public static boolean nShouldQuit(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)SHOULDQUIT)) != 0;
    }

    public static boolean nShouldRecenter(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)SHOULDRECENTER)) != 0;
    }

    public static boolean nHasInputFocus(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)HASINPUTFOCUS)) != 0;
    }

    public static boolean nOverlayPresent(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)OVERLAYPRESENT)) != 0;
    }

    public static boolean nDepthRequested(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)DEPTHREQUESTED)) != 0;
    }

    static {
        Struct.Layout layout = OVRSessionStatus.__struct((Struct.Member[])new Struct.Member[]{OVRSessionStatus.__member((int)1), OVRSessionStatus.__member((int)1), OVRSessionStatus.__member((int)1), OVRSessionStatus.__member((int)1), OVRSessionStatus.__member((int)1), OVRSessionStatus.__member((int)1), OVRSessionStatus.__member((int)1), OVRSessionStatus.__member((int)1), OVRSessionStatus.__member((int)1)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ISVISIBLE = layout.offsetof(0);
        HMDPRESENT = layout.offsetof(1);
        HMDMOUNTED = layout.offsetof(2);
        DISPLAYLOST = layout.offsetof(3);
        SHOULDQUIT = layout.offsetof(4);
        SHOULDRECENTER = layout.offsetof(5);
        HASINPUTFOCUS = layout.offsetof(6);
        OVERLAYPRESENT = layout.offsetof(7);
        DEPTHREQUESTED = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<OVRSessionStatus, Buffer>
    implements NativeResource {
        private static final OVRSessionStatus ELEMENT_FACTORY = OVRSessionStatus.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected OVRSessionStatus getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="ovrBool")
        public boolean IsVisible() {
            return OVRSessionStatus.nIsVisible(this.address());
        }

        @NativeType(value="ovrBool")
        public boolean HmdPresent() {
            return OVRSessionStatus.nHmdPresent(this.address());
        }

        @NativeType(value="ovrBool")
        public boolean HmdMounted() {
            return OVRSessionStatus.nHmdMounted(this.address());
        }

        @NativeType(value="ovrBool")
        public boolean DisplayLost() {
            return OVRSessionStatus.nDisplayLost(this.address());
        }

        @NativeType(value="ovrBool")
        public boolean ShouldQuit() {
            return OVRSessionStatus.nShouldQuit(this.address());
        }

        @NativeType(value="ovrBool")
        public boolean ShouldRecenter() {
            return OVRSessionStatus.nShouldRecenter(this.address());
        }

        @NativeType(value="ovrBool")
        public boolean HasInputFocus() {
            return OVRSessionStatus.nHasInputFocus(this.address());
        }

        @NativeType(value="ovrBool")
        public boolean OverlayPresent() {
            return OVRSessionStatus.nOverlayPresent(this.address());
        }

        @NativeType(value="ovrBool")
        public boolean DepthRequested() {
            return OVRSessionStatus.nDepthRequested(this.address());
        }
    }
}

