/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrTrackerDesc")
public class OVRTrackerDesc
extends Struct<OVRTrackerDesc>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FRUSTUMHFOVINRADIANS;
    public static final int FRUSTUMVFOVINRADIANS;
    public static final int FRUSTUMNEARZINMETERS;
    public static final int FRUSTUMFARZINMETERS;

    protected OVRTrackerDesc(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected OVRTrackerDesc create(long address, @Nullable ByteBuffer container) {
        return new OVRTrackerDesc(address, container);
    }

    public OVRTrackerDesc(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OVRTrackerDesc.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float FrustumHFovInRadians() {
        return OVRTrackerDesc.nFrustumHFovInRadians(this.address());
    }

    public float FrustumVFovInRadians() {
        return OVRTrackerDesc.nFrustumVFovInRadians(this.address());
    }

    public float FrustumNearZInMeters() {
        return OVRTrackerDesc.nFrustumNearZInMeters(this.address());
    }

    public float FrustumFarZInMeters() {
        return OVRTrackerDesc.nFrustumFarZInMeters(this.address());
    }

    public static OVRTrackerDesc malloc() {
        return new OVRTrackerDesc(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static OVRTrackerDesc calloc() {
        return new OVRTrackerDesc(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static OVRTrackerDesc create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new OVRTrackerDesc(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static OVRTrackerDesc create(long address) {
        return new OVRTrackerDesc(address, null);
    }

    public static @Nullable OVRTrackerDesc createSafe(long address) {
        return address == 0L ? null : new OVRTrackerDesc(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)OVRTrackerDesc.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRTrackerDesc.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static OVRTrackerDesc mallocStack() {
        return OVRTrackerDesc.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRTrackerDesc callocStack() {
        return OVRTrackerDesc.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRTrackerDesc mallocStack(MemoryStack stack) {
        return OVRTrackerDesc.malloc(stack);
    }

    @Deprecated
    public static OVRTrackerDesc callocStack(MemoryStack stack) {
        return OVRTrackerDesc.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRTrackerDesc.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRTrackerDesc.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRTrackerDesc.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRTrackerDesc.calloc(capacity, stack);
    }

    public static OVRTrackerDesc malloc(MemoryStack stack) {
        return new OVRTrackerDesc(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static OVRTrackerDesc calloc(MemoryStack stack) {
        return new OVRTrackerDesc(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nFrustumHFovInRadians(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)FRUSTUMHFOVINRADIANS));
    }

    public static float nFrustumVFovInRadians(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)FRUSTUMVFOVINRADIANS));
    }

    public static float nFrustumNearZInMeters(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)FRUSTUMNEARZINMETERS));
    }

    public static float nFrustumFarZInMeters(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)FRUSTUMFARZINMETERS));
    }

    static {
        Struct.Layout layout = OVRTrackerDesc.__struct((int)DEFAULT_PACK_ALIGNMENT, (int)POINTER_SIZE, (Struct.Member[])new Struct.Member[]{OVRTrackerDesc.__member((int)4), OVRTrackerDesc.__member((int)4), OVRTrackerDesc.__member((int)4), OVRTrackerDesc.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FRUSTUMHFOVINRADIANS = layout.offsetof(0);
        FRUSTUMVFOVINRADIANS = layout.offsetof(1);
        FRUSTUMNEARZINMETERS = layout.offsetof(2);
        FRUSTUMFARZINMETERS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<OVRTrackerDesc, Buffer>
    implements NativeResource {
        private static final OVRTrackerDesc ELEMENT_FACTORY = OVRTrackerDesc.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected OVRTrackerDesc getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float FrustumHFovInRadians() {
            return OVRTrackerDesc.nFrustumHFovInRadians(this.address());
        }

        public float FrustumVFovInRadians() {
            return OVRTrackerDesc.nFrustumVFovInRadians(this.address());
        }

        public float FrustumNearZInMeters() {
            return OVRTrackerDesc.nFrustumNearZInMeters(this.address());
        }

        public float FrustumFarZInMeters() {
            return OVRTrackerDesc.nFrustumFarZInMeters(this.address());
        }
    }
}

