/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRPosef;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrTrackerPose")
public class OVRTrackerPose
extends Struct<OVRTrackerPose>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TRACKERFLAGS;
    public static final int POSE;
    public static final int LEVELEDPOSE;

    protected OVRTrackerPose(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected OVRTrackerPose create(long address, @Nullable ByteBuffer container) {
        return new OVRTrackerPose(address, container);
    }

    public OVRTrackerPose(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OVRTrackerPose.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int TrackerFlags() {
        return OVRTrackerPose.nTrackerFlags(this.address());
    }

    @NativeType(value="ovrPosef")
    public OVRPosef Pose() {
        return OVRTrackerPose.nPose(this.address());
    }

    @NativeType(value="ovrPosef")
    public OVRPosef LeveledPose() {
        return OVRTrackerPose.nLeveledPose(this.address());
    }

    public static OVRTrackerPose malloc() {
        return new OVRTrackerPose(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static OVRTrackerPose calloc() {
        return new OVRTrackerPose(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static OVRTrackerPose create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new OVRTrackerPose(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static OVRTrackerPose create(long address) {
        return new OVRTrackerPose(address, null);
    }

    public static @Nullable OVRTrackerPose createSafe(long address) {
        return address == 0L ? null : new OVRTrackerPose(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)OVRTrackerPose.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRTrackerPose.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static OVRTrackerPose mallocStack() {
        return OVRTrackerPose.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRTrackerPose callocStack() {
        return OVRTrackerPose.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRTrackerPose mallocStack(MemoryStack stack) {
        return OVRTrackerPose.malloc(stack);
    }

    @Deprecated
    public static OVRTrackerPose callocStack(MemoryStack stack) {
        return OVRTrackerPose.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRTrackerPose.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRTrackerPose.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRTrackerPose.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRTrackerPose.calloc(capacity, stack);
    }

    public static OVRTrackerPose malloc(MemoryStack stack) {
        return new OVRTrackerPose(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static OVRTrackerPose calloc(MemoryStack stack) {
        return new OVRTrackerPose(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nTrackerFlags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TRACKERFLAGS));
    }

    public static OVRPosef nPose(long struct) {
        return OVRPosef.create(struct + (long)POSE);
    }

    public static OVRPosef nLeveledPose(long struct) {
        return OVRPosef.create(struct + (long)LEVELEDPOSE);
    }

    static {
        Struct.Layout layout = OVRTrackerPose.__struct((int)DEFAULT_PACK_ALIGNMENT, (int)8, (Struct.Member[])new Struct.Member[]{OVRTrackerPose.__member((int)4), OVRTrackerPose.__member((int)OVRPosef.SIZEOF, (int)OVRPosef.ALIGNOF), OVRTrackerPose.__member((int)OVRPosef.SIZEOF, (int)OVRPosef.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TRACKERFLAGS = layout.offsetof(0);
        POSE = layout.offsetof(1);
        LEVELEDPOSE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<OVRTrackerPose, Buffer>
    implements NativeResource {
        private static final OVRTrackerPose ELEMENT_FACTORY = OVRTrackerPose.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected OVRTrackerPose getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int TrackerFlags() {
            return OVRTrackerPose.nTrackerFlags(this.address());
        }

        @NativeType(value="ovrPosef")
        public OVRPosef Pose() {
            return OVRTrackerPose.nPose(this.address());
        }

        @NativeType(value="ovrPosef")
        public OVRPosef LeveledPose() {
            return OVRTrackerPose.nLeveledPose(this.address());
        }
    }
}

