/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrVector2i")
public class OVRVector2i
extends Struct<OVRVector2i>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;

    protected OVRVector2i(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected OVRVector2i create(long address, @Nullable ByteBuffer container) {
        return new OVRVector2i(address, container);
    }

    public OVRVector2i(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OVRVector2i.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public int x() {
        return OVRVector2i.nx(this.address());
    }

    public int y() {
        return OVRVector2i.ny(this.address());
    }

    public OVRVector2i x(int value) {
        OVRVector2i.nx(this.address(), value);
        return this;
    }

    public OVRVector2i y(int value) {
        OVRVector2i.ny(this.address(), value);
        return this;
    }

    public OVRVector2i set(int x, int y) {
        this.x(x);
        this.y(y);
        return this;
    }

    public OVRVector2i set(OVRVector2i src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static OVRVector2i malloc() {
        return new OVRVector2i(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static OVRVector2i calloc() {
        return new OVRVector2i(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static OVRVector2i create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new OVRVector2i(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static OVRVector2i create(long address) {
        return new OVRVector2i(address, null);
    }

    public static @Nullable OVRVector2i createSafe(long address) {
        return address == 0L ? null : new OVRVector2i(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)OVRVector2i.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRVector2i.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static OVRVector2i mallocStack() {
        return OVRVector2i.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRVector2i callocStack() {
        return OVRVector2i.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static OVRVector2i mallocStack(MemoryStack stack) {
        return OVRVector2i.malloc(stack);
    }

    @Deprecated
    public static OVRVector2i callocStack(MemoryStack stack) {
        return OVRVector2i.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return OVRVector2i.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return OVRVector2i.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return OVRVector2i.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return OVRVector2i.calloc(capacity, stack);
    }

    public static OVRVector2i malloc(MemoryStack stack) {
        return new OVRVector2i(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static OVRVector2i calloc(MemoryStack stack) {
        return new OVRVector2i(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nx(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)X));
    }

    public static int ny(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)Y));
    }

    public static void nx(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)X), (int)value);
    }

    public static void ny(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)Y), (int)value);
    }

    static {
        Struct.Layout layout = OVRVector2i.__struct((Struct.Member[])new Struct.Member[]{OVRVector2i.__member((int)4), OVRVector2i.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<OVRVector2i, Buffer>
    implements NativeResource {
        private static final OVRVector2i ELEMENT_FACTORY = OVRVector2i.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected OVRVector2i getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int x() {
            return OVRVector2i.nx(this.address());
        }

        public int y() {
            return OVRVector2i.ny(this.address());
        }

        public Buffer x(int value) {
            OVRVector2i.nx(this.address(), value);
            return this;
        }

        public Buffer y(int value) {
            OVRVector2i.ny(this.address(), value);
            return this;
        }
    }
}

