/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.rpmalloc;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct rpmalloc_thread_statistics_t")
public class RPmallocThreadStatistics
extends Struct<RPmallocThreadStatistics>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SIZECACHE;
    public static final int SPANCACHE;
    public static final int THREAD_TO_GLOBAL;
    public static final int GLOBAL_TO_THREAD;
    public static final int SPAN_USE;
    public static final int SIZE_USE;

    protected RPmallocThreadStatistics(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected RPmallocThreadStatistics create(long address, @Nullable ByteBuffer container) {
        return new RPmallocThreadStatistics(address, container);
    }

    public RPmallocThreadStatistics(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), RPmallocThreadStatistics.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="size_t")
    public long sizecache() {
        return RPmallocThreadStatistics.nsizecache(this.address());
    }

    @NativeType(value="size_t")
    public long spancache() {
        return RPmallocThreadStatistics.nspancache(this.address());
    }

    @NativeType(value="size_t")
    public long thread_to_global() {
        return RPmallocThreadStatistics.nthread_to_global(this.address());
    }

    @NativeType(value="size_t")
    public long global_to_thread() {
        return RPmallocThreadStatistics.nglobal_to_thread(this.address());
    }

    @NativeType(value="*[64]")
    public span_use.Buffer span_use() {
        return RPmallocThreadStatistics.nspan_use(this.address());
    }

    @NativeType(value="*")
    public span_use span_use(int index) {
        return RPmallocThreadStatistics.nspan_use(this.address(), index);
    }

    @NativeType(value="*[128]")
    public size_use.Buffer size_use() {
        return RPmallocThreadStatistics.nsize_use(this.address());
    }

    @NativeType(value="*")
    public size_use size_use(int index) {
        return RPmallocThreadStatistics.nsize_use(this.address(), index);
    }

    public static RPmallocThreadStatistics malloc() {
        return new RPmallocThreadStatistics(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static RPmallocThreadStatistics calloc() {
        return new RPmallocThreadStatistics(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static RPmallocThreadStatistics create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new RPmallocThreadStatistics(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static RPmallocThreadStatistics create(long address) {
        return new RPmallocThreadStatistics(address, null);
    }

    public static @Nullable RPmallocThreadStatistics createSafe(long address) {
        return address == 0L ? null : new RPmallocThreadStatistics(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)RPmallocThreadStatistics.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = RPmallocThreadStatistics.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static RPmallocThreadStatistics mallocStack() {
        return RPmallocThreadStatistics.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static RPmallocThreadStatistics callocStack() {
        return RPmallocThreadStatistics.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static RPmallocThreadStatistics mallocStack(MemoryStack stack) {
        return RPmallocThreadStatistics.malloc(stack);
    }

    @Deprecated
    public static RPmallocThreadStatistics callocStack(MemoryStack stack) {
        return RPmallocThreadStatistics.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return RPmallocThreadStatistics.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return RPmallocThreadStatistics.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return RPmallocThreadStatistics.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return RPmallocThreadStatistics.calloc(capacity, stack);
    }

    public static RPmallocThreadStatistics malloc(MemoryStack stack) {
        return new RPmallocThreadStatistics(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static RPmallocThreadStatistics calloc(MemoryStack stack) {
        return new RPmallocThreadStatistics(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nsizecache(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SIZECACHE));
    }

    public static long nspancache(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SPANCACHE));
    }

    public static long nthread_to_global(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)THREAD_TO_GLOBAL));
    }

    public static long nglobal_to_thread(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)GLOBAL_TO_THREAD));
    }

    public static span_use.Buffer nspan_use(long struct) {
        return span_use.create(struct + (long)SPAN_USE, 64);
    }

    public static span_use nspan_use(long struct, int index) {
        return span_use.create(struct + (long)SPAN_USE + Checks.check((int)index, (int)64) * (long)span_use.SIZEOF);
    }

    public static size_use.Buffer nsize_use(long struct) {
        return size_use.create(struct + (long)SIZE_USE, 128);
    }

    public static size_use nsize_use(long struct, int index) {
        return size_use.create(struct + (long)SIZE_USE + Checks.check((int)index, (int)128) * (long)size_use.SIZEOF);
    }

    static {
        Struct.Layout layout = RPmallocThreadStatistics.__struct((Struct.Member[])new Struct.Member[]{RPmallocThreadStatistics.__member((int)POINTER_SIZE), RPmallocThreadStatistics.__member((int)POINTER_SIZE), RPmallocThreadStatistics.__member((int)POINTER_SIZE), RPmallocThreadStatistics.__member((int)POINTER_SIZE), RPmallocThreadStatistics.__array((int)span_use.SIZEOF, (int)span_use.ALIGNOF, (int)64), RPmallocThreadStatistics.__array((int)size_use.SIZEOF, (int)size_use.ALIGNOF, (int)128)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SIZECACHE = layout.offsetof(0);
        SPANCACHE = layout.offsetof(1);
        THREAD_TO_GLOBAL = layout.offsetof(2);
        GLOBAL_TO_THREAD = layout.offsetof(3);
        SPAN_USE = layout.offsetof(4);
        SIZE_USE = layout.offsetof(5);
    }

    @NativeType(value="struct")
    public static class size_use
    extends Struct<size_use> {
        public static final int SIZEOF;
        public static final int ALIGNOF;
        public static final int ALLOC_CURRENT;
        public static final int ALLOC_PEAK;
        public static final int ALLOC_TOTAL;
        public static final int FREE_TOTAL;
        public static final int SPANS_TO_CACHE;
        public static final int SPANS_FROM_CACHE;
        public static final int SPANS_FROM_RESERVED;
        public static final int MAP_CALLS;

        protected size_use(long address, @Nullable ByteBuffer container) {
            super(address, container);
        }

        protected size_use create(long address, @Nullable ByteBuffer container) {
            return new size_use(address, container);
        }

        public size_use(ByteBuffer container) {
            super(MemoryUtil.memAddress((ByteBuffer)container), size_use.__checkContainer((ByteBuffer)container, (int)SIZEOF));
        }

        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="size_t")
        public long alloc_current() {
            return size_use.nalloc_current(this.address());
        }

        @NativeType(value="size_t")
        public long alloc_peak() {
            return size_use.nalloc_peak(this.address());
        }

        @NativeType(value="size_t")
        public long alloc_total() {
            return size_use.nalloc_total(this.address());
        }

        @NativeType(value="size_t")
        public long free_total() {
            return size_use.nfree_total(this.address());
        }

        @NativeType(value="size_t")
        public long spans_to_cache() {
            return size_use.nspans_to_cache(this.address());
        }

        @NativeType(value="size_t")
        public long spans_from_cache() {
            return size_use.nspans_from_cache(this.address());
        }

        @NativeType(value="size_t")
        public long spans_from_reserved() {
            return size_use.nspans_from_reserved(this.address());
        }

        @NativeType(value="size_t")
        public long map_calls() {
            return size_use.nmap_calls(this.address());
        }

        public static size_use create(long address) {
            return new size_use(address, null);
        }

        public static @Nullable size_use createSafe(long address) {
            return address == 0L ? null : new size_use(address, null);
        }

        public static Buffer create(long address, int capacity) {
            return new Buffer(address, capacity);
        }

        public static @Nullable Buffer createSafe(long address, int capacity) {
            return address == 0L ? null : new Buffer(address, capacity);
        }

        public static long nalloc_current(long struct) {
            return MemoryUtil.memGetAddress((long)(struct + (long)ALLOC_CURRENT));
        }

        public static long nalloc_peak(long struct) {
            return MemoryUtil.memGetAddress((long)(struct + (long)ALLOC_PEAK));
        }

        public static long nalloc_total(long struct) {
            return MemoryUtil.memGetAddress((long)(struct + (long)ALLOC_TOTAL));
        }

        public static long nfree_total(long struct) {
            return MemoryUtil.memGetAddress((long)(struct + (long)FREE_TOTAL));
        }

        public static long nspans_to_cache(long struct) {
            return MemoryUtil.memGetAddress((long)(struct + (long)SPANS_TO_CACHE));
        }

        public static long nspans_from_cache(long struct) {
            return MemoryUtil.memGetAddress((long)(struct + (long)SPANS_FROM_CACHE));
        }

        public static long nspans_from_reserved(long struct) {
            return MemoryUtil.memGetAddress((long)(struct + (long)SPANS_FROM_RESERVED));
        }

        public static long nmap_calls(long struct) {
            return MemoryUtil.memGetAddress((long)(struct + (long)MAP_CALLS));
        }

        static {
            Struct.Layout layout = size_use.__struct((Struct.Member[])new Struct.Member[]{size_use.__member((int)POINTER_SIZE), size_use.__member((int)POINTER_SIZE), size_use.__member((int)POINTER_SIZE), size_use.__member((int)POINTER_SIZE), size_use.__member((int)POINTER_SIZE), size_use.__member((int)POINTER_SIZE), size_use.__member((int)POINTER_SIZE), size_use.__member((int)POINTER_SIZE)});
            SIZEOF = layout.getSize();
            ALIGNOF = layout.getAlignment();
            ALLOC_CURRENT = layout.offsetof(0);
            ALLOC_PEAK = layout.offsetof(1);
            ALLOC_TOTAL = layout.offsetof(2);
            FREE_TOTAL = layout.offsetof(3);
            SPANS_TO_CACHE = layout.offsetof(4);
            SPANS_FROM_CACHE = layout.offsetof(5);
            SPANS_FROM_RESERVED = layout.offsetof(6);
            MAP_CALLS = layout.offsetof(7);
        }

        public static class Buffer
        extends StructBuffer<size_use, Buffer> {
            private static final size_use ELEMENT_FACTORY = size_use.create(-1L);

            public Buffer(ByteBuffer container) {
                super(container, container.remaining() / SIZEOF);
            }

            public Buffer(long address, int cap) {
                super(address, null, -1, 0, cap, cap);
            }

            Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
                super(address, container, mark, pos, lim, cap);
            }

            protected Buffer self() {
                return this;
            }

            protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
                return new Buffer(address, container, mark, position, limit, capacity);
            }

            protected size_use getElementFactory() {
                return ELEMENT_FACTORY;
            }

            @NativeType(value="size_t")
            public long alloc_current() {
                return size_use.nalloc_current(this.address());
            }

            @NativeType(value="size_t")
            public long alloc_peak() {
                return size_use.nalloc_peak(this.address());
            }

            @NativeType(value="size_t")
            public long alloc_total() {
                return size_use.nalloc_total(this.address());
            }

            @NativeType(value="size_t")
            public long free_total() {
                return size_use.nfree_total(this.address());
            }

            @NativeType(value="size_t")
            public long spans_to_cache() {
                return size_use.nspans_to_cache(this.address());
            }

            @NativeType(value="size_t")
            public long spans_from_cache() {
                return size_use.nspans_from_cache(this.address());
            }

            @NativeType(value="size_t")
            public long spans_from_reserved() {
                return size_use.nspans_from_reserved(this.address());
            }

            @NativeType(value="size_t")
            public long map_calls() {
                return size_use.nmap_calls(this.address());
            }
        }
    }

    @NativeType(value="struct")
    public static class span_use
    extends Struct<span_use> {
        public static final int SIZEOF;
        public static final int ALIGNOF;
        public static final int CURRENT;
        public static final int PEAK;
        public static final int TO_GLOBAL;
        public static final int FROM_GLOBAL;
        public static final int TO_CACHE;
        public static final int FROM_CACHE;
        public static final int TO_RESERVED;
        public static final int FROM_RESERVED;
        public static final int MAP_CALLS;

        protected span_use(long address, @Nullable ByteBuffer container) {
            super(address, container);
        }

        protected span_use create(long address, @Nullable ByteBuffer container) {
            return new span_use(address, container);
        }

        public span_use(ByteBuffer container) {
            super(MemoryUtil.memAddress((ByteBuffer)container), span_use.__checkContainer((ByteBuffer)container, (int)SIZEOF));
        }

        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="size_t")
        public long current() {
            return span_use.ncurrent(this.address());
        }

        @NativeType(value="size_t")
        public long peak() {
            return span_use.npeak(this.address());
        }

        @NativeType(value="size_t")
        public long to_global() {
            return span_use.nto_global(this.address());
        }

        @NativeType(value="size_t")
        public long from_global() {
            return span_use.nfrom_global(this.address());
        }

        @NativeType(value="size_t")
        public long to_cache() {
            return span_use.nto_cache(this.address());
        }

        @NativeType(value="size_t")
        public long from_cache() {
            return span_use.nfrom_cache(this.address());
        }

        @NativeType(value="size_t")
        public long to_reserved() {
            return span_use.nto_reserved(this.address());
        }

        @NativeType(value="size_t")
        public long from_reserved() {
            return span_use.nfrom_reserved(this.address());
        }

        @NativeType(value="size_t")
        public long map_calls() {
            return span_use.nmap_calls(this.address());
        }

        public static span_use create(long address) {
            return new span_use(address, null);
        }

        public static @Nullable span_use createSafe(long address) {
            return address == 0L ? null : new span_use(address, null);
        }

        public static Buffer create(long address, int capacity) {
            return new Buffer(address, capacity);
        }

        public static @Nullable Buffer createSafe(long address, int capacity) {
            return address == 0L ? null : new Buffer(address, capacity);
        }

        public static long ncurrent(long struct) {
            return MemoryUtil.memGetAddress((long)(struct + (long)CURRENT));
        }

        public static long npeak(long struct) {
            return MemoryUtil.memGetAddress((long)(struct + (long)PEAK));
        }

        public static long nto_global(long struct) {
            return MemoryUtil.memGetAddress((long)(struct + (long)TO_GLOBAL));
        }

        public static long nfrom_global(long struct) {
            return MemoryUtil.memGetAddress((long)(struct + (long)FROM_GLOBAL));
        }

        public static long nto_cache(long struct) {
            return MemoryUtil.memGetAddress((long)(struct + (long)TO_CACHE));
        }

        public static long nfrom_cache(long struct) {
            return MemoryUtil.memGetAddress((long)(struct + (long)FROM_CACHE));
        }

        public static long nto_reserved(long struct) {
            return MemoryUtil.memGetAddress((long)(struct + (long)TO_RESERVED));
        }

        public static long nfrom_reserved(long struct) {
            return MemoryUtil.memGetAddress((long)(struct + (long)FROM_RESERVED));
        }

        public static long nmap_calls(long struct) {
            return MemoryUtil.memGetAddress((long)(struct + (long)MAP_CALLS));
        }

        static {
            Struct.Layout layout = span_use.__struct((Struct.Member[])new Struct.Member[]{span_use.__member((int)POINTER_SIZE), span_use.__member((int)POINTER_SIZE), span_use.__member((int)POINTER_SIZE), span_use.__member((int)POINTER_SIZE), span_use.__member((int)POINTER_SIZE), span_use.__member((int)POINTER_SIZE), span_use.__member((int)POINTER_SIZE), span_use.__member((int)POINTER_SIZE), span_use.__member((int)POINTER_SIZE)});
            SIZEOF = layout.getSize();
            ALIGNOF = layout.getAlignment();
            CURRENT = layout.offsetof(0);
            PEAK = layout.offsetof(1);
            TO_GLOBAL = layout.offsetof(2);
            FROM_GLOBAL = layout.offsetof(3);
            TO_CACHE = layout.offsetof(4);
            FROM_CACHE = layout.offsetof(5);
            TO_RESERVED = layout.offsetof(6);
            FROM_RESERVED = layout.offsetof(7);
            MAP_CALLS = layout.offsetof(8);
        }

        public static class Buffer
        extends StructBuffer<span_use, Buffer> {
            private static final span_use ELEMENT_FACTORY = span_use.create(-1L);

            public Buffer(ByteBuffer container) {
                super(container, container.remaining() / SIZEOF);
            }

            public Buffer(long address, int cap) {
                super(address, null, -1, 0, cap, cap);
            }

            Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
                super(address, container, mark, pos, lim, cap);
            }

            protected Buffer self() {
                return this;
            }

            protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
                return new Buffer(address, container, mark, position, limit, capacity);
            }

            protected span_use getElementFactory() {
                return ELEMENT_FACTORY;
            }

            @NativeType(value="size_t")
            public long current() {
                return span_use.ncurrent(this.address());
            }

            @NativeType(value="size_t")
            public long peak() {
                return span_use.npeak(this.address());
            }

            @NativeType(value="size_t")
            public long to_global() {
                return span_use.nto_global(this.address());
            }

            @NativeType(value="size_t")
            public long from_global() {
                return span_use.nfrom_global(this.address());
            }

            @NativeType(value="size_t")
            public long to_cache() {
                return span_use.nto_cache(this.address());
            }

            @NativeType(value="size_t")
            public long from_cache() {
                return span_use.nfrom_cache(this.address());
            }

            @NativeType(value="size_t")
            public long to_reserved() {
                return span_use.nto_reserved(this.address());
            }

            @NativeType(value="size_t")
            public long from_reserved() {
                return span_use.nfrom_reserved(this.address());
            }

            @NativeType(value="size_t")
            public long map_calls() {
                return span_use.nmap_calls(this.address());
            }
        }
    }

    public static class Buffer
    extends StructBuffer<RPmallocThreadStatistics, Buffer>
    implements NativeResource {
        private static final RPmallocThreadStatistics ELEMENT_FACTORY = RPmallocThreadStatistics.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected RPmallocThreadStatistics getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="size_t")
        public long sizecache() {
            return RPmallocThreadStatistics.nsizecache(this.address());
        }

        @NativeType(value="size_t")
        public long spancache() {
            return RPmallocThreadStatistics.nspancache(this.address());
        }

        @NativeType(value="size_t")
        public long thread_to_global() {
            return RPmallocThreadStatistics.nthread_to_global(this.address());
        }

        @NativeType(value="size_t")
        public long global_to_thread() {
            return RPmallocThreadStatistics.nglobal_to_thread(this.address());
        }

        @NativeType(value="*[64]")
        public span_use.Buffer span_use() {
            return RPmallocThreadStatistics.nspan_use(this.address());
        }

        @NativeType(value="*")
        public span_use span_use(int index) {
            return RPmallocThreadStatistics.nspan_use(this.address(), index);
        }

        @NativeType(value="*[128]")
        public size_use.Buffer size_use() {
            return RPmallocThreadStatistics.nsize_use(this.address());
        }

        @NativeType(value="*")
        public size_use size_use(int index) {
            return RPmallocThreadStatistics.nsize_use(this.address(), index);
        }
    }
}

