/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spvc;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct spvc_combined_image_sampler")
public class SpvcCombinedImageSampler
extends Struct<SpvcCombinedImageSampler>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int COMBINED_ID;
    public static final int IMAGE_ID;
    public static final int SAMPLER_ID;

    protected SpvcCombinedImageSampler(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected SpvcCombinedImageSampler create(long address, @Nullable ByteBuffer container) {
        return new SpvcCombinedImageSampler(address, container);
    }

    public SpvcCombinedImageSampler(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SpvcCombinedImageSampler.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="spvc_variable_id")
    public int combined_id() {
        return SpvcCombinedImageSampler.ncombined_id(this.address());
    }

    @NativeType(value="spvc_variable_id")
    public int image_id() {
        return SpvcCombinedImageSampler.nimage_id(this.address());
    }

    @NativeType(value="spvc_variable_id")
    public int sampler_id() {
        return SpvcCombinedImageSampler.nsampler_id(this.address());
    }

    public SpvcCombinedImageSampler combined_id(@NativeType(value="spvc_variable_id") int value) {
        SpvcCombinedImageSampler.ncombined_id(this.address(), value);
        return this;
    }

    public SpvcCombinedImageSampler image_id(@NativeType(value="spvc_variable_id") int value) {
        SpvcCombinedImageSampler.nimage_id(this.address(), value);
        return this;
    }

    public SpvcCombinedImageSampler sampler_id(@NativeType(value="spvc_variable_id") int value) {
        SpvcCombinedImageSampler.nsampler_id(this.address(), value);
        return this;
    }

    public SpvcCombinedImageSampler set(int combined_id, int image_id, int sampler_id) {
        this.combined_id(combined_id);
        this.image_id(image_id);
        this.sampler_id(sampler_id);
        return this;
    }

    public SpvcCombinedImageSampler set(SpvcCombinedImageSampler src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SpvcCombinedImageSampler malloc() {
        return new SpvcCombinedImageSampler(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static SpvcCombinedImageSampler calloc() {
        return new SpvcCombinedImageSampler(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static SpvcCombinedImageSampler create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new SpvcCombinedImageSampler(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static SpvcCombinedImageSampler create(long address) {
        return new SpvcCombinedImageSampler(address, null);
    }

    public static @Nullable SpvcCombinedImageSampler createSafe(long address) {
        return address == 0L ? null : new SpvcCombinedImageSampler(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)SpvcCombinedImageSampler.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SpvcCombinedImageSampler.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SpvcCombinedImageSampler malloc(MemoryStack stack) {
        return new SpvcCombinedImageSampler(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SpvcCombinedImageSampler calloc(MemoryStack stack) {
        return new SpvcCombinedImageSampler(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ncombined_id(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)COMBINED_ID));
    }

    public static int nimage_id(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)IMAGE_ID));
    }

    public static int nsampler_id(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SAMPLER_ID));
    }

    public static void ncombined_id(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)COMBINED_ID), (int)value);
    }

    public static void nimage_id(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)IMAGE_ID), (int)value);
    }

    public static void nsampler_id(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SAMPLER_ID), (int)value);
    }

    static {
        Struct.Layout layout = SpvcCombinedImageSampler.__struct((Struct.Member[])new Struct.Member[]{SpvcCombinedImageSampler.__member((int)4), SpvcCombinedImageSampler.__member((int)4), SpvcCombinedImageSampler.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        COMBINED_ID = layout.offsetof(0);
        IMAGE_ID = layout.offsetof(1);
        SAMPLER_ID = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<SpvcCombinedImageSampler, Buffer>
    implements NativeResource {
        private static final SpvcCombinedImageSampler ELEMENT_FACTORY = SpvcCombinedImageSampler.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected SpvcCombinedImageSampler getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="spvc_variable_id")
        public int combined_id() {
            return SpvcCombinedImageSampler.ncombined_id(this.address());
        }

        @NativeType(value="spvc_variable_id")
        public int image_id() {
            return SpvcCombinedImageSampler.nimage_id(this.address());
        }

        @NativeType(value="spvc_variable_id")
        public int sampler_id() {
            return SpvcCombinedImageSampler.nsampler_id(this.address());
        }

        public Buffer combined_id(@NativeType(value="spvc_variable_id") int value) {
            SpvcCombinedImageSampler.ncombined_id(this.address(), value);
            return this;
        }

        public Buffer image_id(@NativeType(value="spvc_variable_id") int value) {
            SpvcCombinedImageSampler.nimage_id(this.address(), value);
            return this;
        }

        public Buffer sampler_id(@NativeType(value="spvc_variable_id") int value) {
            SpvcCombinedImageSampler.nsampler_id(this.address(), value);
            return this;
        }
    }
}

