/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spvc;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct spvc_hlsl_resource_binding_mapping")
public class SpvcHLSLResourceBindingMapping
extends Struct<SpvcHLSLResourceBindingMapping>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int REGISTER_SPACE;
    public static final int REGISTER_BINDING;

    protected SpvcHLSLResourceBindingMapping(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected SpvcHLSLResourceBindingMapping create(long address, @Nullable ByteBuffer container) {
        return new SpvcHLSLResourceBindingMapping(address, container);
    }

    public SpvcHLSLResourceBindingMapping(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SpvcHLSLResourceBindingMapping.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned")
    public int register_space() {
        return SpvcHLSLResourceBindingMapping.nregister_space(this.address());
    }

    @NativeType(value="unsigned")
    public int register_binding() {
        return SpvcHLSLResourceBindingMapping.nregister_binding(this.address());
    }

    public SpvcHLSLResourceBindingMapping register_space(@NativeType(value="unsigned") int value) {
        SpvcHLSLResourceBindingMapping.nregister_space(this.address(), value);
        return this;
    }

    public SpvcHLSLResourceBindingMapping register_binding(@NativeType(value="unsigned") int value) {
        SpvcHLSLResourceBindingMapping.nregister_binding(this.address(), value);
        return this;
    }

    public SpvcHLSLResourceBindingMapping set(int register_space, int register_binding) {
        this.register_space(register_space);
        this.register_binding(register_binding);
        return this;
    }

    public SpvcHLSLResourceBindingMapping set(SpvcHLSLResourceBindingMapping src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SpvcHLSLResourceBindingMapping malloc() {
        return new SpvcHLSLResourceBindingMapping(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static SpvcHLSLResourceBindingMapping calloc() {
        return new SpvcHLSLResourceBindingMapping(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static SpvcHLSLResourceBindingMapping create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new SpvcHLSLResourceBindingMapping(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static SpvcHLSLResourceBindingMapping create(long address) {
        return new SpvcHLSLResourceBindingMapping(address, null);
    }

    public static @Nullable SpvcHLSLResourceBindingMapping createSafe(long address) {
        return address == 0L ? null : new SpvcHLSLResourceBindingMapping(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)SpvcHLSLResourceBindingMapping.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SpvcHLSLResourceBindingMapping.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SpvcHLSLResourceBindingMapping malloc(MemoryStack stack) {
        return new SpvcHLSLResourceBindingMapping(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SpvcHLSLResourceBindingMapping calloc(MemoryStack stack) {
        return new SpvcHLSLResourceBindingMapping(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nregister_space(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)REGISTER_SPACE));
    }

    public static int nregister_binding(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)REGISTER_BINDING));
    }

    public static void nregister_space(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)REGISTER_SPACE), (int)value);
    }

    public static void nregister_binding(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)REGISTER_BINDING), (int)value);
    }

    static {
        Struct.Layout layout = SpvcHLSLResourceBindingMapping.__struct((Struct.Member[])new Struct.Member[]{SpvcHLSLResourceBindingMapping.__member((int)4), SpvcHLSLResourceBindingMapping.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        REGISTER_SPACE = layout.offsetof(0);
        REGISTER_BINDING = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<SpvcHLSLResourceBindingMapping, Buffer>
    implements NativeResource {
        private static final SpvcHLSLResourceBindingMapping ELEMENT_FACTORY = SpvcHLSLResourceBindingMapping.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected SpvcHLSLResourceBindingMapping getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned")
        public int register_space() {
            return SpvcHLSLResourceBindingMapping.nregister_space(this.address());
        }

        @NativeType(value="unsigned")
        public int register_binding() {
            return SpvcHLSLResourceBindingMapping.nregister_binding(this.address());
        }

        public Buffer register_space(@NativeType(value="unsigned") int value) {
            SpvcHLSLResourceBindingMapping.nregister_space(this.address(), value);
            return this;
        }

        public Buffer register_binding(@NativeType(value="unsigned") int value) {
            SpvcHLSLResourceBindingMapping.nregister_binding(this.address(), value);
            return this;
        }
    }
}

